<table>
    <thead>
        <tr>
            <th>Employee</th>
            <th>Rate</th>
            <th>Gross</th>
            <th>Deductions</th>
            <th>Loans</th>
            <th>Net Pay</th>
        </tr>
    </thead>
    <tbody>
        @foreach ($payrollData as $data)
            @php $payroll = $data['payroll']; @endphp
            <tr>
                <td>{{ $payroll->employee->last_name }}, {{ $payroll->employee->first_name }}</td>
                <td>{{ $payroll->rate }}</td>
                <td>{{ $data['gross'] }}</td>
                <td>{{ $data['deductions'] }}</td>
                <td>{{ $data['loans'] }}</td>
                <td>{{ $payroll->earnings }}</td>
            </tr>
        @endforeach
    </tbody>
</table>

{{-- Spacer row --}}
<tr>
    <td colspan="6"></td>
</tr>

{{-- Summary --}}
<table>
    <thead>
        <tr>
            <th>Transaction</th>
            <th>Earnings</th>
            <th>Deductions</th>
        </tr>
    </thead>
    <tbody>
        @php
            $earningsRows = [];
            $deductionRows = [];
            $totalEarnings = 0;
            $totalDeductions = 0;

            foreach ($payrollData as $data) {
                $payroll = $data['payroll'];

                $basic = $payroll->days_worked_withdeduction * $payroll->rate;
                $earningsRows['Basic Salary'] = ($earningsRows['Basic Salary'] ?? 0) + $basic;
                $totalEarnings += $basic;

                foreach ($payroll->othersForPayroll as $other) {
                    $earningsRows[$other->name] = ($earningsRows[$other->name] ?? 0) + $other->amount;
                    $totalEarnings += $other->amount;
                }

                foreach ($data['benefits'] as $benefit) {
                    $deductionRows[$benefit['type']] = ($deductionRows[$benefit['type']] ?? 0) + $benefit['amount'];
                    $totalDeductions += $benefit['amount'];
                }

                foreach ($data['nonStandardDeductions'] as $ns) {
                    $deductionRows[$ns['type']] = ($deductionRows[$ns['type']] ?? 0) + $ns['amount'];
                    $totalDeductions += $ns['amount'];
                }

                foreach ($payroll->trxConstantDeductions as $deduction) {
                    $desc = $deduction->trxConstant->trxCode->description ?? 'Unknown';
                    if ($deduction->status == 1) {
                        $earningsRows[$desc] = ($earningsRows[$desc] ?? 0) + $deduction->E_Amount;
                        $totalEarnings += $deduction->E_Amount;
                    } else {
                        $deductionRows[$desc] = ($deductionRows[$desc] ?? 0) + $deduction->E_Amount;
                        $totalDeductions += $deduction->E_Amount;
                    }
                }

                foreach ($payroll->trxLoanDeductions as $loan) {
                    $desc = $loan->trxLoan->trxCode->description ?? 'Loan';
                    $deductionRows[$desc] = ($deductionRows[$desc] ?? 0) + $loan->Amount;
                    $totalDeductions += $loan->Amount;
                }
            }

            ksort($earningsRows, SORT_NATURAL | SORT_FLAG_CASE);
            ksort($deductionRows, SORT_NATURAL | SORT_FLAG_CASE);
        @endphp

        @foreach ($earningsRows as $name => $amount)
            <tr>
                <td>{{ $name }}</td>
                <td>{{ $amount }}</td>
                <td></td>
            </tr>
        @endforeach

        @foreach ($deductionRows as $name => $amount)
            <tr>
                <td>{{ $name }}</td>
                <td></td>
                <td>{{ $amount }}</td>
            </tr>
        @endforeach
    </tbody>
    <tfoot>
        <tr>
            <td>Total</td>
            <td>{{ $totalEarnings }}</td>
            <td>{{ $totalDeductions }}</td>
        </tr>
    </tfoot>
</table>
