@include('Admin.Requisition.mrfmodaljs');
@include('Admin.Requisition.js')
<div id="successModal" class="fixed inset-0 z-50 flex items-center justify-center hidden bg-black bg-opacity-50">
    <div class="p-5 bg-white rounded-lg shadow-lg w-96">
        <h2 class="text-lg font-bold text-center">Success</h2>
        <p class="mt-2 text-center text-gray-700"></p>
        <div class="mt-4 text-center">
            <button onclick="closeModal('successModal')"
                class="px-4 py-2 text-white bg-blue-500 rounded-lg hover:bg-blue-700">
                OK
            </button>
        </div>
    </div>
</div>
<div id="deleteModal" class="fixed inset-0 z-50 flex items-start justify-center hidden bg-gray-800 bg-opacity-50">
    <div class="bg-white rounded-lg shadow-lg p-6 w-auto md:w-[30rem] mt-20">
        <h2 class="mb-4 text-lg font-bold">Delete Record</h2>
        <p>Are you sure you want to delete this record?</p>
        <form id="deleteForm">
            @csrf
            <input type="hidden" id="deleteRecordId" name="id">
            <div class="flex justify-end mt-6">
                <button type="button" onclick="closeModal('deleteModal')"
                    class="px-4 py-2 mr-2 text-gray-700 bg-gray-200 rounded">Cancel</button>
                <button type="submit" class="px-4 py-2 text-white bg-red-600 rounded">Delete</button>
            </div>
        </form>
    </div>
</div>
<div class="relative w-full bg-black bg-opacity-80">
    <div id="mrf"
        class=" {{ $errors->any() ? '' : 'hidden' }} overflow-auto  fixed inset-0 z-50 flex items-start justify-center hidden bg-gray-800 bg-opacity-50">
        <div class="max-w-4xl p-8 mx-auto my-10 bg-white border border-gray-200 rounded-lg shadow-md">
            <div class="flex flex-col px-5 py-4 bg-white rounded-2xl">
                <div class="flex items-center justify-between pb-4 border-b border-gray-200">
                    <h4 class="text-sm font-medium text-gray-900">Create New Requisition</h4>
                    <button class="block cursor-pointer close-modal-button" onclick="closeModal('mrf')">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <path d="M7.75732 7.75739L16.2426 16.2427M16.2426 7.75739L7.75732 16.2427" stroke="black"
                                stroke-width="1.6" stroke-linecap="round" />
                        </svg>
                    </button>
                </div>



                <h1 class="mb-6 text-3xl font-bold text-center text-gray-800">Manpower Requisition Form</h1>

                <p class="mb-4 text-gray-600">
                    Notes: This MR has to be filled for all the positions vacant at any level. The MR must have
                    the
                    approval of the Head of Department for the vacant positions. Please complete the requisition
                    thoroughly. The filled MR has to be submitted to the HR department for further actions.
                </p>

                <form action="" id="mrfform" method="POST">
                    @csrf
                    <div id="success-container" class="hidden"></div> <!-- Success Message -->
                    <div id="error-container" class="hidden"></div>
                    <div class="mb-6 text-sm">
                        <div class="mb-5">
                            <label for="toggle-select" class="block mb-2 text-sm font-medium text-gray-700">Choose an
                                option:</label>
                            <select id="toggle-select"
                                class="block w-full px-3 py-2 border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring focus:ring-indigo-500">
                                <option value="">-- Select an Option --</option>
                                <option value="option1">Option 1</option>
                                <option value="option2">Option 2</option>
                            </select>
                        </div>
                        <h2 class="mb-2 text-2xl font-semibold text-gray-700">Manpower Required By:</h2>
                        <div class="grid grid-cols-1 gap-4 sm:grid-cols-2">
                            <div class="mb-5">
                                <label for="toggle-select" class="block mb-2 text-sm font-medium text-gray-700">Select
                                    Store:</label>
                                <select name="store_id"
                                    class="block w-full px-3 py-2 border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring focus:ring-indigo-500">
                                    <option value="">-- Select an Option --</option>
                                    @foreach ($stores as $store)
                                        <option value="{{ $store->id }}">{{ $store->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            @php
                                $auth = Auth::user(); // This will retrieve the currently authenticated user.
                                $user = App\Models\User::find($auth->id);
                            @endphp
                            @if ($auth->role_id == 8)

                                @php
                                    // Get the first department record where user_id matches the authenticated user
                                    $clientauth = App\Models\Department::where('user_id', $auth->id)->first();
                                @endphp
                                <input type="hidden" name="client_id" value="{{ $clientauth->client_id }}">
                                <input type="hidden" name="department_id" value="{{ $clientauth->id }}">
                            @else
                                <div>
                                    <label class="block mb-1 text-gray-600">Select Agency:</label>
                                    <select id="agency" name="agency_id"
                                        class="w-full p-2 border border-gray-300 rounded-md" required>
                                        <option value="" disabled selected>Select an Agency</option>
                                        @foreach ($agencies as $agency)
                                            <option value="{{ $agency->id }}">{{ $agency->name }}</option>
                                        @endforeach
                                    </select>
                                </div>

                                <div>
                                    <label class="block mb-1 text-gray-600">Select Company:</label>
                                    <select id="company" name="client_id"
                                        class="w-full p-2 border border-gray-300 rounded-md" required>
                                        <option value="" disabled selected>Select a Company</option>

                                    </select>
                                </div>

                                <div>
                                    <label class="block mb-1 text-gray-600">Select Client:</label>
                                    <select id="clientAccount" name="department_id"
                                        class="w-full p-2 border border-gray-300 rounded-md" required>
                                        <option value="" disabled selected>Select a Client</option>

                                    </select>
                                </div>
                            @endif

                            <div>
                                <label class="block mb-1 text-gray-600">Designation:</label>
                                <input type="text" name="designation"
                                    class="w-full p-2 border border-gray-300 rounded-md" required>
                            </div>



                            {{-- <div>
                                <label class="block mb-1 text-gray-600">Date:</label>
                                <input type="date" name="date" class="w-full p-2 border border-gray-300 rounded-md"
                                    required>
                            </div> --}}
                        </div>
                    </div>

                    <h2 class="mb-2 text-2xl font-semibold text-gray-700">Manpower Details:</h2>
                    <div id="option1">
                        <h2 class="mb-2 text-sm font-semibold text-gray-700">Stationary</h2>
                    </div>

                    <div id="option2" class="hidden p-3 mt-4 border-2 border-black rounded">
                        <div class="w-full">
                            <h2 class="mb-2 text-sm font-semibold text-gray-700">Roving</h2>
                            <div id="dynamic-input-container" class="w-full">
                                <div class="grid grid-cols-1 gap-10 dynamic-input md:grid-cols-5">
                                    <div class="col-span-2 mb-4">
                                        <label class="block mb-1 text-gray-600">Per Store</label>
                                        <input type="text" name="per_store[]"
                                            class="w-full p-2 border border-gray-300 rounded-md">
                                    </div>
                                    <div class="col-span-2 mb-4">
                                        <label class="block mb-1 text-gray-600">Frequency of Duty</label>
                                        <input type="text" name="frequency[]"
                                            class="w-full p-2 border border-gray-300 rounded-md">
                                    </div>
                                    <div class="flex items-center">
                                        <button type="button"
                                            class="remove-input bg-red-500 text-white w-[5rem] h-[2rem] px-3 py-1 rounded-md hover:bg-red-600">Remove</button>
                                    </div>

                                </div>

                            </div>
                            <button type="button" id="add-input"
                                class="px-3 py-2 mb-2 text-white bg-blue-500 rounded-md hover:bg-blue-600">Add
                                More</button>
                        </div>

                    </div>

                    <div class="mb-6">

                        <div class="grid grid-cols-1 gap-4 sm:grid-cols-2">
                            <div>
                                <label class="block mb-1 text-gray-600">Job Title:</label>
                                <input type="text" name="job_title"
                                    class="w-full p-2 border border-gray-300 rounded-md" required>
                            </div>
                            <div>
                                <label class="block mb-1 text-gray-600">No. of Vacancies:</label>
                                <input type="number" name="vacant_no"
                                    class="w-full p-2 border border-gray-300 rounded-md" required>
                            </div>
                            <div>
                                <label class="block mb-1 text-gray-600">Recruitment Type:</label>
                                <select name="rec_type" class="w-full p-2 border border-gray-300 rounded-md" required>
                                    <option value="project_based">Project Based</option>
                                    <option value="replacement">Replacement</option>
                                    <option value="seasonal">Seasonal</option>
                                    <option value="additional_position">Additional Position</option>
                                </select>
                            </div>
                            <div>
                                <label class="block mb-1 text-gray-600">Budget/Salary Package:</label>
                                <input type="text" name="budget_salary"
                                    class="w-full p-2 border border-gray-300 rounded-md" required>
                            </div>
                            <div>
                                <label class="block mb-1 text-gray-600">Target date:</label>
                                <input type="date" name="filled_date"
                                    class="w-full p-2 border border-gray-300 rounded-md" required>
                            </div>
                            <div>
                                <div class="space-y-2">
                                    <p class="text-sm font-medium text-gray-700">Gender</p>
                                    <div class="flex text-sm p-2  rounded-md items-center space-x-4">
                                        <label class="inline-flex items-center">
                                            <input type="radio" name="gender" value="male"
                                                class="form-radio text-blue-600">
                                            <span class="ml-2   text-gray-700">Male</span>
                                        </label>
                                        <label class="inline-flex items-center">
                                            <input type="radio" name="gender" value="female"
                                                class="form-radio text-pink-600">
                                            <span class="ml-2 text-gray-700">Female</span>
                                        </label>
                                        <label class="inline-flex items-center">
                                            <input type="radio" name="gender" value="other"
                                                class="form-radio text-green-600">
                                            <span class="ml-2 text-gray-700">Both Female and Male</span>
                                        </label>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>


                    <div>
                        <div class="mb-6">
                            <h2 class="mb-2 text-2xl font-semibold text-gray-700">Additional Details:</h2>
                            <div class="mb-4">
                                <label class="block mb-1 text-gray-600">Project Name (if project based):</label>
                                <input type="text" name="project_name"
                                    class="w-full p-2 border border-gray-300 rounded-md">
                            </div>
                            <div class="mb-4">
                                <label class="block mb-1 text-gray-600">Replacement for (name of employee):</label>
                                <input type="text" name="replacement"
                                    class="w-full p-2 border border-gray-300 rounded-md">
                            </div>
                            <div class="mb-4">
                                <label class="block mb-1 text-gray-600">Reasons for Additional Position:</label>
                                <select name="reasons" class="w-full p-2 border border-gray-300 rounded-md" required>
                                    <option value="resignation">Resignation</option>
                                    <option value="termination">Termination</option>
                                    <option value="promotion">Promotion</option>
                                    <option value="transfer">Transfer</option>
                                </select>
                            </div>
                            <div class="mb-4">
                                <label class="block mb-1 text-gray-600">Vacancy to be filled from:</label>
                                <select name="vacant_form" class="w-full p-2 border border-gray-300 rounded-md"
                                    required>
                                    <option value="within">Within</option>
                                    <option value="outside">Outside</option>
                                </select>
                            </div>
                        </div>
                    </div>



                    <div class="mb-6">
                        <label class="block mb-1 text-gray-600">Select Status:</label>
                        <select id="status" name="status" class="w-full p-2 border border-gray-300 rounded-md"
                            required>
                            <option value="open">Open</option>
                            <option value="approved">Approved</option>
                            <option value="for_approval">For Approval</option>
                            <option value="meet_greet_intro">Meet & Greet / Intro</option>
                            <option value="process_requirement">Process Requirement</option>
                            <option value="agency_orientation">Agency Orientation</option>
                            <option value="client_orientation">Client Orientation</option>
                            <option value="store_orientation">Store Orientation</option>
                            <option value="deploy">Deploy</option>
                            <option value="disapproved">Disapproved</option>
                            <option value="cancel">Cancel</option>
                        </select>
                    </div>
            </div>
            <div class="flex justify-end items-end "><button type="submit" id="submit_button"
                    class="px-20 py-2 mt-4 text-white bg-blue-600 rounded-md">
                    <div class="flex items-center justify-center gap-2">
                        <div>Save</div>

                        <div id="loading-overlay" class="flex items-center hidden justify-center  mt-4 mb-4">
                            <div
                                class="inline-block w-5 h-5 border-4 border-white rounded-full spinner-border animate-spin border-t-transparent">
                            </div>

                        </div>
                    </div>

                </button></div>

            </form>
        </div>
    </div>
</div>
