<script>
    $(document).ready(function() {
        $('#mrfform').on('submit', function(e) {
            e.preventDefault(); // Prevent default form submission

            var formData = $(this).serialize();
            var errorContainer = $("#error-container");
            var successContainer = $("#success-container");
            var loadingOverlay = $("#loading-overlay");

            // Clear old messages
            errorContainer.hide().html('');
            successContainer.hide().html('');

            // Show loading
            loadingOverlay.show();

            $.ajax({
                url: "{{ route('requisitions.store') }}",
                type: "POST",
                data: formData,
                success: function(response) {
                    loadingOverlay.hide();

                    // Laravel just returns message unless you add `success: true` in your controller
                    successContainer.html('<div class="alert alert-success">' + response
                        .message + '</div>').fadeIn();

                    $('#successModal').removeClass('hidden');
                    $('#mrf').addClass('hidden');
                    $('#mrfform')[0].reset();
                    $('#reqTable').DataTable().ajax.reload(null,
                        false); // Reload table without resetting pagination

                    setTimeout(function() {
                        successContainer.fadeOut();
                    }, 5000);
                },
                error: function(xhr) {
                    loadingOverlay.hide();

                    var errorMessage =
                        "Error occurred! Please check the form and try again.";
                    if (xhr.responseJSON && xhr.responseJSON.message) {
                        errorMessage = xhr.responseJSON.message;
                    } else if (xhr.responseJSON && xhr.responseJSON.errors) {
                        errorMessage = Object.values(xhr.responseJSON.errors).flat().join(
                            '<br>');
                    }

                    errorContainer.html('<div class="alert alert-danger">' + errorMessage +
                        '</div>').fadeIn();
                }
            });
        });
    });
</script>
<script>
    function openModal(modalId) {
        var modal = document.getElementById(modalId);
        modal.classList.remove('hidden');
        modal.classList.add('flex');
    }

    // Function to close a modal
    function closeModal(modalId) {
        var modal = document.getElementById(modalId);
        modal.classList.add('hidden');
        modal.classList.remove('flex');
    }
</script>
<script>
    $(document).ready(function() {

        $('#agency').change(function() {
            var agencyId = $(this).val();
            if (agencyId) {
                // Generate URL for fetching companies
                var url = '{{ route('get_companies', ':agencyId') }}';
                url = url.replace(':agencyId', agencyId);

                $.ajax({
                    url: url,
                    type: 'GET',
                    success: function(data) {

                        $('#company').empty();
                        $('#company').append(
                            '<option value="" disabled selected>Select a Company</option>'
                        );

                        // Populate companies
                        $.each(data, function(key, value) {
                            $('#company').append('<option value="' + value.id +
                                '">' + value.business_name + '</option>');
                        });
                    }
                });
            } else {

                $('#company').empty().append(
                    '<option value="" disabled selected>Select a Company</option>');
            }
        });

        // Fetch clients based on selected company
        $('#company').change(function() {
            var companyId = $(this).val(); // Get the selected company ID
            if (companyId) {
                // Generate URL for fetching clients
                var url = '{{ route('get_clients_by_company', ':companyId') }}';
                url = url.replace(':companyId',
                    companyId); // Replace placeholder with actual company ID

                $.ajax({
                    url: url,
                    type: 'GET',
                    success: function(data) {
                        // Clear existing client options
                        $('#clientAccount').empty();
                        $('#clientAccount').append(
                            '<option value="" disabled selected>Select a Client</option>'
                        );

                        // Populate clients
                        $.each(data, function(key, value) {
                            $('#clientAccount').append('<option value="' + value
                                .id + '">Client: ' + value.department_name +
                                '</option>');
                        });
                    }
                });
            } else {
                // Reset the client dropdown if no company is selected
                $('#clientAccount').empty().append(
                    '<option value="" disabled selected>Select a Client</option>');
            }
        });

        // Fetch departments based on selected client

    });
</script>
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', () => {

        $('#employee_ids').select2({
            placeholder: "Search employees...",
            width: '100%',
            allowClear: true
        });
    });
</script>

<script>
    $(document).ready(function() {
        // Open Delete Modal
        window.openDeleteModal = function(recordId) {
            $('#deleteRecordId').val(recordId);
            $('#deleteModal').removeClass('hidden');
        };

        // Submit Delete Form
        $('#deleteForm').on('submit', function(e) {
            e.preventDefault();
            let recordId = $('#deleteRecordId').val();
            let deleteUrl = "{{ route('requisitions.destroy', ':id') }}".replace(':id', recordId);

            $.ajax({
                url: deleteUrl,
                type: "DELETE",
                data: {
                    _token: "{{ csrf_token() }}"
                },
                success: function(response) {
                    if (response.success) {
                        $('#successModal').removeClass('hidden'); // Show success modal
                        $('#deleteForm')[0].reset(); // Reset form
                        $('#deleteModal').addClass('hidden'); // Close modal
                        $('#reqTable').DataTable().ajax.reload(null,
                            false); // Reload table without resetting pagination
                    }
                },
                error: function(xhr) {
                    alert('Error deleting record.');
                }
            });
        });

        // Close Modal Function
        window.closeModal = function(modalId) {
            $('#' + modalId).addClass('hidden');
        };

    });
</script>
