<form action="{{ route('requisition.addEmployees.submit') }}" method="POST">
    @csrf
    <input type="hidden" name="requisition_id" value="{{ $requisition->id ?? '' }}">

    <div class="mb-6">
        <h2 class="mb-2 text-2xl font-semibold text-gray-700">Select Applicants:</h2>

        <!-- Filters -->
        <div class="flex items-center justify-start gap-5 mb-5">
            <div>
                <label class="block mb-1 text-gray-600" for="office_id">Select Office</label>
                <select id="office_id" name="office_id"
                    class="w-full md:w-[15rem] h-8 border-2 border-black rounded-md">
                    <option value="">Select an Office</option>
                    @foreach ($offices as $office)
                        <option value="{{ $office->id }}">{{ $office->name }}</option>
                    @endforeach
                </select>
            </div>

            <div>
                <label class="block mb-1 text-gray-600" for="store_id">Select Store</label>
                <select id="store_id" name="store_id" class="w-full md:w-[15rem] h-8 border-2 border-black rounded-md">
                    <option value="">Select a Store</option>
                    @foreach ($stores as $store)
                        <option value="{{ $store->id }}">{{ $store->name }}</option>
                    @endforeach
                </select>
            </div>

            <div>
                <label class="block mb-1 text-gray-600" for="pwd_filter">PWD Filter</label>
                <select id="pwd_filter" name="pwd_filter"
                    class="w-full md:w-[15rem] h-8 border-2 border-black rounded-md">
                    <option value="">All</option>
                    <option value="PWD">PWD</option>
                    <option value="Not PWD">Not PWD</option>
                </select>
            </div>
        </div>

        <!-- Table -->
        <div class="overflow-auto">
            <table id="pre-employment-table" class="min-w-full bg-white border border-gray-200 rounded shadow-md">
                <thead>
                    <tr class="text-sm leading-normal text-white bg-[#1d1d1d]">
                        <th class="px-6 py-1"><input type="checkbox" id="select_all" /></th>

                        <th class="px-6 py-1">Name</th>
                        <th class="px-6 py-1">Age</th>
                        <th class="px-6 py-1">Sex</th>
                        <th class="px-6 py-1">PWD</th>
                        <th class="px-6 py-1">Status</th>

                        <th class="px-6 py-1">Actions</th>
                    </tr>
                </thead>
                <tbody class="text-sm font-light text-center text-gray-600">
                    <!-- Populated via DataTables -->
                </tbody>
            </table>
        </div>

        <p class="mt-2 text-sm text-gray-500">
            Use the checkboxes to select applicants. You can filter by Office, Store, and PWD.
        </p>
    </div>

    <!-- Hidden selected inputs -->
    <div id="selected-applicants"></div>

    <div class="mb-6">
        <label class="block mb-1 text-gray-600">Select Status:</label>
        <select id="status" name="status" class="w-full p-2 border border-gray-300 rounded-md" required>
            <option value="open">Open</option>
            <option value="approved">Approved</option>
            <option value="for_approval">For Approval</option>
            <option value="meet_greet_intro">Meet & Greet / Intro</option>
            <option value="process_requirement">Process Requirement</option>
            <option value="agency_orientation">Agency Orientation</option>
            <option value="client_orientation">Client Orientation</option>
            <option value="deploy">Deploy</option>
            <option value="disapproved">Disapproved</option>
            <option value="cancel">Cancel</option>
        </select>
    </div>

    <button type="submit" class="w-full p-2 text-white bg-blue-500 rounded-md hover:bg-blue-600">Add Employees</button>
</form>

<!-- Script -->
<script type="text/javascript">
    $(document).ready(function() {
        var selectedIds = new Set();

        const preEmploymentTable = $('#pre-employment-table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: "{{ route('forapproval.index') }}",
                data: function(d) {
                    d.office_id = $('#office_id').val();
                    d.store_id = $('#store_id').val();
                    d.pwd_filter = $('#pwd_filter').val();
                }
            },
            columns: [{
                    data: 'id',
                    orderable: false,
                    searchable: false,
                    render: function(data) {
                        return `<input type="checkbox" class="applicant-checkbox" value="${data}" ${selectedIds.has(data.toString()) ? 'checked' : ''} />`;
                    }
                },

                {
                    data: 'name',
                    name: 'name'
                },
                {
                    data: 'age',
                    name: 'age'
                },
                {
                    data: 'sex',
                    name: 'sex'
                }, // Assumes your backend returns 'M' or 'F'
                {
                    data: 'pwd',
                    name: 'pwd'
                },
                {
                    data: 'status',
                    name: 'status'
                },

                {
                    data: 'mrf',
                    name: 'mrf',
                    orderable: false,
                    searchable: false
                }
            ],
            order: [
                [1, 'desc']
            ],
            drawCallback: function() {
                $('.applicant-checkbox').each(function() {
                    const id = $(this).val();
                    $(this).prop('checked', selectedIds.has(id));
                });
            }
        });

        $('#office_id, #store_id, #pwd_filter').on('change', function() {
            preEmploymentTable.ajax.reload();
        });

        $('#pre-employment-table tbody').on('change', '.applicant-checkbox', function() {
            const id = $(this).val();
            const hiddenInputId = `#applicant-${id}`;
            if (this.checked) {
                selectedIds.add(id);
                if (!$(hiddenInputId).length) {
                    $('#selected-applicants').append(
                        `<input type="hidden" name="employee_ids[]" value="${id}" id="applicant-${id}">`
                    );
                }
            } else {
                selectedIds.delete(id);
                $(hiddenInputId).remove();
            }
        });

        $('#select_all').on('change', function() {
            const checked = this.checked;
            $('.applicant-checkbox').each(function() {
                $(this).prop('checked', checked).trigger('change');
            });
        });
    });
</script>
