@if (in_array('MRF For Approval', $privileges))
    <form action="{{ route('requisition.updateStatus', ['requisition' => $requisition->id]) }}" method="post"
        class="inline-block" id="formForApproval">
        @csrf
        @method('PUT')

        <label for="status" class="block mb-1 text-gray-600">Select Status:</label>
        <select id="status" name="status" class="w-full p-2 border border-gray-300 rounded-md" required>
            @if (in_array('MRF Open', $privileges))
                <option value=" " {{ old('status', $requisition->status) === null ? 'selected' : '' }}>Open</option>
            @endif
            @if (in_array('MRF For Approval', $privileges))
                <option value="Approved" {{ old('status', $requisition->status) == 'Approved' ? 'selected' : '' }}>
                    Approved</option>
                <option value="For Approval"
                    {{ old('status', $requisition->status) == 'For Approval' ? 'selected' : '' }}>For Approval</option>
            @endif
            @if (in_array('MRF Meet & Greet', $privileges))
                <option value="Meet & Greet / Intro"
                    {{ old('status', $requisition->status) == 'Meet & Greet / Intro' ? 'selected' : '' }}>Meet & Greet /
                    Intro</option>
            @endif
            @if (in_array('MRF Process Requirement', $privileges))
                <option value="Process Requirement"
                    {{ old('status', $requisition->status) == 'Process Requirement' ? 'selected' : '' }}>Process
                    Requirement</option>
            @endif
            @if (in_array('MRF Agency Orientation', $privileges))
                <option value="Agency Orientation"
                    {{ old('status', $requisition->status) == 'Agency Orientation' ? 'selected' : '' }}>Agency
                    Orientation</option>
            @endif
            @if (in_array('MRF Client Orientation', $privileges))
                <option value="Client Orientation"
                    {{ old('status', $requisition->status) == 'Client Orientation' ? 'selected' : '' }}>Client
                    Orientation</option>
            @endif
            @if (in_array('MRF Store Orientation', $privileges))
                <option value="Store Orientation"
                    {{ old('status', $requisition->status) == 'Store Orientation' ? 'selected' : '' }}>Store Orientation
                </option>
            @endif
            @if (in_array('MRF Deploy', $privileges))
                <option value="Deploy" {{ old('status', $requisition->status) == 'Deploy' ? 'selected' : '' }}>Deploy
                </option>
            @endif
            @if (in_array('MRF Disapproved', $privileges))
                <option value="Disapproved"
                    {{ old('status', $requisition->status) == 'Disapproved' ? 'selected' : '' }}>Disapproved</option>
            @endif
            @if (in_array('MRF Cancel', $privileges))
                <option value="Cancel" {{ old('status', $requisition->status) == 'Cancel' ? 'selected' : '' }}>Cancel
                </option>
            @endif
            <option value="Back out" {{ old('status', $requisition->status) == 'Back out' ? 'selected' : '' }}>Back out
            </option>
        </select>

        <button type="button" id="statusButton" onclick="showConfirmationModal('formForApproval')"
            class="mt-3 px-4 py-2 text-white bg-red-600 rounded-md hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-opacity-75">
            Cuurent status
        </button>

    </form>


@endif
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const statusSelect = document.getElementById('status');
        const statusButton = document.getElementById('statusButton');

        function updateButtonLabel() {
            const selectedText = statusSelect.options[statusSelect.selectedIndex].text.trim();
            statusButton.textContent = 'Cuurent status ' + (selectedText || '...');
        }

        // Initial set on page load
        updateButtonLabel();

        // Update when dropdown changes
        statusSelect.addEventListener('change', updateButtonLabel);
    });
</script>
