<div id="deleteModal{{ $data->id }}"
    class="fixed inset-0 z-50 flex items-start justify-center hidden bg-black bg-opacity-50 modal fade">
    <!-- Modal dialog -->
    <div class="max-w-md mx-auto mt-10 overflow-hidden bg-white rounded-lg shadow-xl">
        <!-- Modal header -->
        <div class="flex items-center justify-between px-4 py-2 bg-red-500">
            <h5 class="font-bold text-white">Confirm Delete</h5>
            <button onclick="closeModal('deleteModal{{ $data->id }}')" class="text-white">&times;</button>
        </div>

        <!-- Modal body -->
        <div class="px-4 py-4">
            <p>Are you certain you want to delete this data?</p>
        </div>

        <!-- Modal footer -->
        <div class="flex items-center justify-end px-4 py-3 bg-gray-100">
            <button onclick="closeModal('deleteModal{{ $data->id }}')"
                class="px-3 py-1 mr-2 text-gray-800 bg-gray-300 rounded hover:bg-gray-400">Cancel</button>

            <!-- Form for delete -->
            <form id="deleteForm{{ $data->id }}" action="{{ route('contributions.destroy', $data->id) }}"
                method="POST">
                @csrf
                @method('DELETE')
                <button type="submit" class="px-3 py-1 text-white bg-red-500 rounded hover:bg-red-600">Delete</button>
            </form>
        </div>
    </div>
</div>
