@extends('layouts.sidebar')

@section('content')
    @if (in_array('Manage Settings' || 'Employee UserInterface', $privileges))
        <div class="container mx-auto mt-10 max-w-screen-2xl">
            <h1 class="mb-8 text-3xl font-bold text-center text-gray-800"> Settings</h1>

            @if (session('success'))
                <div class="p-4 mb-4 text-white bg-green-500 rounded shadow-lg">
                    {{ session('success') }}
                </div>
            @endif

            @if ($errors->any())
                <div class="p-4 mb-4 text-white bg-red-500 rounded shadow-lg">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
            @if (in_array('Benefits Setting', $privileges))
                <div class="p-8 mb-8 text-sm bg-white border-l-4 border-red-500 rounded-lg shadow-lg">
                    <h3 class="text-lg font-semibold">Office Setting:</h3>
                    @include('Admin.Settings.storesandoffice')

                </div>
            @endif
            @if (in_array('Benefits Setting', $privileges))
                <div class="p-8 mb-8 text-sm bg-white border-l-4 border-red-500 rounded-lg shadow-lg">
                    <h3 class="text-lg font-semibold">Contribution Breakdown:</h3>
                    @include('Admin.Settings.contribution')

                </div>
            @endif
            @if (in_array('Role Setting', $privileges))
                <div class="p-8 mb-8 text-sm bg-white border-l-4 border-green-500 rounded-lg shadow-lg">
                    <h3 class="text-lg font-semibold">Role Creation:</h3>
                    @include('Admin.Settings.role')

                </div>
            @endif
            @if (in_array('Password Setting', $privileges))
                <div class="p-8 mb-8 text-sm bg-white border-l-4 border-green-500 rounded-lg shadow-lg">
                    <h3 class="text-lg font-semibold">Change Password:</h3>
                    @include('Admin.Settings.changepass')
                </div>
            @endif
            {{-- @if (in_array('Billing Setting', $privileges))
                <div class="p-8 mb-8 text-sm bg-white border-l-4 border-green-500 rounded-lg shadow-lg">
                    <h3 class="text-lg font-semibold">Shift Settings:</h3>
                    @include('Admin.Settings.charges')
                </div>
            @endif --}}
        </div>

        <script>
            function openModal(modalId) {
                var modal = document.getElementById(modalId);
                modal.classList.remove('hidden');
                modal.classList.add('flex');
            }

            // Function to close a modal
            function closeModal(modalId) {
                var modal = document.getElementById(modalId);
                modal.classList.add('hidden');
                modal.classList.remove('flex');
            }
        </script>

        </div>
    @else
        <div class="flex items-center justify-center w-full h-full my-2">
            <div>
                <i class="mr-2 text-3xl bx bx-lock"></i>
                <span class="text-gray-500">You don't have privilege to access this page</span>
            </div>

        </div>
    @endif

@endsection
