<div class="grid grid-cols-1 gap-2 md:gap-10 xl:grid-cols-6">
    <form action="{{ route('roles.store') }}" method="POST" class="w-auto col-span-4 p-6 mt-4 bg-white rounded shadow">
        @csrf
        <div class="mb-4">
            <label for="role_name" class="block text-sm font-medium text-gray-700">Role Name</label>
            <input type="text" name="role_name" id="role_name" required
                class="block w-auto h-10 mt-1 border-2 border-black rounded-md shadow-sm md:w-full ">
        </div>

        <div class="mb-4">
            <label class="block text-sm font-medium text-gray-700">Privileges</label>
            <div class="grid grid-cols-1 gap-3 mt-2 md:grid-cols-4">
                @php
                    $groupedPrivileges = $privileges1
                        ->groupBy('status')
                        ->sortByDesc(fn($privileges) => $privileges->count());
                @endphp

                @foreach ($groupedPrivileges as $status => $privileges)
                    <div class="status-group">
                        <h3 class="mb-2 text-lg font-semibold">{{ $status }}</h3>

                        @foreach ($privileges as $privilege)
                            <div class="mb-2 whitespace-nowrap">
                                <input type="checkbox" name="privileges[]" value="{{ $privilege->id }}"
                                    id="privilege_{{ $privilege->id }}"
                                    class="w-4 h-4 text-indigo-600 border-gray-300 rounded focus:ring-indigo-500">
                                <label for="privilege_{{ $privilege->id }}" class="ml-2 text-sm text-gray-600">
                                    {{ $privilege->privilege_name }}
                                </label>
                            </div>
                        @endforeach
                    </div>
                @endforeach
            </div>
        </div>


        <button type="submit"
            class="inline-flex justify-center px-4 py-2 mt-4 text-sm font-medium text-white bg-indigo-600 border border-transparent rounded-md shadow-sm hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
            Add Role
        </button>
    </form>
    <div class="w-full col-span-2 overflow-auto">
        <table id="roleTable" class="w-full border border-collapse border-gray-200 table-auto">
            <thead>
                <tr class="text-sm text-gray-700 uppercase bg-gray-200">

                    <th>Role Name</th>

                    <th>Actions</th>
                </tr>
            </thead>
            <tbody class="text-sm font-light text-center text-gray-600">
                <!-- DataTables will populate this body -->
            </tbody>
        </table>
    </div>
</div>
@include('Admin.Settings.rolemodal')
<script>
    $(document).ready(function() {
        $('#roleTable').DataTable({
            processing: true,
            serverSide: true,
            ajax: "{{ route('roles.index') }}", // Pointing to the index route
            columns: [{
                    data: 'role_name',
                    name: 'role_name'
                },


                {
                    data: 'action',
                    name: 'action',
                    orderable: false,
                    searchable: false
                } // No sorting/searching on action column
            ]
        });
    });
</script>
