@extends('layouts.sidebar')
@section('title', 'Store')
@section('content')

    <div class="grid grid-cols-1 gap-5 lg:grid-cols-6 p-10">
        <div>
            <p class="text-lg font-bold mb-5">Store List</p>
            <form id="storeForm" enctype="multipart/form-data">
                @csrf
                <div id="successMessage"
                    class="hidden mb-4 p-3 text-sm text-green-700 bg-green-100 border border-green-400 rounded-lg">
                </div>
                <div class="mb-4">
                    <label for="name" class="block text-sm font-medium text-gray-700">Store Name</label>
                    <input type="text" id="name" name="name"
                        class="block w-full px-4 py-2 mt-1 border border-gray-300 rounded bg-gray-50 focus:ring focus:ring-blue-200 focus:outline-none"
                        placeholder="Enter store name" required>
                </div>

                <div class="mb-4">
                    <label for="email" class="block text-sm font-medium text-gray-700">Email</label>
                    <input type="email" id="email" name="email"
                        class="block w-full px-4 py-2 mt-1 border border-gray-300 rounded bg-gray-50 focus:ring focus:ring-blue-200 focus:outline-none"
                        placeholder="Enter email" required>
                </div>

                <div class="mb-4">
                    <label for="password" class="block text-sm font-medium text-gray-700">Password</label>
                    <input type="password" id="password" name="password"
                        class="block w-full px-4 py-2 mt-1 border border-gray-300 rounded bg-gray-50 focus:ring focus:ring-blue-200 focus:outline-none"
                        placeholder="Enter password" required>
                </div>

                <div class="mb-4">
                    <label for="password_confirmation" class="block text-sm font-medium text-gray-700">Confirm
                        Password</label>
                    <input type="password" id="password_confirmation" name="password_confirmation"
                        class="block w-full px-4 py-2 mt-1 border border-gray-300 rounded bg-gray-50 focus:ring focus:ring-blue-200 focus:outline-none"
                        placeholder="Confirm password" required>
                </div>

                <!-- example static role_id -->

                <div class="text-center">
                    <button type="submit" class="w-full px-4 py-2 text-white bg-blue-600 rounded hover:bg-blue-700">
                        Submit
                    </button>
                </div>
            </form>
        </div>

        <div class="col-span-5 overflow-x-auto">
            <table id="department-stores-table"
                class="min-w-full text-center bg-white border border-gray-200 rounded shadow-md">
                <thead>
                    <tr class="text-sm leading-normal text-white text-nowrap bg-[#1d1d1d]">
                        <th>Name</th>

                        <th>Action</th>
                    </tr>
                </thead>
                <tbody></tbody>
            </table>
        </div>
    </div><!-- Edit Store Modal -->
    <div id="editStoreModal" class="fixed inset-0 z-50 flex items-start justify-center hidden bg-gray-900 bg-opacity-50">
        <div class="p-6 mt-20 bg-white rounded-lg shadow-lg w-96">
            <h2 class="text-lg font-semibold mb-2">Edit Store</h2>

            <input type="hidden" id="editStoreId">

            <div class="mb-4">
                <label class="block text-sm font-medium text-gray-700">Name</label>
                <input type="text" id="editStoreName" class="w-full border rounded px-3 py-2 mt-1" />
            </div>

            <div class="mb-4">
                <label class="block text-sm font-medium text-gray-700">Email</label>
                <input type="email" id="editStoreEmail" class="w-full border rounded px-3 py-2 mt-1" />
            </div>

            <div class="mb-4">
                <label class="block text-sm font-medium text-gray-700">Password (optional)</label>
                <input type="password" id="editStorePassword" class="w-full border rounded px-3 py-2 mt-1"
                    placeholder="Leave blank to keep current" />
            </div>

            <div class="flex justify-end">
                <button id="cancelStoreEdit"
                    class="px-4 py-2 mr-2 text-gray-700 border border-gray-300 rounded-lg hover:bg-gray-100">
                    Cancel
                </button>
                <button id="confirmStoreEdit" type="submit"
                    class="px-4 py-2 text-white bg-blue-600 rounded-lg hover:bg-blue-700">
                    Save
                </button>
            </div>
        </div>
    </div>


    <!-- Delete Confirmation Modal with a unique ID -->
    <div id="deletestoreModal" class="fixed inset-0 z-50 flex items-start justify-center hidden bg-gray-900 bg-opacity-50">
        <div class="p-6 mt-20 bg-white rounded-lg shadow-lg w-96">
            <h2 class="text-lg font-semibold">Confirm Deletion</h2>
            <p class="text-gray-700">Are you sure you want to delete this file?</p>
            <input type="hidden" id="deletestoreId">
            <div class="flex justify-end mt-4">
                <button id="cancelstoreDelete"
                    class="px-4 py-2 mr-2 text-gray-700 border border-gray-300 rounded-lg hover:bg-gray-100">
                    Cancel
                </button>
                <button id="confirmstoreDelete" type="submit"
                    class="px-4 py-2 text-white bg-red-600 rounded-lg hover:bg-red-700">
                    Delete
                </button>
            </div>
        </div>
    </div>
    <script>
        $(document).ready(function() {

            var table = $('#department-stores-table').DataTable({
                processing: true,
                serverSide: true,
                ajax: "{{ route('store_menu.index') }}",
                columns: [{
                        data: 'name',
                        name: 'name'
                    },

                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    }
                ]
            });

            // Handle form submission via AJAX
            $('#storeForm').submit(function(e) {
                e.preventDefault();
                var formData = new FormData(this);

                $.ajax({
                    url: "{{ route('store_menu.store') }}",
                    method: "POST",
                    data: formData,
                    contentType: false,
                    processData: false,
                    success: function(response) {
                        // ✅ Reset form
                        $('#storeForm')[0].reset();

                        // ✅ Show success message
                        $('#successMessage')
                            .removeClass('hidden')
                            .text(response.message ?? "Store created successfully!");

                        // Hide after 3s
                        setTimeout(function() {
                            $('#successMessage').addClass('hidden');
                        }, 3000);

                        // ✅ Reload DataTable
                        table.ajax.reload();
                    },
                    error: function(xhr) {
                        alert("An error occurred: " + xhr.responseText);
                    }
                });
            });

            $(document).on('click', '.delete-file', function() {
                var fileId = $(this).data('id');
                $('#deletestoreId').val(fileId);
                $('#deletestoreModal').removeClass('hidden');
            });

            // Close Modal
            $('#cancelstoreDelete').click(function() {
                $('#deletestoreModal').addClass('hidden');
            });

            // Confirm Delete
            $('#confirmstoreDelete').click(function() {
                var fileId = $('#deletestoreId').val();
                $.ajax({
                    url: "{{ route('store_menu.destroy', ':id') }}".replace(':id', fileId),
                    method: "DELETE",
                    data: {
                        _token: "{{ csrf_token() }}"
                    },
                    success: function(response) {

                        $('#deletestoreModal').addClass('hidden');
                        table.ajax.reload();
                    },
                    error: function(xhr) {
                        alert("An error occurred: " + xhr.responseText);
                    }
                });
            });
        });
    </script>
    <script>
        // ✅ Use the correct parameter name (store_menu) for resource routes
        const storeEditRoute = "{{ route('store_menu.edit', ['store_menu' => ':store_menu']) }}";
        const storeUpdateRoute = "{{ route('store_menu.update', ['store_menu' => ':store_menu']) }}";

        // Open Edit Modal
        $(document).on('click', '.edit-store', function() {
            const id = $(this).data('id');
            $.ajax({
                url: storeEditRoute.replace(':store_menu', id), // ✅ correct placeholder
                method: 'GET',
                success: function(data) {
                    $('#editStoreId').val(data.id);
                    $('#editStoreName').val(data.name);
                    $('#editStoreEmail').val(data.email);
                    $('#editStoreModal').removeClass('hidden');
                },
                error: function() {
                    alert('Failed to fetch store data.');
                }
            });
        });

        // Cancel Edit
        $('#cancelStoreEdit').click(function() {
            $('#editStoreModal').addClass('hidden');
        });

        // Save Update
        $('#confirmStoreEdit').click(function() {
            const id = $('#editStoreId').val();
            const name = $('#editStoreName').val();
            const email = $('#editStoreEmail').val();
            const password = $('#editStorePassword').val(); // optional

            $.ajax({
                url: storeUpdateRoute.replace(':store_menu', id), // ✅ correct placeholder
                method: 'POST',
                data: {
                    _token: "{{ csrf_token() }}",
                    _method: 'PUT',
                    name: name,
                    email: email,
                    password: password // optional field
                },
                success: function() {
                    $('#editStoreModal').addClass('hidden');
                    $('#department-stores-table').DataTable().ajax.reload();
                },
                error: function(xhr) {
                    alert("Update failed: " + xhr.responseText);
                }
            });
        });
    </script>



@endsection
