@extends('layouts.sidebar')
@section('title', 'Store')
@section('content')

    <div class="grid grid-cols-1 gap-5 lg:grid-cols-6 p-10">
        <div>
            <p class="text-lg font-bold mb-5">Store assigning</p>
            <form id="storeForm" enctype="multipart/form-data">
                @csrf
                <div class="mb-4">
                    <label for="department_id" class="block text-sm font-medium text-gray-700">Department Name</label>
                    <select id="department_id" name="department_id"
                        class="mt-1 block w-full rounded-md py-3  border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm">
                        <option value="">-- Select Department --</option>
                        @foreach ($department as $dt)
                            <option value="{{ $dt->id }}">{{ $dt->department_name }}</option>
                        @endforeach
                    </select>
                </div>
                <input type="hidden" name="store_id" value="{{ $id }}">

                <div class="text-center">
                    <button type="submit" class="w-full px-4 py-2 text-white bg-blue-600 rounded hover:bg-blue-700">
                        Submit
                    </button>
                </div>
            </form>
        </div>

        <div class="col-span-5 overflow-x-auto">
            <table id="department-stores-table"
                class="min-w-full text-center bg-white border border-gray-200 rounded shadow-md">
                <thead>
                    <tr class="text-sm leading-normal text-white text-nowrap bg-[#1d1d1d]">
                        <th>Name</th>

                        <th>Action</th>
                    </tr>
                </thead>
                <tbody></tbody>
            </table>
        </div>
    </div><!-- Edit Store Modal -->



    <!-- Delete Confirmation Modal with a unique ID -->
    <div id="deletestoreModal" class="fixed inset-0 z-50 flex items-start justify-center hidden bg-gray-900 bg-opacity-50">
        <div class="p-6 mt-20 bg-white rounded-lg shadow-lg w-96">
            <h2 class="text-lg font-semibold">Confirm Deletion</h2>
            <p class="text-gray-700">Are you sure you want to delete this file?</p>
            <input type="hidden" id="deletestoreId">
            <div class="flex justify-end mt-4">
                <button id="cancelstoreDelete"
                    class="px-4 py-2 mr-2 text-gray-700 border border-gray-300 rounded-lg hover:bg-gray-100">
                    Cancel
                </button>
                <button id="confirmstoreDelete" type="submit"
                    class="px-4 py-2 text-white bg-red-600 rounded-lg hover:bg-red-700">
                    Delete
                </button>
            </div>
        </div>
    </div>
    <script>
        $(document).ready(function() {
            var department_id = {{ $id }};
            var table = $('#department-stores-table').DataTable({
                processing: true,
                serverSide: true,
                ajax: '{{ route('storeassignedepartment', ['id' => ':id']) }}'.replace(':id',
                    department_id),
                columns: [{
                        data: 'department',
                        name: 'department'
                    },

                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    }
                ]
            });

            // Handle form submission via AJAX
            $('#storeForm').submit(function(e) {
                e.preventDefault();
                var formData = new FormData(this);

                $.ajax({
                    url: "{{ route('store_dapartmentassignment.store') }}",
                    method: "POST",
                    data: formData,
                    contentType: false,
                    processData: false,
                    success: function(response) {

                        table.ajax.reload();
                    },
                    error: function(xhr) {
                        alert("An error occurred: " + xhr.responseText);
                    }
                });
            });

            $(document).on('click', '.delete-file', function() {
                var fileId = $(this).data('id');
                $('#deletestoreId').val(fileId);
                $('#deletestoreModal').removeClass('hidden');
            });

            // Close Modal
            $('#cancelstoreDelete').click(function() {
                $('#deletestoreModal').addClass('hidden');
            });

            // Confirm Delete
            $('#confirmstoreDelete').click(function() {
                var fileId = $('#deletestoreId').val();
                $.ajax({
                    url: "{{ route('store_dapartmentassignment.destroy', ':id') }}".replace(':id',
                        fileId),
                    method: "DELETE",
                    data: {
                        _token: "{{ csrf_token() }}"
                    },
                    success: function(response) {

                        $('#deletestoreModal').addClass('hidden');
                        table.ajax.reload();
                    },
                    error: function(xhr) {
                        alert("An error occurred: " + xhr.responseText);
                    }
                });
            });
        });
    </script>



@endsection
