@extends('layouts.sidebar')
@section('title', 'Users')
@section('content')

    <div class="flex justify-between py-5">
        <h1 class="mb-4 text-2xl font-bold">Users</h1>


    </div>
    @if (session('success'))
        <div class="p-4 mb-4 text-white bg-green-500">
            {{ session('success') }}
        </div>
    @endif
    <div class="grid grid-cols-1 gap-2 md:grid-cols-6 p-6 bg-gray-100 rounded-lg shadow-md border border-gray-300 ">
        <div class="col-span-1 p-2 border-2 border-black rounded-md ">
            <form id="userstore" class="p-6 mt-4 bg-white rounded">
                @csrf

                <div id="error-container" class="mb-4 text-red-500"></div> <!-- Error messages container -->

                <div class="mb-4">
                    <label for="name" class="block text-sm font-medium text-gray-700">Name</label>
                    <input type="text" name="name" id="name" required value="{{ old('name') }}"
                        class="block w-full h-10 mt-1 border-2 border-gray-300 rounded-md shadow-sm">
                </div>

                <div class="mb-4">
                    <label for="email" class="block text-sm font-medium text-gray-700">Email</label>
                    <input type="email" name="email" id="email" required value="{{ old('email') }}"
                        class="block w-full h-10 mt-1 border-2 border-gray-300 rounded-md shadow-sm">
                </div>

                <div class="mb-4">
                    <label for="password" class="block text-sm font-medium text-gray-700">Password</label>
                    <input type="password" name="password" id="password" required
                        class="block w-full h-10 mt-1 border-2 border-gray-300 rounded-md shadow-sm">
                </div>

                <div class="mb-4">
                    <label for="password_confirmation" class="block text-sm font-medium text-gray-700">Confirm
                        Password</label>
                    <input type="password" name="password_confirmation" id="password_confirmation" required
                        class="block w-full h-10 mt-1 border-2 border-gray-300 rounded-md shadow-sm">
                </div>

                <div class="mb-4">
                    <label for="role_id" class="block text-sm font-medium text-gray-700">Role</label>
                    <select name="role_id" id="role_id" required
                        class="block w-full h-10 mt-1 border-2 border-gray-300 rounded-md shadow-sm">
                        <option value="">Select a Role</option>
                        @foreach ($roles as $role)
                            <option value="{{ $role->id }}" {{ old('role_id') == $role->id ? 'selected' : '' }}>
                                {{ $role->role_name }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <button type="submit"
                    class="inline-flex justify-center px-4 py-2 mt-4 text-sm font-medium text-white bg-indigo-600 border border-transparent rounded-md shadow-sm hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                    Add User
                </button>
            </form>
        </div>
        <div class="col-span-5 p-2 overflow-auto border-2 border-black rounded-md ">
            <table id="usersTable" class="min-w-full bg-white border border-collapse border-gray-200 rounded shadow-md ">
                <thead>
                    <tr class="text-sm leading-normal text-white uppercase bg-[#1d1d1d]">
                        <th>Name</th>

                        <th>Role</th>
                        <th>Email</th>

                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody class="text-sm font-light text-center text-gray-600">

                </tbody>
            </table>
        </div>
    </div>


    @include('Admin.User.modal')


    <script>
        $(document).ready(function() {
            var table = $('#usersTable').DataTable({
                processing: true,
                serverSide: true,
                ajax: "{{ route('users.index') }}",
                columns: [{
                        data: 'name',
                        name: 'name'
                    },
                    {
                        data: 'role',
                        name: 'role'
                    },
                    {
                        data: 'email',
                        name: 'email'
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    }
                ]
            });

            window.openModal = function(modalId, userId) {
                if (modalId === 'updateModal') {

                    $.ajax({
                        url: '{{ route('users.edit', ':user') }}'.replace(':user', userId),
                        method: 'GET',
                        success: function(response) {

                            $('#updateUserId').val(response.user.id);
                            $('#updateName').val(response.user.name);
                            $('#updateEmail').val(response.user.email);
                            $('#updateRole').html(response.roles.map(role =>
                                `<option value="${role.id}" ${response.current_role_id == role.id ? 'selected' : ''}>${role.role_name}</option>`
                            ));

                            $('#updateModal').removeClass('hidden');
                        }
                    });
                } else if (modalId === 'deleteModal') {
                    $('#confirmDeleteBtn').off('click').on('click', function() {
                        $.ajax({
                            url: '{{ route('users.destroy', ':user') }}'.replace(':user',
                                userId),
                            method: 'DELETE',
                            data: {
                                _token: '{{ csrf_token() }}'
                            },
                            success: function(response) {
                                // Hide delete modal
                                $('#deleteModal').addClass('hidden');


                                table.ajax.reload(null,
                                    false
                                );
                            }
                        });
                    });

                    // Show modal
                    $('#deleteModal').removeClass('hidden');
                }
            };

            window.closeModal = function(modalId) {
                $('#' + modalId).addClass('hidden');
            };

            // Update User
            $('#updateForm').submit(function(e) {
                e.preventDefault();
                var userId = $('#updateUserId').val();
                $.ajax({
                    url: '{{ route('users.update', ':user') }}'.replace(':user', userId),
                    method: 'PUT',
                    data: {
                        name: $('#updateName').val(),
                        email: $('#updateEmail').val(),
                        role_id: $('#updateRole').val(),
                        password: $('#updatePassword').val(),
                        _token: '{{ csrf_token() }}'
                    },
                    success: function(response) {
                        // Hide the update modal
                        $('#updateModal').addClass('hidden');

                        table.ajax.reload(null,
                            false
                        );
                    }
                });
            });

        });
    </script>


@endsection
