<div id="successModal" class="fixed inset-0 z-50 flex items-center justify-center hidden bg-black bg-opacity-50">
    <div class="p-5 bg-white rounded-lg shadow-lg w-96">
        <h2 class="text-lg font-bold text-center">Success</h2>
        <p class="mt-2 text-center text-gray-700">Added successfully!</p>
        <div class="mt-4 text-center">
            <button onclick="closeModal('successModal')"
                class="px-4 py-2 text-white bg-blue-500 rounded-lg hover:bg-blue-700">
                OK
            </button>
        </div>
    </div>
</div>
<script>
    $(document).ready(function() {
        $('#userstore').on('submit', function(e) {
            e.preventDefault();

            var formData = $(this).serialize();
            var errorContainer = $("#error-container");
            var loadingOverlay = $("#loading-overlay");

            errorContainer.html(""); // Clear errors
            loadingOverlay.removeClass("hidden"); // Show loading spinner

            $.ajax({
                url: @json(route('users.store')), // Ensure Laravel route parsing works
                type: "POST",
                data: formData,
                headers: {
                    "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") // CSRF token
                },
                success: function(response) {
                    if (response.success) {
                        $('#successModal').removeClass('hidden'); // Show success modal
                        $('#userstore')[0].reset(); // Reset form
                        if ($.fn.DataTable.isDataTable("#usersTable")) {
                            $('#usersTable').DataTable().ajax.reload(null,
                                false); // Reload DataTable
                        }
                    }
                    loadingOverlay.addClass("hidden"); // Hide loading spinner
                },
                error: function(xhr) {
                    loadingOverlay.addClass("hidden"); // Hide loading spinner

                    if (xhr.status === 422) { // Laravel validation error
                        let errors = xhr.responseJSON.errors;
                        let errorMessages = Object.entries(errors).map(([key, messages]) =>
                            `<p class="text-sm text-red-500">${messages[0]}</p>`).join(
                            "");
                        errorContainer.html(errorMessages);
                    } else {
                        alert('An error occurred. Please try again.');
                    }
                }
            });
        });

        // Close success modal
        $("#closeModal").on("click", function() {
            $("#successModal").addClass("hidden");
        });
    });
</script>




<!-- Edit Modal -->
<div id="updateModal" class="fixed inset-0 z-50 flex items-center justify-center hidden bg-gray-800 bg-opacity-50"
    role="dialog" aria-hidden="true">
    <div class="w-full max-w-md p-6 bg-white rounded-lg">
        <div class="flex items-center justify-between">
            <h2 class="text-xl font-semibold">Update User</h2>
            <button type="button" onclick="closeModal('updateModal')" class="text-gray-600 hover:text-gray-900">
                <i class="text-2xl bx bx-x"></i>
            </button>
        </div>
        <form id="updateForm" class="mt-4">
            <input type="hidden" id="updateUserId">
            <div class="space-y-4">
                <!-- Name Input -->
                <div>
                    <label for="updateName" class="block text-sm font-medium text-gray-700">Name</label>
                    <input type="text" id="updateName"
                        class="block w-full px-3 py-2 mt-1 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500"
                        required>
                </div>

                <!-- Email Input -->
                <div>
                    <label for="updateEmail" class="block text-sm font-medium text-gray-700">Email</label>
                    <input type="email" id="updateEmail"
                        class="block w-full px-3 py-2 mt-1 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500"
                        required>
                </div>

                <!-- Role Select -->
                <div>
                    <label for="updateRole" class="block text-sm font-medium text-gray-700">Role</label>
                    <select id="updateRole"
                        class="block w-full px-3 py-2 mt-1 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500"
                        required>
                        <!-- Roles will be populated by JavaScript -->
                    </select>
                </div>

                <!-- Password Input -->
                <div>
                    <label for="updatePassword" class="block text-sm font-medium text-gray-700">Password</label>
                    <input type="password" id="updatePassword"
                        class="block w-full px-3 py-2 mt-1 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500"
                        placeholder="Leave blank to keep current password">
                </div>
            </div>
            <div class="flex justify-end mt-6 space-x-4">
                <button type="button" onclick="closeModal('updateModal')"
                    class="px-4 py-2 text-gray-700 bg-gray-300 rounded-md hover:bg-gray-400">Cancel</button>
                <button type="submit" class="px-4 py-2 text-white bg-blue-600 rounded-md hover:bg-blue-700">Save
                    changes</button>
            </div>
        </form>
    </div>
</div>


<!-- Delete Modal -->
<div id="deleteModal" class="fixed inset-0 z-50 flex items-center justify-center hidden bg-gray-800 bg-opacity-50"
    role="dialog" aria-hidden="true">
    <div class="w-full max-w-md p-6 bg-white rounded-lg">
        <div class="flex items-center justify-between">
            <h2 class="text-xl font-semibold">Delete User</h2>
            <button type="button" onclick="closeModal('deleteModal')" class="text-gray-600 hover:text-gray-900">
                <i class="text-2xl bx bx-x"></i>
            </button>
        </div>
        <div class="mt-4">
            <p class="text-sm text-gray-700">Are you sure you want to delete this user? This action cannot be undone.
            </p>
        </div>
        <div class="flex justify-end mt-6 space-x-4">
            <button type="button" onclick="closeModal('deleteModal')"
                class="px-4 py-2 text-gray-700 bg-gray-300 rounded-md hover:bg-gray-400">Cancel</button>
            <button id="confirmDeleteBtn" type="button"
                class="px-4 py-2 text-white bg-red-600 rounded-md hover:bg-red-700">Delete</button>
        </div>
    </div>
</div>




<script>
    function openModal(modalId) {
        var modal = document.getElementById(modalId);
        modal.classList.remove('hidden');
        modal.classList.add('flex');
    }

    // Function to close a modal
    function closeModal(modalId) {
        var modal = document.getElementById(modalId);
        modal.classList.add('hidden');
        modal.classList.remove('flex');
    }
</script>
