@extends('layouts.sidebar')

@section('title', 'Dashboard')
@section('content')
    @if (in_array('Employee UserInterface', $privileges))
        @if ($showBirthdayNotification)
            <div
                class="relative mb-6 p-5 rounded-xl shadow-xl bg-gradient-to-r from-yellow-100 via-pink-100 to-purple-100 border-l-8 border-yellow-500 flex items-center gap-4">
                <div class="text-4xl animate-bounce">🎉</div>
                <div class="flex-1">
                    <h2 class="text-lg font-bold text-yellow-800">Your Birthday is Coming Up! 🥳</h2>
                    <p class="text-sm text-gray-700">
                        Mark your calendar — it's on
                        <span class="font-semibold text-purple-700">
                            {{ \Carbon\Carbon::parse($user->employee->date_of_birth)->format('F d') }}
                        </span>! 🎂
                    </p>
                </div>
                <div class="text-2xl text-pink-600">🎁</div>
            </div>
        @endif
    @elseif(in_array('Client Interface', $privileges))
        <div class=" mx-auto px-4 py-6">

            <div class="grid gap-8 lg:grid-cols-2 grid-cols-1">
                <!-- 🎂 Upcoming Birthdays -->
                <div>
                    <div
                        class="bg-gradient-to-br from-yellow-50 via-pink-50 to-purple-50 rounded-3xl shadow-xl border border-yellow-200 p-6">
                        <h2 class="text-2xl font-bold text-purple-900 mb-5 flex items-center gap-2">
                            🎉 <span>Upcoming Birthdays</span>
                        </h2>

                        <!-- Search & Pagination -->
                        <div class="flex flex-col sm:flex-row sm:justify-between sm:items-center gap-3 mb-5">
                            <input type="text" id="search" placeholder="Search name..."
                                class="px-4 py-2 border border-gray-300 rounded-lg shadow-sm w-full sm:w-1/2 focus:ring-2 focus:ring-yellow-400 focus:outline-none">

                            <div class="flex gap-2 justify-start sm:justify-end">
                                <button id="prevPage"
                                    class="bg-white border border-gray-300 text-sm px-4 py-1.5 rounded-md hover:bg-gray-100 transition disabled:opacity-50">Prev</button>
                                <button id="nextPage"
                                    class="bg-white border border-gray-300 text-sm px-4 py-1.5 rounded-md hover:bg-gray-100 transition disabled:opacity-50">Next</button>
                            </div>
                        </div>

                        <!-- Birthday List -->
                        <ul id="birthdayList" class="space-y-3"></ul>
                        <p id="noData" class="text-gray-500 text-sm italic hidden mt-3">No upcoming birthdays found.</p>
                    </div>
                </div>

                <!-- 📅 Contract End Dates -->
                <div>
                    <div class="bg-white border border-red-200 shadow-lg rounded-3xl p-6">
                        <div class="flex flex-col sm:flex-row sm:justify-between sm:items-center gap-3 mb-5">
                            <h2 class="text-2xl font-bold text-red-700 flex items-center gap-2">📅 Contracts Ending Soon
                            </h2>

                            <input id="searchEndDate" type="text" placeholder="Search by name..."
                                class="px-4 py-2 border border-gray-300 rounded-lg shadow-sm w-full sm:w-64 focus:ring-2 focus:ring-red-400 focus:outline-none">
                        </div>

                        <!-- Contract List -->
                        <div id="contractList" class="space-y-4 mb-5"></div>

                        <!-- Pagination Controls -->
                        <div class="flex justify-between items-center mt-3">
                            <button id="prevPageEnd"
                                class="bg-white border border-gray-300 text-sm px-4 py-1.5 rounded-md hover:bg-gray-100 transition disabled:opacity-50">Previous</button>
                            <button id="nextPageEnd"
                                class="bg-white border border-gray-300 text-sm px-4 py-1.5 rounded-md hover:bg-gray-100 transition disabled:opacity-50">Next</button>
                        </div>

                        <p id="noDataEnd" class="text-gray-500 italic text-sm hidden mt-4">No upcoming contract endings.</p>
                    </div>
                </div>
            </div>



        </div>
    @else
        <div class=" mx-auto px-4 py-6">
            <!-- Charts Grid -->
            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
                <!-- Employee Chart -->
                <div class="bg-white rounded-2xl shadow-xl p-4">
                    <h3 class="text-md font-semibold text-gray-700 mb-2">Employees</h3>
                    <canvas id="employeeChart" class="w-full h-40"></canvas>
                </div>

                <!-- Agency Chart -->
                <div class="bg-white rounded-2xl shadow-xl p-4">
                    <h3 class="text-md font-semibold text-gray-700 mb-2">Agencies</h3>
                    <canvas id="agencyChart" class="w-full h-40"></canvas>
                </div>

                <!-- Company Chart -->
                <div class="bg-white rounded-2xl shadow-xl p-4">
                    <h3 class="text-md font-semibold text-gray-700 mb-2">Companies</h3>
                    <canvas id="companyChart" class="w-full h-40"></canvas>
                </div>

                <!-- Client Chart -->
                <div class="bg-white rounded-2xl shadow-xl p-4">
                    <h3 class="text-md font-semibold text-gray-700 mb-2">Clients</h3>
                    <canvas id="clientChart" class="w-full h-40"></canvas>
                </div>
            </div>
            <div class="grid gap-8 lg:grid-cols-2 grid-cols-1">
                <!-- 🎂 Upcoming Birthdays -->
                <div>
                    <div
                        class="bg-gradient-to-br from-yellow-50 via-pink-50 to-purple-50 rounded-3xl shadow-xl border border-yellow-200 p-6">
                        <h2 class="text-2xl font-bold text-purple-900 mb-5 flex items-center gap-2">
                            🎉 <span>Upcoming Birthdays</span>
                        </h2>

                        <!-- Search & Pagination -->
                        <div class="flex flex-col sm:flex-row sm:justify-between sm:items-center gap-3 mb-5">
                            <input type="text" id="search" placeholder="Search name..."
                                class="px-4 py-2 border border-gray-300 rounded-lg shadow-sm w-full sm:w-1/2 focus:ring-2 focus:ring-yellow-400 focus:outline-none">

                            <div class="flex gap-2 justify-start sm:justify-end">
                                <button id="prevPage"
                                    class="bg-white border border-gray-300 text-sm px-4 py-1.5 rounded-md hover:bg-gray-100 transition disabled:opacity-50">Prev</button>
                                <button id="nextPage"
                                    class="bg-white border border-gray-300 text-sm px-4 py-1.5 rounded-md hover:bg-gray-100 transition disabled:opacity-50">Next</button>
                            </div>
                        </div>

                        <!-- Birthday List -->
                        <ul id="birthdayList" class="space-y-3"></ul>
                        <p id="noData" class="text-gray-500 text-sm italic hidden mt-3">No upcoming birthdays found.</p>
                    </div>
                </div>

                <!-- 📅 Contract End Dates -->
                <div>
                    <div class="bg-white border border-red-200 shadow-lg rounded-3xl p-6">
                        <div class="flex flex-col sm:flex-row sm:justify-between sm:items-center gap-3 mb-5">
                            <h2 class="text-2xl font-bold text-red-700 flex items-center gap-2">📅 Contracts Ending Soon
                            </h2>

                            <input id="searchEndDate" type="text" placeholder="Search by name..."
                                class="px-4 py-2 border border-gray-300 rounded-lg shadow-sm w-full sm:w-64 focus:ring-2 focus:ring-red-400 focus:outline-none">
                        </div>

                        <!-- Contract List -->
                        <div id="contractList" class="space-y-4 mb-5"></div>

                        <!-- Pagination Controls -->
                        <div class="flex justify-between items-center mt-3">
                            <button id="prevPageEnd"
                                class="bg-white border border-gray-300 text-sm px-4 py-1.5 rounded-md hover:bg-gray-100 transition disabled:opacity-50">Previous</button>
                            <button id="nextPageEnd"
                                class="bg-white border border-gray-300 text-sm px-4 py-1.5 rounded-md hover:bg-gray-100 transition disabled:opacity-50">Next</button>
                        </div>

                        <p id="noDataEnd" class="text-gray-500 italic text-sm hidden mt-4">No upcoming contract endings.
                        </p>
                    </div>
                </div>
            </div>



        </div>


        <script>
            const employeeData = @json(array_values($employeeData->toArray()));
            const employeeMonths = @json(array_keys($employeeData->toArray()));

            const agencyData = @json(array_values($agencyData->toArray()));
            const agencyMonths = @json(array_keys($agencyData->toArray()));

            const companyData = @json(array_values($companyData->toArray()));
            const companyMonths = @json(array_keys($companyData->toArray()));

            const clientData = @json(array_values($clientData->toArray()));
            const clientMonths = @json(array_keys($clientData->toArray()));

            const ctxEmployee = document.getElementById('employeeChart').getContext('2d');
            const employeeChart = new Chart(ctxEmployee, {
                type: 'bar',
                data: {
                    labels: employeeMonths,
                    datasets: [{
                        label: 'Number of Employees',
                        data: employeeData,
                        backgroundColor: 'rgba(75, 192, 192, 0.2)',
                        borderColor: 'rgba(75, 192, 192, 1)',
                        borderWidth: 1
                    }]
                },
                options: {
                    scales: {
                        y: {
                            beginAtZero: true
                        }
                    }
                }
            });

            const ctxAgency = document.getElementById('agencyChart').getContext('2d');
            const agencyChart = new Chart(ctxAgency, {
                type: 'bar',
                data: {
                    labels: agencyMonths,
                    datasets: [{
                        label: 'Number of Agencies',
                        data: agencyData,
                        backgroundColor: 'rgba(255, 159, 64, 0.2)',
                        borderColor: 'rgba(255, 159, 64, 1)',
                        borderWidth: 1
                    }]
                },
                options: {
                    scales: {
                        y: {
                            beginAtZero: true
                        }
                    }
                }
            });

            const ctxCompany = document.getElementById('companyChart').getContext('2d');
            const companyChart = new Chart(ctxCompany, {
                type: 'bar',
                data: {
                    labels: companyMonths,
                    datasets: [{
                        label: 'Number of Companies',
                        data: companyData,
                        backgroundColor: 'rgba(153, 102, 255, 0.2)',
                        borderColor: 'rgba(153, 102, 255, 1)',
                        borderWidth: 1
                    }]
                },
                options: {
                    scales: {
                        y: {
                            beginAtZero: true
                        }
                    }
                }
            });

            const ctxClient = document.getElementById('clientChart').getContext('2d');
            const clientChart = new Chart(ctxClient, {
                type: 'bar',
                data: {
                    labels: clientMonths,
                    datasets: [{
                        label: 'Number of Clients',
                        data: clientData,
                        backgroundColor: 'rgba(255, 99, 132, 0.2)',
                        borderColor: 'rgba(255, 99, 132, 1)',
                        borderWidth: 1
                    }]
                },
                options: {
                    scales: {
                        y: {
                            beginAtZero: true
                        }
                    }
                }
            });
        </script>
        <script>
            document.addEventListener('DOMContentLoaded', () => {
                let currentPage = 1;
                let totalPages = 1;

                const searchInput = document.getElementById('search');
                const birthdayList = document.getElementById('birthdayList');
                const noData = document.getElementById('noData');
                const prevBtn = document.getElementById('prevPage');
                const nextBtn = document.getElementById('nextPage');

                function formatDate(dateStr) {
                    const date = new Date(dateStr);
                    return date.toLocaleDateString('en-US', {
                        month: 'long',
                        day: 'numeric'
                    });
                }

                function loadBirthdays(page = 1) {
                    const query = searchInput.value.trim();
                    const url =
                        `{{ route('api.upcoming-birthdays') }}?page=${page}&search=${encodeURIComponent(query)}`;

                    // Optional: add loading state
                    birthdayList.innerHTML = '<li class="text-sm text-gray-400 italic">Loading...</li>';
                    noData.classList.add('hidden');

                    fetch(url)
                        .then(res => res.ok ? res.json() : Promise.reject('Failed to load data'))
                        .then(data => {
                            birthdayList.innerHTML = '';
                            currentPage = data.current_page;
                            totalPages = data.last_page;

                            if (!data.data.length) {
                                noData.classList.remove('hidden');
                                return;
                            }

                            data.data.forEach((employee, index) => {
                                const isFirst = index === 0;
                                const li = document.createElement('li');
                                li.className = isFirst ?
                                    'flex items-center justify-between bg-yellow-100 border-l-4 border-yellow-500 p-4 rounded-xl shadow-lg animate-pulse' :
                                    'flex items-center justify-between bg-white/70 p-3 rounded-lg shadow-sm hover:bg-yellow-50 transition';

                                li.innerHTML = `
                            <div class="flex items-center gap-3">
                                <div class="${isFirst ? 'text-3xl animate-bounce' : 'text-2xl'}">🎂</div>
                                <div class="${isFirst ? 'text-lg font-bold text-yellow-800' : 'text-gray-800 font-medium'}">
                                    ${employee.first_name} ${employee.last_name}
                                </div>
                            </div>
                            <div class="flex items-center gap-4">
                                <div class="text-sm ${isFirst ? 'text-yellow-700 font-semibold' : 'text-gray-500 font-semibold'}">
                                    ${formatDate(employee.date_of_birth)}
                                </div>
                                <a href="/admin/pre-profile/${employee.encrypted_id}" 
                                   class="flex items-center justify-center ${isFirst ? 'w-9 h-9 bg-yellow-500 hover:bg-yellow-600' : 'w-8 h-8 bg-green-600 hover:bg-green-700'} text-white rounded-md transition"
                                   title="View Profile">
                                    <i class="text-lg bx bx-show"></i>
                                </a>
                            </div>
                        `;

                                birthdayList.appendChild(li);
                            });

                            prevBtn.disabled = currentPage === 1;
                            nextBtn.disabled = currentPage === totalPages;
                        })
                        .catch(err => {
                            birthdayList.innerHTML = '<li class="text-sm text-red-500">Error loading data.</li>';
                            console.error(err);
                        });
                }

                // Event Listeners
                searchInput.addEventListener('input', () => loadBirthdays(1));
                prevBtn.addEventListener('click', () => {
                    if (currentPage > 1) loadBirthdays(currentPage - 1);
                });
                nextBtn.addEventListener('click', () => {
                    if (currentPage < totalPages) loadBirthdays(currentPage + 1);
                });

                // Initial Load
                loadBirthdays();
            });
        </script>
        <script>
            document.addEventListener('DOMContentLoaded', () => {
                let page = 1;
                let lastPage = 1;

                const searchInput = document.getElementById('searchEndDate');
                const contractList = document.getElementById('contractList');
                const noData = document.getElementById('noDataEnd');
                const prevBtn = document.getElementById('prevPageEnd');
                const nextBtn = document.getElementById('nextPageEnd');

                function formatDate(dateStr) {
                    const date = new Date(dateStr);
                    return date.toLocaleDateString('en-US', {
                        month: 'long',
                        day: 'numeric',
                        year: 'numeric'
                    });
                }

                function loadContracts(p = 1) {
                    const search = searchInput.value.trim();
                    contractList.innerHTML = '<div class="text-sm text-gray-400 italic">Loading...</div>';
                    noData.classList.add('hidden');

                    fetch(`{{ route('api.contracts-ending') }}?page=${p}&search=${encodeURIComponent(search)}`)
                        .then(res => res.json())
                        .then(data => {
                            contractList.innerHTML = '';
                            page = data.current_page;
                            lastPage = data.last_page;

                            if (!data.data.length) {
                                noData.classList.remove('hidden');
                                return;
                            }

                            data.data.forEach(item => {
                                const div = document.createElement('div');
                                div.className =
                                    'grid grid-cols-4 gap-4 items-center p-4 bg-white shadow-sm rounded hover:bg-yellow-50 transition';

                                div.innerHTML = `
                            <div class="text-gray-900 font-semibold">${item.first_name} ${item.last_name}</div>
                            <div class="text-gray-600">${item.position ?? 'N/A'}</div>
                            <div class="text-red-600 font-medium">${formatDate(item.employment_end_date)}</div>
                            <div>
                                <a href="/admin/pre-profile/${item.encrypted_id}" 
                                   class="flex items-center justify-center w-9 h-9 bg-yellow-500 hover:bg-yellow-600 text-white rounded-md transition"
                                   title="View Profile">
                                    <i class="text-lg bx bx-show"></i>
                                </a>
                            </div>
                        `;
                                contractList.appendChild(div);
                            });

                            prevBtn.disabled = page === 1;
                            nextBtn.disabled = page === lastPage;
                        })
                        .catch(() => {
                            contractList.innerHTML = '<div class="text-sm text-red-500">Failed to load data.</div>';
                        });
                }

                // Debounce input
                let debounceTimeout;
                searchInput.addEventListener('input', () => {
                    clearTimeout(debounceTimeout);
                    debounceTimeout = setTimeout(() => loadContracts(1), 300);
                });

                prevBtn.addEventListener('click', () => {
                    if (page > 1) loadContracts(page - 1);
                });

                nextBtn.addEventListener('click', () => {
                    if (page < lastPage) loadContracts(page + 1);
                });

                loadContracts();
            });
        </script>


    @endif
@endsection
