<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Zenorex Quotation Email</title>
</head>

<body style="margin: 0; padding: 0; font-family: 'Poppins', sans-serif; background-color: #f9f9f9; color: black;">
    <div style="max-width: 1000px; margin: 0 auto; padding: 40px; background-color: #ffffff; border: 1px solid #ddd;">
        <h2 style="text-align: left; font-size: 24px; margin-bottom: 20px; color: black;">Zenorex</h2>
        <p style="text-align: right; font-size: 15px; margin-bottom: 20px; color: black;">Quotation
            #{{ $order->reference }}</p>
        <div>
            <p style="font-size: 20px; font-weight: bold; margin-bottom: 10px; color: black;">Thank you for your inquiry!
            </p>
            <p style="margin-bottom: 20px; color: black;">We're getting your final quotation ready. We will notify you
                when it has been
                sent.</p>

            <h3 style="font-size: 18px; margin-top: 30px; margin-bottom: 10px; color: black;">Quotation Summary</h3>
        </div>

        <div>
            @php
                use App\Models\Products;
                $products = Products::all();
                $items = json_decode($order->items);
                $quantities = json_decode($order->quantity);
            @endphp

            @if ($items && $quantities)
                @foreach ($items as $index => $item)
                    @php
                        $matchedProduct = $products->firstWhere('model', $item);
                    @endphp
                    @if ($matchedProduct)
                        <div style="margin-bottom: 15px; display: flex; justify-content: space-between;">
                            <div style="width: 50%;">
                                <p style="font-size: 16px; font-weight: bold; margin: 0; color: black;">
                                    {{ $item }} x
                                    {{ $quantities[$index] }}</p>
                                <p style="font-size: 14px; margin: 5px 0 0; color: black;">X-Sense - Standalone Smoke
                                    Alarms</p>
                            </div>

                            <div style="width: 50%; text-align: right; color: black;">
                                <p style="font-size: 16px; margin: 0; color: black;">
                                    ₱{{ number_format($matchedProduct->price, 2) }}
                                </p>
                            </div>
                        </div>
                    @endif
                @endforeach
            @endif
        </div>

        <div style="margin-top: 20px; text-align: right; padding-top: 10px; border-top: 1px solid #ddd;">
            <div style="margin-bottom: 15px; display: flex; justify-content: space-between;">
                <div style="width: 50%;">
                    <p style="margin: 0; font-size: 14px; color: black;">Subtotal</p>
                </div>
                <div style="width: 50%;">
                    <p style="margin: 0; font-size: 14px; color: black;">₱{{ number_format($order->total_amount, 2) }}
                    </p>
                </div>
            </div>
            <div style="margin-bottom: 15px; display: flex; justify-content: space-between;">
                <div style="width: 50%;">
                    <p style="margin: 0; font-size: 14px; color: black;">Shipping and Handling</p>
                </div>
                <div style="width: 50%;">
                    <p style="margin: 0; font-size: 14px; color: black;">TBA</p>
                </div>
            </div>
        </div>

        <div style="margin-top: 30px;">
            <h3 style="font-size: 18px; margin-bottom: 10px; color: black;">Customer Information</h3>
        </div>

        <div style="display: flex; align-items: center; margin-bottom: 20px; margin-left: 50px;">

            <div style="width: 33%;">
                <p style="font-weight: bold; margin-bottom: 5px; color: black;">Personal Information</p>
                <p style="margin: 0; font-size: 14px; color: black;">{{ $order->personalFirstname }}
                    {{ $order->personalLastname }}
                </p>
                <p style="margin: 0; font-size: 14px; color: black;">{{ $order->personalCompanyname }}</p>
                <p style="margin: 0; font-size: 14px; color: black;">{{ $order->personalEmail }}</p>
                <p style="margin: 0; font-size: 14px; color: black;">{{ $order->personalNumber }}</p>
            </div>

            <div style="width: 33%;">
                <p style="font-weight: bold; margin-bottom: 5px; color: black;">Shipping Information</p>
                <p style="margin: 0; font-size: 14px; color: black;">{{ $order->shipFirstname }}
                    {{ $order->shipLastname }}</p>
                <p style="margin: 0; font-size: 14px; color: black;">{{ $order->shipAddress }}</p>
                <p style="margin: 0; font-size: 14px; color: black;">{{ $order->shipNumber }}</p>
            </div>

            <div style="width: 33%;">
                <p style="font-weight: bold; margin-bottom: 5px; color: black;">Billing Information</p>
                <p style="margin: 0; font-size: 14px; color: black;">{{ $order->billFirstname }}
                    {{ $order->billLastname }}</p>
                <p style="margin: 0; font-size: 14px; color: black;">{{ $order->billAddress }}</p>
                <p style="margin: 0; font-size: 14px;color: black;">{{ $order->billNumber }}</p>
            </div>
        </div>
    </div>
</body>

</html>
