<script>
    document.addEventListener("DOMContentLoaded", function() {
        const notifBtn = document.getElementById("notif-btn");
        const notifDropdown = document.getElementById("notif-dropdown");
        const notifList = document.getElementById("notification-list");
        const notifCount = document.getElementById("notif-count");
        const loadingSpinner = document.getElementById("loading-spinner");

        let offset = 0;
        const limit = 8;
        let loading = false;
        let hasMore = true;

        // Toggle notification dropdown on button click
        notifBtn.addEventListener("click", function(event) {
            notifDropdown.classList.toggle("hidden");

            // Load notifications only if dropdown is opened
            if (!notifDropdown.classList.contains("hidden") && notifList.childElementCount === 0) {
                loadNotifications();
            }

            // Prevent event from bubbling to document click
            event.stopPropagation();
        });

        // Prevent dropdown from closing when clicking inside
        notifDropdown.addEventListener("click", function(event) {
            event.stopPropagation();
        });

        // Close dropdown when clicking outside
        document.addEventListener("click", function(event) {
            if (!notifBtn.contains(event.target) && !notifDropdown.contains(event.target)) {
                notifDropdown.classList.add("hidden");
            }
        });

        // Fetch total notification count
        async function fetchAllCount() {
            try {
                let response = await fetch(`{{ route('notifications.fetch') }}?offset=0`);
                if (!response.ok) throw new Error(`HTTP error! Status: ${response.status}`);

                let data = await response.json();
                let totalNotifications = data.allCount;

                // Update notification count badge
                if (totalNotifications > 0) {
                    notifCount.textContent = totalNotifications;
                    notifCount.classList.remove("hidden");
                } else {
                    notifCount.classList.add("hidden");
                }
            } catch (error) {
                console.error("Fetch error:", error);
            }
        }

        // Load notifications with infinite scroll
        async function loadNotifications() {
            if (loading || !hasMore) return;
            loading = true;
            loadingSpinner.classList.remove("hidden");

            try {
                let response = await fetch(
                    `{{ route('notifications.fetch') }}?offset=${offset}&limit=${limit}`);
                if (!response.ok) throw new Error(`HTTP error! Status: ${response.status}`);

                let data = await response.json();

                if (data.notifications.length === 0 && data.departments_without_data.length === 0) {
                    hasMore = false;
                    loadingSpinner.textContent = "No more notifications";
                    return;
                }

                data.notifications.forEach(dept => {
                    let li = document.createElement("li");
                    li.classList.add("p-3", "hover:bg-gray-100", "cursor-pointer", "flex",
                        "items-start", "gap-2");

                    let formattedDate = new Date(dept.end).toLocaleDateString("en-US", {
                        year: "numeric",
                        month: "long",
                        day: "numeric"
                    });

                    li.innerHTML = `
                    <span class="w-2 h-2 mt-2 bg-blue-500 rounded-full"></span>
                    <a href="#" class="block text-sm text-gray-700">
                        Client <b>${dept.department_name}</b> is ending on <b>${formattedDate}</b>
                    </a>`;

                    notifList.appendChild(li);
                });

                data.departments_without_data.forEach(dept => {
                    let li = document.createElement("li");
                    li.classList.add("p-3", "hover:bg-gray-100", "cursor-pointer", "flex",
                        "items-start", "gap-2");

                    li.innerHTML = `
                    <span class="w-2 h-2 mt-2 bg-yellow-500 rounded-full"></span>
                    <a href="#" class="block text-sm text-gray-700">
                        Client <b>${dept.department_name}</b> has no data for the last <b>15 days</b>
                    </a>`;

                    notifList.appendChild(li);
                });

                hasMore = data.has_more;
                offset += limit;
            } catch (error) {
                console.error("Fetch error:", error);
            } finally {
                loading = false;
                loadingSpinner.classList.add("hidden");
            }
        }

        // Infinite scrolling inside dropdown
        notifList.addEventListener("scroll", function() {
            if (notifList.scrollTop + notifList.clientHeight >= notifList.scrollHeight - 10) {
                loadNotifications();
            }
        });

        // Auto-update total notification count every 10 seconds
        fetchAllCount();
        setInterval(fetchAllCount, 10000);
    });
</script>
