<!doctype html>
<html>

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    @vite('resources/css/app.css')
    <script src="https://cdn.tailwindcss.com"></script>
</head>

<body>


    <body>
        @if ($errors->any())
            <div class="mb-4">
                <div class="relative px-4 py-3 text-red-700 bg-red-100 border border-red-400 rounded" role="alert">
                    {{ $errors->first() }}
                </div>
            </div>
        @endif

        <div class="flex items-center justify-center min-h-screen">
            <div class="bg-white rounded-lg shadow-lg  relative md:w-[75rem] w-full container">
                <img src="{{ asset('img/Login Shape.png') }}" class="absolute inset-0 w-full h-full">
                <div class="relative flex flex-col items-center gap-20 p-8 md:flex-row ">
                    <div class="w-full h-full"> <img src="{{ asset('img/Vector-Employees.png') }}"
                            class="w-full h-full">
                    </div>


                    <div class="w-full h-full">
                        <form method="POST" action="{{ route('login') }}">
                            @csrf
                            <div class="flex items-center justify-center"> <img
                                    src="{{ asset('img/new_logo.jpg') }}" class=""></div>
                            <p class="my-2 text-xs font-medium text-center text-green-600">Login to get going</p>

                            <div class="mb-4">
                                <label for="email" class="block text-sm font-medium text-gray-700">Email:</label>
                                <input type="email"
                                    class="block w-full p-2 mt-1 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring focus:ring-blue-500"
                                    id="email" name="email"  required>
                            </div>
                            <div class="mb-6">
                                <label for="password" class="block text-sm font-medium text-gray-700">Password:</label>
                                <input type="password"
                                    class="block w-full p-2 mt-1 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring focus:ring-blue-500"
                                    id="pw" name="password" required>
                                <div class="flex items-center gap-2 mt-2 justify-end"> <input type="checkbox"
                                        onclick="document.getElementById('pw').type = this.checked ? 'text' : 'password'">
                                    <label>Show Password</label>
                                </div>


                            </div>
                            <button type="submit"
                                class="w-full py-2 text-white transition duration-200 bg-green-600 rounded-md hover:bg-green-500">Submit</button>
                        </form>
                        <div class="mt-4 text-center">
                            {{-- <a href="#" class="text-green-600 hover:underline">Forgot your password?</a> --}}
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <script>
            window.addEventListener('pageshow', function(event) {
                if (event.persisted || (window.performance && window.performance.navigation.type === 2)) {
                    window.location.reload();
                }
            });
        </script>
    </body>

</html>
