<?php

namespace App\Http\Controllers\Backend;

use App\Models\TrendColor;
use App\Models\ProductTrend;
use Illuminate\Http\Request;
use App\Http\Traits\FileUpload;
use App\Http\Controllers\Controller;

class AddColorController extends Controller
{
    use FileUpload;
    
    public function index()
    {
        $colors = TrendColor::get();
        return view('backend.modules.add-colors.index', compact('colors'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'color' => 'required',
            'color_images' => 'required',
        ]);

        $multipleImages = $request->color_images ?? null;

        if (isset($multipleImages) &&  !empty($multipleImages)) {
            $arrayImages = [];
            foreach ($multipleImages as $key => $value) {
                if ($value->getError() === UPLOAD_ERR_OK) {
                    $arrayImages[] = $this->fileUpload($value);
                }
            }
        } else {
            $arrayImages = [];
        }

        $encodedImages = empty($arrayImages) ? json_encode([]) : json_encode($arrayImages);

        TrendColor::create([
            'color' => $request->color,                       
            'product_trend_id' => $request->product_trend_id,                     
            'color_images' => $encodedImages,                     
        ]);

        return back()->with('success', 'Color added successfully');
    }

    public function edit($id)
    {
        $colors = TrendColor::findorFail($id);

        return view('backend.modules.add-colors.edit', compact('colors'));
    }

    public function update(Request $request, $id)
    {
        $colors = TrendColor::findorFail($id);

        if ($request->color_images != null) {

            $multipleImages = $request->color_images ?? null;

            if (isset($multipleImages) &&  !empty($multipleImages)) {
                $arrayImages = [];
                foreach ($multipleImages as $key => $value) {
                    if ($value->getError() === UPLOAD_ERR_OK) {
                        $arrayImages[] = $this->fileUpload($value);
                    }
                }
            } else {
                $arrayImages = [];
            }
    
            $encodedImages = empty($arrayImages) ? json_encode([]) : json_encode($arrayImages);

            $request->validate([
                'color_images' => 'required|required|mimes:jpeg,jpg,png',
            ]);

            $colors->update([
                'color' => $request->color,                        
                'color_images' => $encodedImages,              
            ]);

        } else {
            $colors->update([
                'color' => $request->color,                                 
            ]);

            return back()->with('success', 'Successfully edited product.');
        }
    }

    public function destroy($id)
    {
        TrendColor::findOrFail($id)->delete();

        return back()->with('success', 'Color deleted successfully');
    }
}
