<?php

namespace App\Http\Controllers\Backend;

use App\Models\TrendSize;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use App\Http\Controllers\Controller;

class AddSizeController extends Controller
{
    public function index()
    {
        $sizes = TrendSize::get();
        return view('backend.modules.add-sizes.index', compact('sizes'));
    }

    public function store(Request $request)
    {
        $request->validate([
            // 'size' => [
            //     'required',
            //     Rule::in(['Extra Small', 'Small', 'Medium', 'Large', 'Extra Large', 'Freesize']),
            //     Rule::unique('trend_sizes', 'size')->where(function ($query) use ($request) {
            //         return $query->where('trend_color_id', $request->trend_color_id);
            //     })
            // ],
            'stocks' => 'required'
        ]);

        TrendSize::create([
            'size' => $request->size,                       
            'trend_color_id' => $request->trend_color_id,                                  
            'stocks' => $request->stocks,            
        ]);

        return back()->with('success', 'Color added successfully');
    }

    public function destroy (Request $request, $id)
    {
        TrendSize::find($id)->delete();

        return back()->with('success', 'Size deleted successfully.');
    }
}
