<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Http\Traits\FileUpload;
use App\Models\Blog;
use Illuminate\Http\Request;

class BlogController extends Controller
{
    use FileUpload;

    public function index()
    {
        $blogs = Blog::all();

        return view('backend.modules.blogs.index', compact('blogs'));
    }

    public function create()
    {
        return view('backend.modules.blogs.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'thumbnail' => 'required|image|mimes:jpeg,jpg,png,gif,svg|max:5048',
            'title' => 'required',
            'author' => 'required',
            'description' => 'required',
        ]);

        if (isset($request->multiple_images)) {
            foreach ($request->multiple_images as $key => $value) {
                if ($value->getError() === UPLOAD_ERR_OK) {
                    $arrayImages[] = $this->fileUpload($value);
                }
            }
        } else {
            $arrayImages = [];
        }

        $file = $request->thumbnail;
        $file_name = time() . 'pi' . '.' . $file->getClientOriginalExtension();
        $destination = public_path() . '/uploads/blogs';
        $file->move($destination, $file_name);

        Blog::create([
            'thumbnail' => $file_name,
            'multiple_images' => json_encode($arrayImages),
            'youtube_link' => $request->youtube_link,
            'title' => $request->title,
            'author' => $request->author,
            'description' => $request->description,
        ]);

        return redirect('admin/blogs')->with('success', 'Blog added successfully');
    }

    public function show($id)
    {
        //
    }

    public function edit($id)
    {
        $blogs = Blog::findOrFail($id);
        return view('backend.modules.blogs.edit', compact('blogs'));
    }

    public function update(Request $request, $id)
    {
        $blogs = Blog::findorFail($id);

        if ($request->thumbnail != null) {
            $request->validate([
                'thumbnail' => 'required|image|mimes:jpeg,jpg,png,gif,svg|max:5048',
                'title' => 'required',
                'author' => 'required',
                'description' => 'required',
            ]);

            $file = $request->thumbnail;
            $file_name = time() . 'pi' . '.' . $file->getClientOriginalExtension();
            $destination = public_path() . '/uploads/blogs';
            $file->move($destination, $file_name);

            $blogs->update([
                'thumbnail' => $file_name,
                'title' => $request->title,
                'author' => $request->author,
                'description' => $request->description,
            ]);
        } elseif ($request->thumbnail != null && $request->multiple_images != null) {
            if (isset($request->multiple_images)) {
                foreach ($request->multiple_images as $key => $value) {
                    if ($value->getError() === UPLOAD_ERR_OK) {
                        $arrayImages[] = $this->fileUpload($value);
                    }
                }
            } else {
                $arrayImages = [];
            }
            $file = $request->thumbnail;
            $file_name = time() . 'pi' . '.' . $file->getClientOriginalExtension();
            $destination = public_path() . '/uploads/blogs';
            $file->move($destination, $file_name);

            $blogs->update([
                'thumbnail' => $file_name,
                'multiple_images' => json_encode($arrayImages),
                'title' => $request->title,
                'author' => $request->author,
                'description' => $request->description,
            ]);
        } elseif ($request->multiple_images != null) {
            if (isset($request->multiple_images)) {
                foreach ($request->multiple_images as $key => $value) {
                    if ($value->getError() === UPLOAD_ERR_OK) {
                        $arrayImages[] = $this->fileUpload($value);
                    }
                }
            } else {
                $arrayImages = [];
            }
            $blogs->update([
                'multiple_images' => json_encode($arrayImages),
                'title' => $request->title,
                'author' => $request->author,
                'description' => $request->description,
            ]);
        } else {
            $blogs->update([
                'title' => $request->title,
                'author' => $request->author,
                'description' => $request->description,
            ]);
        }

        return redirect('admin/blogs')->with('success', 'Successfully edited blog.');
    }

    public function destroy($id)
    {
        $blogs = Blog::findOrFail($id);
        $blogs->delete();

        return redirect('admin/blogs')->with('success', 'Successfully deleted blog');
    }
}
