<?php

namespace App\Http\Controllers\Backend;

use App\Models\Career;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class CareerController extends Controller
{
    public function index()
    {
        $careers = Career::all();
        return view('backend.modules.careers.index' , compact('careers'));
    }

    public function create()
    {
        return view('backend.modules.careers.create');
    }
    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required',
            'vacancy' => 'required',
            'location' => 'required',
            'description' => 'required',
        ]);
    

        $careers = Career::create([
            'title' => $request->title,
            'vacancy' => $request->vacancy,
            'location' => $request->location,
            'description' => $request->description,
        ]);
        
        return redirect('admin/careers')->with('success', 'Successfully added new career.');
    }

    public function show($id)
    {
        
    }

    public function edit($id)
    {
        $careers = Career::findOrFail($id);
        return view('backend.modules.careers.edit', compact('careers'));
    }

    public function update(Request $request, $id)
    {
        $careers = Career::findOrFail($id);

        $careers->update([
            'title' => $request->title,
            'vacancy' => $request->vacancy,
            'location' => $request->location,
            'description' => $request->description,
        ]);

        return redirect('admin/careers')->with('success', 'Successfully edited career.');
    }

    public function destroy($id)
    {
        $careers = Career::findOrFail($id);
        $careers->delete();

        return redirect('admin/careers')->with('success', 'Successfully deleted career.');
    }
}
