<?php

namespace App\Http\Controllers\Backend;

use App\Models\Top;
use App\Models\Pant;
use App\Models\Jacket;
use App\Models\SubType;
use App\Models\Category;
use App\Models\Jumpsuit;
use App\Models\TrendSize;
use App\Models\ColorTrend;
use App\Models\TrendColor;
use App\Models\ProductType;
use App\Models\ProductTrend;
use Illuminate\Http\Request;
use App\Http\Traits\FileUpload;
use App\Http\Controllers\Controller;

class ProductTrendController extends Controller
{

    use FileUpload;

    public function index()
    {
        $trends = ProductTrend::get();
        return view('backend.modules.trends.index', compact('trends'));
    }

    public function create()
    {
        $categories = Category::get();
        $types = ProductType::get();
        $sub = SubType::get();

        return view('backend.modules.trends.create', compact('categories', 'types', 'sub'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'thumbnail' => 'required|mimes:jpeg,jpg,png,gif',
            'name' => 'required|unique:product_trends,name',
            'price' => 'required',
            'category' => 'required',
        ]);

        $file = $request->file('thumbnail');
        $file_name = time() . 'pi.' . $file->getClientOriginalExtension();
        $destination = public_path() . '/uploads/trends';
        $file->move($destination, $file_name);

        $trends = ProductTrend::create([
            'thumbnail' => $file_name,
            'name' => $request->name,
            'price' => $request->price,
            'category' => $request->category,
            'type' => $request->type,
            'sub_type' => $request->sub_type,
            'description' => $request->description,
            'materials' => $request->materials,
        ]);

        return redirect('admin/trends/' . $trends->id . '/edit')->with('success', 'Product added successfully');
    }

    public function show($id)
    {
        //
    }

    public function edit($id)
    {
        $categories = Category::get();
        $types = ProductType::get();
        $sub = SubType::get();
        $trends = ProductTrend::findOrFail($id);
        return view('backend.modules.trends.edit', compact('trends', 'categories', 'types', 'sub'));
    }

    public function update(Request $request, $id)
    {
        $trends = ProductTrend::findOrFail($id);

        if($request->thumbnail != null){
            $request->validate([
                'thumbnail' => 'required|required|mimes:jpeg,jpg,png',
            ]);

            $file = $request->thumbnail;
            $file_name = time() .'pi' . '.' . $file->getClientOriginalExtension();
            $destination = public_path() . '/uploads/trends';
            $file->move($destination, $file_name);

            $trends->update([
                'thumbnail' => $file_name,
                'name' => $request->name,
                'price' => $request->price,
                'category' => $request->category,
                'type' => $request->type,
                'sub_type' => $request->sub,
                'description' => $request->description,
                'materials' => $request->materials,
            ]);

        } else {

            // $request->validate([
            //     'name' => 'required',
            //     'price' => 'required',
            //     'stocks' => 'required',
            //     'materials' => 'required',
            //     'category' => 'required',
            // ]);

            $trends->update([
                'name' => $request->name,
                'price' => $request->price,
                'category' => $request->category,
                'type' => $request->type,
                'sub_type' => $request->sub,
                'description' => $request->description,
                'materials' => $request->materials,
            ]);

        }
        
        return back()->with('success', 'Successfully edited product.');
    }

    public function destroy($id)
    {
        $trends = ProductTrend::findOrFail($id);
        $trends->delete();

        return redirect('admin/trends')->with('success', 'Product deleted successfully');
    }
}
