<?php

namespace App\Http\Controllers\Backend;

use App\Models\SubType;
use App\Models\ProductType;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class SubTypeController extends Controller
{
    public function index()
    {
        $sub = SubType::all();
        return view('backend.modules.sub-types.index' , compact('sub'));
    }

    public function create()
    {
        return view('backend.modules.sub-types.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'sub_type' => 'required|unique:sub_types,sub_type',
        ]);
    
        $sub = SubType::create([
            'sub_type' => $request->sub_type,
        ]);

        return redirect('admin/sub-types')->with('success', 'Successfully added new sub type.');
    }


    public function destroy($id)
    {
        $sub = SubType::findOrFail($id);
        $sub->delete();

        return redirect('admin/sub-types')->with('success', 'Successfully deleted sub type.');
    }
}
