<?php

namespace App\Http\Controllers\Backend;

use App\Models\ProductTrend;
use App\Models\VoucherTrend;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class VoucherTrendController extends Controller
{
    public function index()
    {
        $voucher_trends = VoucherTrend::latest()->get();
        return view('backend.modules.voucher-trends.index', compact('voucher_trends'));
    }

    public function create()
    {
        $trends = ProductTrend::orderBy('name', 'ASC')->get();
        return view('backend.modules.voucher-trends.create', compact('trends'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'code' => 'required|unique:voucher_trends,code',
            'amount' => 'required|numeric',
            'type' => 'required',
        ]);

        VoucherTrend::create([
            'code' => $request->code,
            'type' => $request->type,
            'amount' => $request->amount,
            'count_app' => $request->count_app,
            'product_promo' => json_encode($request->product_promo),
        ]);

        return redirect('admin/voucher-trends')->with('success', 'New voucher code added successfully');
    }

    public function show(Request $request, $id)
    {
        $voucher_trends = VoucherTrend::findOrFail($id);
        return view('backend.modules.voucher-trends.show', compact('voucher_trends'));
    }

    public function edit($id)
    {
        $voucher_trends = VoucherTrend::findOrFail($id);
        $trends = ProductTrend::orderBy('name', 'ASC')->get();
        return view('backend.modules.voucher-trends.edit', compact('voucher_trends', 'trends'));
    }

    public function update(Request $request, $id)
    {
        $voucher_trends = VoucherTrend::findOrFail($id);

        $request->validate([
            'code' => 'required|unique:voucher_trends,code,' . $id,
            'amount' => 'required|numeric',
            'type' => 'required',
        ]);

        $voucher_trends->update([
            'code' => $request->code,
            'type' => $request->type,
            'amount' => $request->amount,
            'count_app' => $request->count_app,
            'product_promo' => json_encode($request->product_promo),
        ]);

        return redirect('admin/voucher-trends')->with('success', 'New voucher code edited successfully');
    }

    public function destroy($id)
    {
        $voucher_trends = VoucherTrend::findOrFail($id);
        $voucher_trends->delete();
        return back()->with('success', 'Voucher code deleted successfully');
    }
}
