<?php

namespace App\Http\Controllers\Frontend;

use App\Models\Order;
use App\Models\TrendSize;
use App\Models\TrendColor;
use App\Models\ProductSkin;
use App\Models\VoucherSkin;
use App\Models\ProductTrend;
use App\Models\VoucherTrend;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class CartController extends Controller
{
    public function index(Request $request)
    {
        return view('frontend.pages.cart.index');
    }

    public function create(Request $request)
    {
        if (!session('cart')) {
            return redirect('cart');
        }

        $request->validate([
            'promo_code' => [
                'nullable',
                function ($attribute, $value, $fail) {
                    $voucherTrend = \App\Models\VoucherTrend::where('code', $value)->first();
                    $voucherSkin = \App\Models\VoucherSkin::where('code', $value)->first();
        
                    if (!$voucherTrend && !$voucherSkin) {
                        $fail('This code does not exist.');
                    }
                }
            ]
        ]);

        $promo_code = null;
        $promo_type = null;
        $promo_amount = null;
        $promo_count = null;
        $product_promo = null;

        if ($request->promo_code) {
            $voucherTrend = VoucherTrend::where('code', $request->promo_code)->first();
            $voucherSkin = VoucherSkin::where('code', $request->promo_code)->first();

            if ($voucherTrend) {
                if ($request->service_type) {
                    session()->put('service_type', $request->service_type);
                }

                $promo_code = $voucherTrend->code;
                $promo_type = $voucherTrend->type;
                $promo_amount = $voucherTrend->amount;
                $promo_count = $voucherTrend->count_app;
                $product_promo = $voucherTrend->product_promo;
                // session()->put('promo_code', $voucherTrend->code);
                // session()->put('promo_type', $voucherTrend->type);
                // session()->put('promo_amount', $voucherTrend->amount);
                // session()->put('promo_count', $voucherTrend->count_app);
                // session()->put('product_promo', $voucherTrend->product_promo);

            } elseif ($voucherSkin) {
                if ($request->service_type) {
                    session()->put('service_type', $request->service_type);
                }

                $promo_code = $voucherSkin->code;
                $promo_type = $voucherSkin->type;
                $promo_amount = $voucherSkin->amount;
                $promo_count = $voucherSkin->count_app;
                $product_promo = $voucherSkin->product_promo;
                // session()->put('promo_code', $voucherSkin->code);
                // session()->put('promo_type', $voucherSkin->type);
                // session()->put('promo_amount', $voucherSkin->amount);
                // session()->put('promo_count', $voucherSkin->count_app);
                // session()->put('product_promo', $voucherSkin->product_promo);
            }

        }

        if ($request->service_type) {
            // session()->put('service_type', $request->service_type);
            $service_type = $request->service_type;
        }
        
        // $promo_code = session()->get('promo_code');
        // $promo_type = session()->get('promo_type');
        // $promo_amount = session()->get('promo_amount');
        // $promo_count = session()->get('promo_count');
        // $product_promo = session()->get('product_promo');
        // $service_type = session()->get('service_type');

        // return view('frontend.pages.cart.create', [
        //     'promo_code' => $promo_code,
        //     'promo_type' => $promo_type,
        //     'promo_amount' => $promo_amount,
        //     'promo_count' => $promo_count,
        //     'product_promo' => $product_promo,
        //     'service_type' => $service_type,
        // ]);
        
        return view('frontend.pages.cart.create', 
        compact('promo_code', 'promo_type', 'promo_amount', 'promo_count', 'product_promo', 'service_type',));
    }

    public function show(Request $request, $id)
    {
        $selectedShop = $request->shop;
        $selectedSize = $request->size;
        $selectedColor = $request->color;

        if ($request->shop == 'trends') {
            $trends = ProductTrend::findOrFail($id);
            $color = TrendColor::where('product_trend_id', $trends->id)
            ->where('color', $selectedColor)->first();
            $id = $color->id;

            $size = TrendSize::where('trend_color_id', $id)
            ->where('size', $selectedSize)->first();
        }
        if ($request->shop == 'skins') {
            $skins = ProductSkin::findOrFail($id);
        }

        $cart = session()->get('cart', []);

        if ($request->minus) {
            if ($cart[$id]['quantity'] == 1) {
                unset($cart[$id]);
            } else {
                $cart[$id]['quantity']--;
            }
            session()->put('cart', $cart);
            return redirect('cart');
        }

        if ($request->clear) {
            if (isset($cart[$id])) {
                unset($cart[$id]);
            }
            session()->put('cart', $cart);
            return redirect('cart')->with('success', 'Cart updated successfully');
        }

        if(isset($cart[$id])) {
            $cart[$id]['quantity']++;

            session()->put('cart', $cart);
            return redirect('cart')->with('success', 'Cart updated successfully');
        } else {
            if($request->quantity == null){

                if ($request->shop == 'trends') {

                    $cart[$id] = [
                        'id' => $color->id,
                        "name" => $trends->name,
                        "quantity" => 1,
                        "price" => $trends->price,
                        "image" => $trends->thumbnail,
                        "color" => $color->color,
                        "size" => $size->size,
                        "stocks" => $size->stocks,
                        "shop" => $selectedShop,
                    ];
                }

                if ($request->shop == 'skins') {

                    $cart[$id] = [
                        'id' => $id,
                        "name" => $skins->name,
                        "quantity" => 1,
                        "price" => $skins->price,
                        "stocks" => $skins->stocks,
                        "image" => $skins->thumbnail,
                        "shop" => $selectedShop,
                    ];
                }
            }
            // else {

            //     if ($request->shop == 'trends') {
            //         $trends = ProductTrend::findOrFail($id);
                
            //         $cart[$id] = [
            //             'id' => $id,
            //             "name" => $trends->name,
            //             "quantity" => $request->quantity,
            //             "price" => $trends->price,
            //             "image" => $trends->thumbnail,
            //             "color" => $selectedColor,
            //             "size" => $selectedSize,
            //             "shop" => $selectedShop,
            //         ];
            //     }

            //     elseif ($request->shop == 'skins') {
            //         $skins = ProductSkin::findOrFail($id);
                    
            //         $cart[$id] = [
            //             'id' => $id,
            //             "name" => $skins->name,
            //             "quantity" => $request->quantity,
            //             "price" => $skins->price,
            //             "image" => $skins->thumbnail,
            //             "shop" => $selectedShop,
            //         ];
            //     }
            // }

            session()->put('cart', $cart);

            return redirect('cart')->with('success', 'Product added to cart successfully!');
        }
    }

    public function payment(Request $request)
    {
        // return $request;
        session()->put('first_name', $request->first_name);
        session()->put('last_name', $request->last_name);
        session()->put('address', $request->address);
        session()->put('phone', $request->phone);
        session()->put('notes', $request->notes);
        session()->put('assigned_date', $request->assigned_date);
        session()->put('assigned_time', $request->assigned_time);
        session()->put('service_type', $request->service_type);

        $request->validate([
            'first_name' => 'required',
            'last_name' => 'required',
            'email' => 'required|email',
            'address' => 'required',
            // 'phone' => [
            //     'required',
            //     'regex:/^\d{10}$/',
            // ],
            'assigned_date' => [
                'required',
                'date',
                'after_or_equal:' . date('Y-m-d'),
            ],
            'assigned_time' => [
                'required',
                function ($attribute, $value, $fail) use ($request) {
                    $selectedDateTime = $request->assigned_date . ' ' . $value;
                    $currentDateTime = now()->setTimezone('Asia/Manila')->format('Y-m-d H:i');
        
                    if ($selectedDateTime <= $currentDateTime) {
                        $fail('The selected date and time must be in the future.');
                    }
                },
            ],
        ], [
            'phone.regex' => 'Invalid contact number. Please enter a valid Philippine mobile number.',
        ]);

        $request->request->add([
            'reference' => rand(111111, 999999)
        ]);

        if (!session('cart')) {
            return redirect('cart');
        }

        $color = [];
        $size = [];
        
        foreach (session('cart') as $cart) {
            if (isset($cart['color'])) {
                $color[] = $cart['color'];
            }
        }
        
        $color_string = isset($color) ? json_encode($color) : null;
        
        foreach (session('cart') as $cart) {
            if (isset($cart['size'])) {
                $size[] = $cart['size'];
            }
        }
        
        $size_string = isset($size) ? json_encode($size) : null;

        // return session('cart');
        foreach (session('cart') as $cart) {
            $items[] = [
                'id' => $cart['id'],
                'name' => $cart['name'],
                'type' => $cart['shop'],
                'attributes' => $cart['shop'] == 'skins'? null : [
                    'color' => $cart['color'],
                    'size' => $cart['size'],
                ],
                'qty' => $cart['quantity'],
            ];
        }
        $item_string = json_encode($items);

        $shop = [];
        foreach (session('cart') as $cart) {
            $shop[] = $cart['shop'];
        }
        $shop_string = json_encode($shop);

        $colorId = [];
        foreach (session('cart') as $cart) {
            $colorId[] = $cart['id'];
        }
        $colorId_string = json_encode($colorId);

        Order::create([
            'reference' => $request->reference,
            'cart_total' => $request->cart_total,
            'total' => $request->total,
            'first_name' => $request->first_name,
            'last_name' => $request->last_name,
            'email' => $request->email,
            'address' => $request->address,
            'phone' => '+63' . $request->phone,
            'notes' => $request->notes,
            'payment_status' => 'Unpaid',
            'payment_method' => $request->payment_method,
            'item' => $item_string,
            // 'quantity' => $quantity_string,
            'color' => $color_string,
            'size' => $size_string,
            'shop' => $shop_string,
            'color_id' => $colorId_string,
            'service_type' => $request->service_type,
            'order_status' => 'For Confirmation',
            'assigned_date' => $request->assigned_date,
            'assigned_time' => $request->assigned_time,
        ]);

        session()->forget('cart');
        session()->forget('promo_code');
        session()->forget('promo_type');
        session()->forget('promo_amount');

        session(['reference' => $request->reference]);
        return redirect('payment-success');
    }
}
