<?php

namespace App\Http\Controllers\Frontend;

use App\Models\Blog;
use App\Models\Brand;
use App\Models\Banner;
use App\Models\Career;
use App\Models\Inquiry;
use App\Models\SubType;
use App\Models\Category;
use App\Models\ProductSkin;
use App\Models\ProductType;
use App\Models\ProductTrend;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class PageController extends Controller
{

    public function home (Request $request)
    {
        $banners = Banner::all();
        $skins = ProductSkin::all();
        $trends = ProductTrend::all();
        $big_blog = Blog::orderBy('created_at', 'desc')->first();
        $blogs = Blog::orderBy('created_at', 'desc')->skip(1)->take(3)->get();

        return view('frontend.pages.home', compact('banners', 'skins', 'trends', 'blogs', 'big_blog'));
    }

    public function aboutUs (Request $request)
    {
        return view('frontend.pages.about-us');
    }

    public function shopSkin (Request $request)
    {
        $skins = ProductSkin::orderBy('name', 'asc')->paginate(12);
        return view('frontend.pages.shop-skin', compact('skins'));
    }

    public function shopTrends(Request $request)
    {
        $trends = ProductTrend::orderBy('name', 'asc')->paginate(12);
        $categories = Category::all();        
        $types = ProductType::all();        
        $sub = SubType::all();        
        return view('frontend.pages.shop-trends', compact('trends', 'categories', 'types', 'sub'));
    }

    public function trendFilter(Request $request)
    {
        $category = $request->input('category');
        $type = $request->input('type');
        $subType = $request->input('sub_type');
        
        $minPrice = $request->input('min_price');
        $maxPrice = $request->input('max_price');
        
        $selectedSize = $request->input('size');
        
        $query = ProductTrend::query();
        
        if ($category) {
            $query->whereIn('category', $category);
        }
        
        if ($type) {
            $query->where('type', $type);
        }
        
        if ($subType) {
            $query->where('sub_type', $subType);
        }
        
        if ($minPrice && $maxPrice) {
            $query->whereBetween('price', [$minPrice, $maxPrice]);
        }
    
        $searchQuery = $request->input('query');
        if ($searchQuery) {
            $query->where(function ($innerQuery) use ($searchQuery) {
                $innerQuery->where('name', 'like', '%' . $searchQuery . '%')
                            ->orWhere('category', 'like', '%' . $searchQuery . '%')
                            ->orWhere('type', 'like', '%' . $searchQuery . '%');
            });
        }
        
        $trends = $query->paginate(12);
    
        $categories = Category::all();
        $types = ProductType::all();
        $sub = SubType::all();
        
        return view('frontend.pages.shop-trends', compact('trends', 'categories', 'types', 'sub'));
    }
    

    public function skinFilter(Request $request)
    {
        $minPrice = $request->input('min_price');
        $maxPrice = $request->input('max_price');

        $query = ProductSkin::query();

        if ($minPrice && $maxPrice) {
            $query->whereBetween('price', [$minPrice, $maxPrice]);
        }

        $skins = $query->paginate(12);

        return view('frontend.pages.shop-skin', compact('skins'));
    }
    
    public function shopSkinSingle (Request $request)
    {
        return view('frontend.pages.shop-skin-single');
    }

    public function shopTrendsSingle (Request $request)
    {
        return view('frontend.pages.shop-trends-single');
    }

    public function blogs (Request $request)
    {
        $blogs = Blog::orderBy('id', 'desc')->paginate(6);

        return view('frontend.pages.blogs', compact('blogs'));
    }

    public function brands (Request $request)
    {
        $brands = Brand::orderBy('id', 'desc')->paginate(6);

        return view('frontend.pages.brands', compact('brands'));
    }

    public function careers (Request $request)
    {
        $careers = Career::orderBy('id', 'desc')->paginate(6);

        return view('frontend.pages.careers', compact('careers'));
    }

    public function blogSingle (Request $request)
    {
        return view('frontend.pages.blog-single');
    }

    public function careerSingle (Request $request)
    {
        return view('frontend.pages.career-single');
    }

    public function contactUs (Request $request)
    {
        return view('frontend.pages.contact-us');
    }

    public function myCart (Request $request)
    {
        return view('frontend.pages.my-cart');
    }

    public function checkout (Request $request)
    {
        return view('frontend.pages.checkout');
    }

    public function contact (Request $request)
    {
        // return $request;

        $request->validate([
            'name' => 'required',
            'email' => 'required',
            'phone' => 'required',
            'message' => 'required',
        ]);

        Inquiry::create($request->all());
        return redirect('/contact-us')->with('success', ' '); 
    }

    public function paySuccess (Request $request)
    {
        return view('frontend.pages.payment-success');
    }

    public function payError (Request $request)
    {
        return view('frontend.pages.payment-error');
    }

    public function searchTrend(Request $request)
    {
        $query = $request->input('query');
        $trends = ProductTrend::where('name', 'like', '%'.$query.'%')
            ->paginate(15);
            return view('frontend.pages.shop-trends', ['trends' => $trends]);
    }

    public function searchSkin(Request $request)
    {
        $query = $request->input('query');
        $skins = ProductSkin::where('name', 'like', '%'.$query.'%')
            ->paginate(15);
            return view('frontend.pages.shop-skin', ['skins' => $skins]);
    }
}
