<?php

namespace App\Http\Controllers\Frontend;

use App\Models\ProductSkin;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class ProductViewSkinController extends Controller
{
    public function show(Request $request, $name)
    {
        $skins = ProductSkin::where('name', $name)->firstOrFail();

        $quantity  = 0;
        if(session('cart')) {
            foreach (session('cart') as $cart) {
                if ($cart['id'] == $skins->id) {
                    $quantity += $cart['quantity'];
                }
            }
        }
    
        return view('frontend.pages.shop-skin-single', compact('skins', 'quantity'));
    }
}
