<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->longText('name');
            $table->longText('thumbnail');
            $table->longText('multiple_images')->nullable();
            $table->integer('stocks');
            $table->double('price');
            $table->longText('description')->nullable();
            $table->longText('type');
            $table->longText('tops')->nullable();
            $table->longText('sweaters')->nullable();
            $table->longText('jackets')->nullable();
            $table->longText('hoodies')->nullable();
            $table->longText('dresses')->nullable();
            $table->longText('pants')->nullable();
            $table->longText('jeans')->nullable();
            $table->longText('shorts')->nullable();
            $table->longText('skirts')->nullable();
            $table->longText('sets')->nullable();
            $table->longText('jumpsuits')->nullable();
            $table->longText('others')->nullable();
            $table->longText('accessories')->nullable();
            $table->longText('girl_clothes')->nullable();
            $table->longText('baby_clothes')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('products');
    }
};
