@extends('backend.layouts.app')

@section('content')

<div class="p-3">
    <div class="row">
        <div class="col-12 col-md-8">
            <div class="card mb-3">
                <div class="card-header fw-bold">
                    <div class="float-left">
                        Edit Product
                    </div>
                    <div class="float-right">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb bg-white mb-0 p-0">
                                <li class="breadcrumb-item"><a href="{{ url('admin/trends') }}">Trends Apparel</a></li>
                                <li class="breadcrumb-item"><a href="{{ url('admin/trends/' . $colors->product_trend_id . '/edit') }}">Edit Color</a></li>
                                <li class="breadcrumb-item active" aria-current="page">Edit Size</li>
                            </ol>
                        </nav>
                    </div>
                </div>
                <div class="card-body">
                    <form action="{{ url('admin/add-colors/' . $colors->id) }}" method="POST" enctype="multipart/form-data">@csrf @method('put')
                        <div class="row">
        
                            <div class="col-12 mb-3">
                                <label for="">Color Name</label>
                                <input type="text" class="form-control" required name="color" value="{{ $colors->color }}" />
                                @error('color')
                                    <span class="text-danger">
                                        {{ $message }}
                                    </span>
                                @enderror
                            </div>
                            <div class="col-12 mb-3">
                                <label for="">Product Color Images</label>
                                <input type="file" class="form-control" name="color_images[]" multiple/>
        
                                @error('color_images')
                                <span class="text-danger">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>
        
                            <div class="col-12 text-right">
                                <button type="submit" class="btn btn-success">Add Color</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            <div class="card">
                <div class="card-header">
                    Current Product Images
                </div>
                <div class="card-body">
                    @php
                    $images = json_decode($colors->color_images) ?? [];
                    @endphp
                    @foreach ($images as $key => $color_images)
                    <img src="{{ asset('uploads/' . $color_images) }}" class="mx-1" height="80" alt="">
                    @endforeach
                </div>
            </div>
        </div>
        <div class="col-12 col-md-4">
            <form method="POST" action="{{ url('admin/add-sizes?trend_color_id=' . $colors->id) }}" enctype="multipart/form-data">@csrf
                <div class="card mb-3">
                    <div class="card-header">
                        Add Size
                    </div>
                    <div class="card-body p-2">
                        <div class="row">
                            <div class="col-12 form-group">
                                <label>Size:</label>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="size" id="size_xs" value="Extra Small" {{ old('size') === 'Extra Small' ? 'checked' : '' }}>
                                    <label class="form-check-label" for="size_xs">
                                        Extra Small
                                    </label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="size" id="size_s" value="Small" {{ old('size') === 'Small' ? 'checked' : '' }}>
                                    <label class="form-check-label" for="size_s">
                                        Small
                                    </label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="size" id="size_m" value="Medium" {{ old('size') === 'Medium' ? 'checked' : '' }}>
                                    <label class="form-check-label" for="size_m">
                                        Medium
                                    </label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="size" id="size_l" value="Large" {{ old('size') === 'Large' ? 'checked' : '' }}>
                                    <label class="form-check-label" for="size_l">
                                        Large
                                    </label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="size" id="size_xl" value="Extra Large" {{ old('size') === 'Extra Large' ? 'checked' : '' }}>
                                    <label class="form-check-label" for="size_xl">
                                        Extra Large
                                    </label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="size" id="size_freesize" value="Freesize" {{ old('size') === 'Freesize' ? 'checked' : '' }}>
                                    <label class="form-check-label" for="size_freesize">
                                        Freesize
                                    </label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="size" id="size_plus" value="Plus Size" {{ old('size') === 'Plus Size' ? 'checked' : '' }}>
                                    <label class="form-check-label" for="size_plus">
                                        Plus Size
                                    </label>
                                </div>
                                @error('size')
                                    <code>{{ $message }}</code>
                                @enderror
                            </div>
                            
                            <div class="col-12 form-group">
                                <label>Stocks</label>
                                <input class="form-control" type="text" name="stocks" value="{{ old('stocks') }}">
                                @error('stocks')
                                    <code>{{ $message }}</code>
                                @enderror
                            </div>
                        </div>
                    </div>
                    <div class="card-footer text-right">
                        <button type="submit" class="btn btn-success">Add Size</button>
                    </div>
                </div>
                </form>

                <div class="card">
                    <div class="card-header">
                        Sizes:
                    </div>
                    <div class="card-body">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>Size</th>
                                    <th>Stocks</th>
                                    <th style="width: 10%:">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($colors->sizes as $items)
                                <tr>
                                    <td>{{ $items->size }}</td>
                                    <td>{{ $items->stocks }}</td>
                                    <td class="d-flex">
                                        <form action="{{ url('admin/add-sizes/' . $items->id) }}" class="mx-3" method="POST">
                                            @csrf @method('delete')
                                            <button type="submit" class="btn btn-danger">
                                                Delete
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
        </div>
    </div>
</div>

@section('css')
@endsection

@section('js')
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.js"></script>
<script>
    $(document).ready(function() {
        $('.table').DataTable({
            order: [['0', 'asc']]
        });
    });
</script>
@endsection

@endsection