@extends('backend.layouts.app')

@section('content')

<div class="p-3">
    <div class="card">
        <div class="card-header hstack">
            <span class="fw-bold">Product Colors</span>&emsp;
        </div>
        <div class="card-body">
            <table class="table table-striped" style="width:100%">
                <thead>
                  <tr>
                    <th>ID</th>
                    {{-- <th>Product Thumbnail</th> --}}
                    <th>Product Name</th>
                    <th>Color</th>
                    <th>Action</th>
                  </tr>
                </thead>
                
                <tbody>
                    @foreach ($colors as $items)
                <tr>
                  <td>{{ $items->id }}</td>
                  {{-- <td>
                    <img src="{{ asset('uploads/trends/' . $items->thumbnail)}}" height="50" alt="">
                  </td> --}}
                  <td>{{ $items->name }}</td>
                  <td>{{ $items->color }}</td>
                  <td class="d-flex">
                    <a href="
                    {{ url('admin/add-colors/' . $items->id) }}/edit" class="text-decoration-none">
                      <button type="button" class="btn btn-outline-primary">Edit</button>
                    </a>
                    <form action="{{ url('admin/add-colors/' . $items->id) }}" method="POST"> @csrf @method('delete')
                      <button class="btn btn-danger mx-1" type="submit">Delete</button>
                    </form>
                  </td>
                </tr>
                @endforeach
                </tbody>
              </table>
        </div>
    </div>
</div>

@endsection

@section('js')
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.js"></script>
@yield('js')
<script>
    $(document).ready(function() {
        $('.table').DataTable({
          order: [['0', 'desc']]
        });
    });
</script>
@endsection