@extends('backend.layouts.app')

@section('content')
    <div class="p-3">
        <div class="card">
            <div class="card-header fw-bold">
                <span class="fw-bold">Banners</span>&emsp;
                <a href="{{ url('admin/banners/create') }}" class="text-decoration-none">
                    <button type="button" class="btn btn-success">
                        <i class="fas fa-edit nav-icon"></i>
                        Add Banner
                    </button>
                </a>
            </div>
            <div class="card-body">
                <table class="table table-striped" style="width:100%">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Images</th>
                            <th>Action</th>
                        </tr>
                    </thead>

                    <tbody>
                        @foreach ($banners as $items)
                            <tr>
                                <td>{{ $items->id }}</td>
                                <td>
                                    <img src="{{ asset('banners/' . $items->image) }}" height="50" alt="">
                                </td>
                                <td class="d-flex">
                                    <form action="{{ url('admin/banners/' . $items->id) }}" method="POST" class="mx-3">
                                        @csrf @method('delete')
                                        <button class="btn btn-danger" type="submit">Delete</button>
                                    </form>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection

@section('js')
    <script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.js"></script>
    @yield('js')
    <script>
        $(document).ready(function() {
            $('.table').DataTable({
                order: [
                    [1, 'asc']
                ]
            });
        });
    </script>
@endsection
