@extends('backend.layouts.app')

@section('content')

<div class="p-3">
    <div class="card">
        <div class="card-header fw-bold">
            Add Brand
        </div>
        <div class="card-body">
            <form action="{{ url('admin/brands') }}" method="POST" enctype="multipart/form-data">@csrf
                <div class="row">

                    <div class="col-12 mb-3">
                        <label for="">Logo </label>
                        <input type="file" class="form-control" required name="logo" value="{{ old('logo') }}" />
                        @error('logo')
                            <span class="text-danger">
                                {{ $message }}
                            </span>
                        @enderror
                    </div>

                    <div class="col-12 mb-3">
                        <label for="">Title </label>
                        <input type="text" class="form-control" required name="title" value="{{ old('title') }}" />
                        @error('title')
                            <span class="text-danger">
                                {{ $message }}
                            </span>
                        @enderror
                    </div>

                    <div class="col-12 mb-3">
                        <label for="">Description </label>
                        <textarea type="textarea" rows="3" class="form-control" id="description" required name="description" value="{{ old('description') }}"></textarea>
                        @error('description')
                            <span class="text-danger">
                                {{ $message }}
                            </span>
                        @enderror
                    </div>

                    <div class="col-12 text-right">
                        <button type="submit" class="btn btn-success">Add Brand</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

@endsection

@section('js')
<script src="https://cdn.ckeditor.com/4.16.0/standard/ckeditor.js"></script>
<script type="text/javascript">
    CKEDITOR.replace('description');
</script>
<script>
$('.dropdown-toggle').dropdown();
</script>
@endsection