@extends('backend.layouts.app')

@section('content')

<div class="p-3">
    <div class="card">
        <div class="card-header fw-bold">
          <span class="fw-bold">Brands</span>&emsp;
          <a href="{{ url('admin/brands/create') }}" class="text-decoration-none">
            <button type="button" class="btn btn-success">
              <i class="fas fa-edit nav-icon"></i>
              Add Brand
            </button>
          </a>
        </div>
        <div class="card-body">
            <table class="table table-striped" style="width:100%">
                <thead>
                  <tr>
                    <th>Logo</th>
                    <th>Title</th>
                    <th>Description</th>
                    <th>Action</th>
                  </tr>
                </thead>
                
                <tbody>
                    @foreach ($brands as $items)
                <tr>
                    <td>
                      <img src="{{ asset('uploads/brands/' . $items->logo)}}" height="50" alt="">
                    </td>
                    <td>{{ $items->title }}</td>
                    <td>{!! Str::limit($items->description, 100, '...') !!}</td>
                    <td class="d-flex">
                      <a href="{{ url('admin/brands/' .$items->id) }}/edit" class="text-decoration-none">
                        <button type="button" class="btn btn-outline-primary">Edit</button>
                      </a>
                      <form action="{{ url('admin/brands/' . $items->id ) }}" method="POST" class="mx-3"> @csrf @method('delete')
                        <button class="btn btn-danger" type="submit">Delete</button>
                      </form>
                    </td>
                </tr>
                @endforeach
                </tbody>
              </table>
        </div>
    </div>
</div>


@endsection

@section('js')
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.js"></script>
<script>
  $(document).ready( function () {
    $('.table').DataTable();
} );
</script>
@endsection