@extends('backend.layouts.app')

@section('content')

<div class="p-3">
    <div class="card">
        <div class="card-header fw-bold">
            Create Career
        </div>
        <div class="card-body">
            <form action="{{ url('admin/careers') }}" method="POST" enctype="multipart/form-data">@csrf
                <div class="row">

                    <div class="col-12 mb-3">
                        <label for="">Position Name </label>
                        <input type="text" class="form-control" required name="title" value="{{ old('title') }}" />
                        @error('title')
                            <span class="text-danger">
                                {{ $message }}
                            </span>
                        @enderror
                    </div>

                    <div class="col-12 mb-3">
                        <label for="">Vacancy </label>
                        <input type="number" class="form-control" required name="vacancy" value="{{ old('vacancy') }}" />
                        @error('vacancy')
                            <span class="text-danger">
                                {{ $message }}
                            </span>
                        @enderror
                    </div>

                    <div class="col-12 mb-3">
                        <label for="">Office Location </label>
                        <input type="text" class="form-control" required name="location" value="{{ old('location') }}" />
                        @error('location')
                            <span class="text-danger">
                                {{ $message }}
                            </span>
                        @enderror
                    </div>

                    <div class="col-12 mb-3">
                        <label for="">Description </label>
                        <textarea rows="3" type="text" class="form-control" required id="description" name="description" value="{{ old('description') }}"></textarea>
                        @error('description')
                            <span class="text-danger">
                                {{ $message }}
                            </span>
                        @enderror
                    </div>

                    <div class="col-12 text-right">
                        <button type="submit" class="btn btn-success">Create Career</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

@endsection

@section('js')
<script src="https://cdn.ckeditor.com/4.16.0/standard/ckeditor.js"></script>
<script type="text/javascript">
    CKEDITOR.replace('description');
</script>
<script>
$('.dropdown-toggle').dropdown();
</script>
@endsection