@extends('backend.layouts.app')

@section('content')

<div class="p-3">
    <div class="card">
        <div class="card-header fw-bold">
          <span class="fw-bold">Categories</span>&emsp;
          <a href="{{ url('admin/categories/create') }}" class="text-decoration-none">
            <button type="button" class="btn btn-success">
              <i class="fas fa-edit nav-icon"></i>
              Add Category
            </button>
          </a>
        </div>
        <div class="card-body">
            <table class="table table-striped" style="width:100%">
                <thead>
                  <tr>
                    <th>ID</th>
                    <th>Category</th>
                    <th>Action</th>
                  </tr>
                </thead>
                
                <tbody>
                  @foreach ($categories as $items)
                  <tr>
                    <td>{{ $items->id }}</td>
                      <td>{{ $items->name }}</td>
                      <td class="d-flex">
                        <form action="{{ url('admin/categories/' . $items->id ) }}" method="POST" class="mx-3"> @csrf @method('delete')
                          <button class="btn btn-danger" type="submit">Delete</button>
                        </form>
                      </td>
                  </tr>
                  @endforeach
                </tbody>
              </table>
        </div>
    </div>
</div>

@endsection

@section('js')
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.js"></script>
@yield('js')
<script>
    $(document).ready(function() {
        $('.table').DataTable({
            order: [[0, 'desc']]
        });
    });
</script>
@endsection