@extends('backend.layouts.app')

@section('content')

<div class="p-3">
    <div class="card">
        <div class="card-header fw-bold">
          <span class="fw-bold">Inquiries</span>&emsp;
        </div>
        <div class="card-body">
            <table class="table table-striped" style="width:100%">
                <thead>
                  <tr>
                    <th>Name</th>
                    <th>Email</th>
                    <th>Phone</th>
                    <th>Message</th>
                    <th>Action</th>
                  </tr>
                </thead>
                
                <tbody>
                  @foreach ($inquiries as $items)
                  <tr>
                      <td>{{$items->name}}</td>
                      <td>{{$items->email}}</td>
                      <td>{{$items->phone}}</td>
                      <td>{{$items->message}}</td>
                      <td>
                        <div class="d-flex">
                          <form action="{{ url('admin/inquiries/' . $items->id ) }}" method="POST" class="mx-3"> @csrf @method('delete')
                            <button class="btn btn-danger" type="submit">Delete</button>
                          </form>
                        </div>
                      </td>
                  </tr>
                @endforeach
                </tbody>
              </table>
        </div>
    </div>
</div>


@endsection

@section('js')
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.js"></script>
<script>
  $(document).ready( function () {
    $('.table').DataTable();
} );
</script>
@endsection