@extends('backend.layouts.app')

@section('content')

<div class="p-3">
    <div class="card">
        <div class="card-header fw-bold">
            Create Products
        </div>
        <div class="card-body">
            <form action="{{ url('admin/skins') }}" method="POST" enctype="multipart/form-data">@csrf
                <div class="row">
                    <div class="col-12 mb-3">
                        <label for="">Product Name </label>
                        <input type="text" class="form-control" required name="name" value="{{ old('name') }}" />
                        @error('name')
                            <span class="text-danger">
                                {{ $message }}
                            </span>
                        @enderror
                    </div>

                    <div class="col-12 mb-3">
                        <label for="">Product Thumbnail Image </label>
                        <input type="file" class="form-control" required name="thumbnail" value="{{ old('thumbnail') }}" />
                        @error('thumbnail')
                            <span class="text-danger">
                                {{ $message }}
                            </span>
                        @enderror
                    </div>

                    <div class="col-12 mb-3">
                        <label for="">Product Images</label> <span><i>(Please add thumbnail image here)</i></span>
                        <input type="file" class="form-control" name="multiple_images[]" value="{{ old('multiple_images[]') }}" multiple/>
                    </div>

                    <div class="col-12 mb-3">
                        <label for="">Price </label>
                        <input type="number" class="form-control" required name="price" value="{{ old('price') }}" />
                        @error('price')
                            <span class="text-danger">
                                {{ $message }}
                            </span>
                        @enderror
                    </div>
                    
                    <div class="col-12 mb-3">
                        <label for="">Stocks </label>
                        <input type="number" class="form-control" name="stocks" value="{{ old('stocks') }}" />
                        @error('stocks')
                            <span class="text-danger">
                                {{ $message }}
                            </span>
                        @enderror
                    </div>

                    <div class="col-12 mb-3">
                        <label for="">Description </label>
                        <textarea rows="3" type="text" class="form-control" name="description" id="description" value="{{ old('description') }}"></textarea>
                    </div>

                    <div class="col-12 mb-3">
                        <label for="">Product Ingredients </label>
                        <textarea rows="3" type="text" class="form-control" name="ingredients" id="ingredients" value="{{ old('ingredients') }}"></textarea>
                    </div>

                    <div class="col-12 text-right">
                        <button type="submit" class="btn btn-success">Create Product</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

@section('js')
<script src="https://cdn.ckeditor.com/4.16.0/standard/ckeditor.js"></script>
<script type="text/javascript">
    CKEDITOR.replace('description');
</script>
<script type="text/javascript">
    CKEDITOR.replace('ingredients');
</script>
@endsection

@endsection