@extends('backend.layouts.app')

@section('content')

<div class="p-3">
    <div class="card">
        <div class="card-header fw-bold">
            <div class="float-left">
                Create Products
            </div>
            <div class="float-right">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb bg-white mb-0 p-0">
                        <li class="breadcrumb-item"><a href="{{ url('admin/trends') }}">Trends Apparel</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Create</li>
                    </ol>
                </nav>
            </div>
        </div>
        <div class="card-body">
            <form action="{{ url('admin/trends') }}" method="POST" enctype="multipart/form-data">@csrf
                <div class="row">
                    <div class="col-12 mb-3">
                        <label for="">Product Name </label>
                        <input type="text" class="form-control" required name="name" value="{{ old('name') }}" />
                        @error('name')
                            <span class="text-danger">
                                {{ $message }}
                            </span>
                        @enderror
                    </div>

                    <div class="col-12 mb-3">
                        <label for="">Product Thumbnail Image </label>
                        <input type="file" class="form-control" required name="thumbnail" value="{{ old('thumbnail') }}" />
                        @error('thumbnail')
                            <span class="text-danger">
                                {{ $message }}
                            </span>
                        @enderror
                    </div>

                    <div class="col-12 mb-3">
                        <label for="">Product Category </label>
                        <select class="form-select" aria-label="Default select example" name="category">
                            <option selected disable hidden>Select Category</option>
                            @foreach ($categories as  $category)
                            <option value="{{ $category->name }}">{{ $category->name }}</option>
                            @endforeach
                        </select>
                        @error('category')
                            <span class="text-danger">
                                {{ $message }}
                            </span>
                        @enderror
                    </div>

                    <div class="col-12 mb-3">
                        <label for="">Product Type</label>
                        <select class="form-select" aria-label="Default select example" name="type" id="typeSelect">
                            <option selected disabled hidden>Select Type</option>
                            @foreach ($types as $item)
                                <option value="{{ $item->type }}">{{ $item->type }}</option>
                            @endforeach
                        </select>
                        @error('type')
                            <span class="text-danger">
                                {{ $message }}
                            </span>
                        @enderror
                    </div>

                    <div class="col-12 mb-3">
                        <label for="">Sub Type</label>
                        <select class="form-select" aria-label="Default select example" name="sub_type" id="typeSelect">
                            <option selected disabled hidden>Select Sub Type</option>
                            @foreach ($sub as $item)
                                <option value="{{ $item->sub_type }}">{{ $item->sub_type }}</option>
                            @endforeach
                        </select>
                        @error('sub_type')
                            <span class="text-danger">
                                {{ $message }}
                            </span>
                        @enderror
                    </div>

                    <div class="col-12 mb-3">
                        <label for="">Price </label>
                        <input type="number" class="form-control" required name="price" value="{{ old('price') }}" />
                        @error('price')
                            <span class="text-danger">
                                {{ $message }}
                            </span>
                        @enderror
                    </div>

                    <div class="col-12 mb-3">
                        <label for="">Description </label>
                        <textarea rows="3" type="text" class="form-control" name="description" id="description" value="{{ old('description') }}"></textarea>
                    </div>

                    <div class="col-12 mb-3">
                        <label for="">Product Ingredients </label>
                        <textarea rows="3" type="text" class="form-control" name="materials" id="materials" value="{{ old('materials') }}"></textarea>
                    </div>

                    <div class="col-12 text-right">
                        <button type="submit" class="btn btn-success">Create Product</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

@section('css')
@endsection

@section('js')
<script src="https://cdn.ckeditor.com/4.16.0/standard/ckeditor.js"></script>
<script type="text/javascript">
    CKEDITOR.replace('description');
</script>
<script type="text/javascript">
    CKEDITOR.replace('materials');
</script>

{{-- <script>
    document.addEventListener('DOMContentLoaded', function() {
      const addButton = document.querySelector('.btn-primary');
      const arrayContainer = document.getElementById('arrayContainer');
  
      addButton.addEventListener('click', function(event) {
        event.preventDefault();
  
        const row = document.createElement('div');
        row.classList.add('row');
  
        const imagesColumn = document.createElement('div');
        imagesColumn.classList.add('col-12', 'mb-3');
        const imagesLabel = document.createElement('label');
        imagesLabel.textContent = 'Product Images';
        const imagesInput = document.createElement('input');
        imagesInput.type = 'file';
        imagesInput.classList.add('form-control');
        imagesInput.name = 'multiple_images[]';
        imagesInput.multiple = true;
  
        const colorColumn = document.createElement('div');
        colorColumn.classList.add('col-4', 'mb-3');
        const colorLabel = document.createElement('label');
        colorLabel.textContent = 'Color';
        const colorInput = document.createElement('input');
        colorInput.type = 'text';
        colorInput.classList.add('form-control');
        colorInput.required = true;
        colorInput.name = 'color[]';
        colorInput.value = '';
  
        const stockColumn = document.createElement('div');
        stockColumn.classList.add('col-4', 'mb-3');
        const stockLabel = document.createElement('label');
        stockLabel.textContent = 'Stocks';
        const stockInput = document.createElement('input');
        stockInput.type = 'number';
        stockInput.classList.add('form-control');
        stockInput.required = true;
        stockInput.name = 'stocks[]';
        stockInput.value = '';
  
        const deleteColumn = document.createElement('div');
        deleteColumn.classList.add('col-4', 'mb-3', 'pt-4');
        const deleteButton = document.createElement('button');
        deleteButton.classList.add('btn', 'btn-danger');
        deleteButton.innerHTML = '<i class="fa-solid fa-trash"></i> Delete';
        deleteButton.addEventListener('click', function() {
          arrayContainer.removeChild(row);
        });
  
        imagesColumn.appendChild(imagesLabel);
        imagesColumn.appendChild(imagesInput);
  
        colorColumn.appendChild(colorLabel);
        colorColumn.appendChild(colorInput);
  
        stockColumn.appendChild(stockLabel);
        stockColumn.appendChild(stockInput);
  
        deleteColumn.appendChild(deleteButton);
  
        row.appendChild(imagesColumn);
        row.appendChild(colorColumn);
        row.appendChild(stockColumn);
        row.appendChild(deleteColumn);
  
        arrayContainer.appendChild(row);
      });
    });
</script> --}}
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
@endsection

@endsection