@extends('backend.layouts.app')

@section('content')

<div class="p-3">
    <div class="card">
        <div class="card-header fw-bold">
            Edit Voucher
        </div>
        <div class="card-body">
            <form action="{{ url('admin/voucher-trends/' . $voucher_trends->id) }}" method="POST" enctype="multipart/form-data">
            @csrf @method('put')
                <div class="row">
                
                    <div class="col-12 mb-3">
                        <label for="">Code: </label>
                        <input type="text" class="form-control" required name="code" value="{{ $voucher_trends->code }}" />
                        @error('code')
                            <span class="text-danger">
                                {{ $message }}
                            </span>
                        @enderror
                    </div>

                    <div class="col-12 mb-3">
                        <label for="">Discount Type: </label>
                        <select id="discount" required name="type" class="form-control">
                            <option @if($voucher_trends->type === 'Fixed') selected @endif value="Fixed">Fixed amount</option>
                            <option @if($voucher_trends->type === 'Percentage') selected @endif value="Percentage">Percentage total amount</option>
                            <option @if($voucher_trends->type === 'Percentage count') selected @endif value="Percentage count">Percentage by count</option>
                            <option @if($voucher_trends->type === 'Fixed count') selected @endif value="Fixed count">Fixed by count</option>
                        </select>
                        @error('type')
                            <span class="text-danger">
                                {{ $message }}
                            </span>
                        @enderror
                    </div>

                    <div class="col-12 mb-3">
                      <label id="amount" for="">Amount: *</label>
                        <input type="number" class="form-control" required name="amount" value="{{ $voucher_trends->amount }}" />
                        @error('amount')
                            <span class="text-danger">
                                {{ $message }}
                            </span>
                        @enderror
                    </div>
                    <div id="countParent" class="col-12 mb-3 d-none">
                        <label for="">Count applicable: *</label>
                        <input id="countInput" type="number" required class="form-control" name="count_app" value="{{ $voucher_trends->count_app }}" />
                        @error('count_app')
                            <span class="text-danger">
                                {{ $message }}
                            </span>
                        @enderror
                  </div>

                    <div class="col-12 mb-5">
                    <label for="" class="mb-3">Select Product's to add in this voucher: </label>
                    <table class="table table-sm table-hover table-stripped" id="promoTable">
                        <thead>
                        <tr>
                            <th>Image</th>
                            <th>Product Name</th>
                            <th> <input type="checkbox" class="select-all" name="" id="checkAll"> <label for="checkAll">Select All</label></th>
                        </tr>
                        </thead>
                        <tbody>
        
                        @foreach ($trends as $items)
                        <tr>
                            <td>
                                <label for="{{$items->id}}">
                                    <img height="20px" src="{{ asset('uploads/trends/' . $items->thumbnail)}}" alt="">
                                </label>
                            </td>
                            <td>
                                <label for="{{$items->id}}">
                                    <p class="mb-0 font-weight-normal">
                                        {{ $items->name }}
                                    </p>
                                </label>
                            </td>
                            <td> <input class="checkbox" type="checkbox" id="{{$items->id}}" value="{{ $items->id }}" name="product_promo[]"> </td>
                            
                        </tr>
                        
                        @endforeach
        
                        </tbody>
                    </table>
                </div>


                    <div class="col-12 text-right">
                        <button type="submit" class="btn btn-success">Edit Voucher</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>



@section('css')
<link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.css" rel="stylesheet">
@endsection

@section('js')
<script src="https://cdn.ckeditor.com/4.16.0/standard/ckeditor.js"></script>
<script type="text/javascript">
    CKEDITOR.replace('description');
</script>

<script>

$('.dropdown-toggle').dropdown();

</script>
<script>
$(document).ready( function () {
    $('#promoTable').DataTable();
} );
  
  $("#checkAll").change(function () {
      $("input:checkbox").prop('checked', $(this).prop("checked"));
  });
  
  $("#discount").change(function () {
      if ($(this).val() == 'Fixed' || $(this).val() == 'Fixed count') {
          $('#amount').text('Fixed amount:')
      }else{
          $('#amount').text('Percentage amount: %')
      }
      
      if ($(this).val() == 'Percentage count' || $(this).val() == 'Fixed count') {
          $("#countParent").removeClass('d-none')
          $("#countInput").prop('disabled', false);
      }else{
          $("#countInput").prop('disabled', true);
          $("#countParent").addClass('d-none')
      }
  });
  if ($("#discount").val() == 'Fixed' || $("#discount").val() == 'Fixed count') {
      $('#amount').text('Fixed amount:')
  }else{
      $('#amount').text('Percentage amount: %')
  }
  
  if ($("#discount").val() == 'Percentage count' || $("#discount").val() == 'Fixed count') {
      $("#countParent").removeClass('d-none')
      $("#countInput").prop('disabled', false);
  }else{
      $("#countInput").prop('disabled', true);
      $("#countParent").addClass('d-none')
  }
  
  if ($('#discount').val() == 'Fixed') {
      $('#amount').text('Fixed:')
  }else if($('#discount').val() == 'Fixed count'){
      $('#amount').text('Fixed amount:')
  }else{
      $('#amount').text('Percentage amount: %')
  }
  </script>
@endsection

@endsection