@extends('frontend.layouts.app')

@section('seo')
<title>Blogs | eg APPAREL</title>
<meta property="og:locale"          content="en_US" />
<meta property="og:url"             content="" />
<meta property="og:type"            content="website" />
<meta property="og:title"           content="Blogs | eg APPAREL" />
<meta property="og:description"     content="" />
<meta property="og:site_name"       content="Blogs | eg APPAREL" />
<meta property="og:image"           content="{{ asset('resources/web_thumb.jpg') }}" />
<meta property="og:thumbnail"           content="{{ asset('resources/web_thumb.jpg') }}" />
@endsection

@section('content')
<div class="container-fluid bg-alt py-5">
  <div class="container">
    <div>
      <div class="row gx-5 gy-5">
        <div class="col-12 col-sm-12 col-md-12 col-lg-9">
          <div>
            <div class="mb-5">
              @if ($blogs->youtube_link != null)
                <div class="d-fleex justify-content-center">
                  {!! $blogs->youtube_link !!}
                </div>
              @else
              <div class="center">
                <img src="{{ asset('uploads/blogs/' . $blogs->thumbnail)}}" class="img-fluid rounded-5" alt="">
                {{-- <div class="bg-light" style="width:100%;height:470px;"></div> --}}
              </div>
              @endif
            </div>
    
            <h1 class="mb-5">{{ $blogs->title }}</h1>
            <div class="hstack gap-3 mb-5">
              <div class="rounded-circle bg-white text-center">
                <i class="fa-regular fa-user"></i>
              </div>
              <span>By {{ $blogs->author }}</span>
              <div class="vr"></div>
              <span>{{ date('F j, Y', strtotime($blogs->created_at)) }}</span>
            </div>
  
            <p>
              {!! $blogs->description !!}
            </p>
  
            {{-- <div class="mb-3">
              <span class="fs-5">Share This:</span>
            </div>
            <div class="hstack gap-3">
              <div class="soc-border-bg text-white text-center">
                <i class="fa-brands fa-facebook-f"></i>
              </div>
              <div class="soc-border-bg text-white text-center">
                <i class="fa-brands fa-twitter"></i>
              </div>
              <div class="soc-border-bg text-white text-center">
                <i class="fa-brands fa-instagram"></i>
              </div>
              <div class="soc-border-bg text-white text-center">
                <i class="fa-brands fa-pinterest-p"></i>
              </div>
            </div> --}}
  
          </div>
        </div>
  
        <div class="col-12 col-sm-12 col-md-12 col-lg-3">
          <div>
            <div class="rounded-4 bg-white p-4 mb-5">
              <div class="input-group border rounded-5 p-1">
                <input type="text" class="form-control border-0 rounded-start-5 shadow-none" placeholder="Search .." aria-label="Username" aria-describedby="basic-addon1">
                <button class="input-group-text bg-white border-0" id="basic-addon1">
                  <i class="fa-solid fa-magnifying-glass fa-flip-horizontal"></i>
                </button>
              </div>
            </div>
  
            {{-- <div class="rounded-4 bg-white p-4 mb-5">
              <div class="mb-3">
                <span class="fw-bold fs-5">Categories</span>
              </div>
              <div class="vstack gap-3">
                <a href="" class="text-black text-decoration-none"><i class="fa-solid fa-caret-right text-black"></i> Clothing</a>
                <a href="" class="text-black text-decoration-none"><i class="fa-solid fa-caret-right text-black"></i> Trends</a>
                <a href="" class="text-black text-decoration-none"><i class="fa-solid fa-caret-right text-black"></i> Awards</a>
                <a href="" class="text-black text-decoration-none"><i class="fa-solid fa-caret-right text-black"></i> Skincare</a>
                <a href="" class="text-black text-decoration-none"><i class="fa-solid fa-caret-right text-black"></i> Events</a>
              </div>
            </div> --}}
  
            {{-- <div class="rounded-4 bg-white p-4">
              <div class="mb-3">
                <span class="fw-bold fs-5">Recent Post</span>
              </div>
              <div class="row gx-0">
                <div class="col-4 col-sm-4 col-md-4 col-lg-5">
                  <img src="{{ asset('resources/_web resources/sample-b3.jpg') }}" class="img-recent-blog" alt="">
                </div>
  
                <div class="col-6 col-sm-6 col-md-6 col-lg-7 d-flex align-items-center">
                  <span class="fw-bold">Best Fashion For Work</span>
                </div>
              </div>
            </div> --}}
  
          </div>
        </div>
  
      </div>
    </div>
  </div>
</div>
@endsection