@extends('frontend.layouts.app')

@section('seo')
    <title>Blogs | eg APPAREL</title>
    <meta property="og:locale" content="en_US" />
    <meta property="og:url" content="" />
    <meta property="og:type" content="website" />
    <meta property="og:title" content="Blogs | eg APPAREL" />
    <meta property="og:description" content="" />
    <meta property="og:site_name" content="Blogs | eg APPAREL" />
    <meta property="og:image" content="{{ asset('resources/web_thumb.jpg') }}" />
    <meta property="og:thumbnail" content="{{ asset('resources/web_thumb.jpg') }}" />
@endsection

@section('content')
    {{-- BANNER --}}
    <section>
        <div class="position-relative">
            <img src="{{ asset('resources/_Banners/Banner2.jpg') }}" class="img-fluid" alt="">
            <div class="container">
                <div class="position-absolute translate-middle top-50 section-banner">
                    <h1 class="fw-bold banner-h1">Blogs</h1>
                    <h2 class="fs-4">Home / Blogs</h2>
                </div>
            </div>
        </div>
    </section>

    {{-- CONTENT --}}
    <section>
        <div class="container-fluid bg-alt py-5">
            <div class="container pb-5">
                <div class="row d-flex justify-content-center w-100">
                    <div class="col-12 col-sm-12 col-md-12 col-lg-5 d-flex justify-content-center">
                        <div class="input-group">
                            <input type="text" class="form-control form-control-lg bg-white border-end-0 rounded-start"
                                placeholder="Search .." aria-label="Username" aria-describedby="basic-addon1">
                            <span class="input-group-text bg-white border-start-0 rounded-end" id="basic-addon1">
                                <i class="fa-solid fa-magnifying-glass"></i>
                            </span>
                        </div>
                    </div>
                </div>
                <div class="row g-5 pb-5">

                    @foreach ($blogs as $items)
                        <div class="col-12 col-sm-12 col-md-12 col-lg-4 d-flex justify-content-center py-5">
                            <div class="w-100">
                                <div class="position-relative">
                                    <center>
                                        <img src="{{ asset('uploads/blogs/' . $items->thumbnail) }}"
                                            class="img-main-blogs rounded-5" alt="">
                                    </center>
                                    <div class="position-absolute translate-middle blog-text w-100">
                                        <div class="row">
                                            <div class="col-12 col-sm-12 col-md-12 col-lg-8">
                                                <div class="rounded-5 px-4 py-4 bg-white shadow-sm">
                                                    <div class="text-center mb-2">
                                                        <h1 class="small-blog-title">{!! Str::limit($items->title, 30, '...') !!}</h1>
                                                        <span>{!! Str::limit($items->author, 30, '...') !!} /
                                                            {{ date('F j, Y', strtotime($items->created_at)) }}</span>
                                                    </div>
                                                    <div class="d-flex justify-content-center">
                                                        <div class="mb-2">
                                                            <p class="justify">
                                                                {!! Str::limit($items->description, 100, '...') !!}
                                                            </p>
                                                        </div>
                                                    </div>
                                                    <center>
                                                        <a href="{{ url('blog-single/' . $items->title) }}"
                                                            class="text-black fw-bold">Read More</a>
                                                    </center>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach

                </div>

                <div class="d-flex justify-content-center">
                    @if ($blogs->hasPages())
                        <ul class="pagination pagination">

                            @if ($blogs->currentPage() == 1)
                                <a class="page-link py-1 px-3" href="#" aria-label="Previous">
                                    <i class="fa-solid fa-chevron-left"></i>
                                </a>
                            @else
                                <li class="page-item"><a class="page-link py-1 px-3" href="{{ $blogs->previousPageUrl() }}"
                                        rel="prev"><i class="fa-solid fa-chevron-left"></i></a></li>
                            @endif

                            @if ($blogs->currentPage() > 3)
                                <li class="page-item hidden-xs"><a class="page-link py-1 px-3"
                                        href="{{ $blogs->url(1) }}">1</a></li>
                            @endif
                            @if ($blogs->currentPage() > 4)
                                <li><span>...</span></li>
                            @endif
                            @foreach (range(1, $blogs->lastPage()) as $i)
                                @if ($i >= $blogs->currentPage() - 2 && $i <= $blogs->currentPage() + 2)
                                    @if ($i == $blogs->currentPage())
                                        <li class="page-item"><span
                                                class="page-link py-1 px-3 active">{{ $i }}</span></li>
                                    @else
                                        <li><a class="page-link py-1 px-3"
                                                href="{{ $blogs->url($i) }}">{{ $i }}</a></li>
                                    @endif
                                @endif
                            @endforeach
                            @if ($blogs->currentPage() < $blogs->lastPage() - 3)
                                <li class="page-link py-1 px-3"><span>...</span></li>
                            @endif
                            @if ($blogs->currentPage() < $blogs->lastPage() - 2)
                                <li class="page-item hidden-xs"><a class="page-link py-1 px-3"
                                        href="{{ $blogs->url($blogs->lastPage()) }}">{{ $blogs->lastPage() }}</a></li>
                            @endif

                            @if ($blogs->hasMorePages())
                                <li class="page-item"><a class="page-link py-1 px-3" href="{{ $blogs->previousPageUrl() }}"
                                        rel="prev"><i class="fa-solid fa-chevron-right"></i></a></li>
                            @else
                                <a class="page-link py-1 px-3" href="#" aria-label="Next">
                                    <i class="fa-solid fa-chevron-right"></i>
                                </a>
                            @endif
                        </ul>
                    @endif
                </div>

            </div>
        </div>
    </section>
@endsection
