@extends('frontend.layouts.app')

@section('seo')
<title>My Cart | eg APPAREL</title>
<meta property="og:locale"          content="en_US" />
<meta property="og:url"             content="" />
<meta property="og:type"            content="website" />
<meta property="og:title"           content="My Cart | eg APPAREL" />
<meta property="og:description"     content="" />
<meta property="og:site_name"       content="My Cart | eg APPAREL" />
<meta property="og:image"           content="{{ asset('resources/web_thumb.jpg') }}" />
<meta property="og:thumbnail"       content="{{ asset('resources/web_thumb.jpg') }}" />
@endsection

@section('content')
<div class="container py-5">
  <div class="text-center mb-5">
    <h1>My Cart</h1>
  </div>

  @if(session('success'))
  <div class="col-12">
      <div class="alert alert-success my-1">
          {{ session('success') }}
      </div>
  </div>
  @endif
  <form method="GET" action="{{ url('cart/create') }}">
  <div class="row g-5">
    <div class="col-12 col-sm-12 col-md-12 col-lg-9">

      <div class="d-lg-block d-none d-sm-none">
        <table class="table mb-5">
          <thead>
            <tr>
              <th scope="col" colspan="2">PRODUCT DETAILS</th>
              <th scope="col" class="text-center">UNIT PRICE</th>
              <th scope="col" class="text-center">QUANTITY</th>
              <th scope="col" class="text-center">AMOUNT</th>
              <th scope="col"></th>
            </tr>
          </thead>

          @php
          $cart_total = 0;
          $discounted = 0;
          $subtotal = 0;
          @endphp

          @if (session('cart'))
          @foreach (session('cart') as $cart)
          @php
          $cart_total += $cart['quantity'] * $cart['price'];
          @endphp
          @endforeach
          @endif

          <tbody>
            
            @if (session('cart'))
            @foreach (session('cart') as $cart)
            <tr>
              <td colspan="2">
                <div class="row gx-0">
                  <div class="col-12 col-sm-12 col-md-12 col-lg-6 text-center">
                    @if ($cart['shop'] == 'trends')
                    <img src="{{ asset('uploads/trends/' . $cart['image'])}}" height="100" width="100" class="img-fluid" alt="">
                    @elseif ($cart['shop'] == 'skins')
                    <img src="{{ asset('uploads/skins/' . $cart['image'])}}" width="90" class="img-fluid" alt="">
                    @endif
                  </div>
                  <div class="col-12 col-sm-12 col-md-12 col-lg-6">
                    @if ($cart['shop'] == 'skins')
                    <a href="{{ url('product-view-skin/' . $cart['name']) }}" class="text-decoration-none text-black">
                      <span class="fw-bold text-uppercase"> {{ $cart['name'] }}</span><br>
                    </a>
                  @else
                    <a href="{{ url('product-view-trends/' . $cart['name']) }}" class="text-decoration-none text-black">
                      <span class="fw-bold text-uppercase"> {{ $cart['name'] }}</span><br>
                    </a>
                  @endif
                    @if ($cart['shop'] == 'trends')
                    <span>Color: {{ $cart['color'] }}</span><br>
                    <span>Size: {{ $cart['size'] }} | Stocks: {{ $cart['stocks'] }}</span>
                    @elseif ($cart['shop'] == 'skins')
                    <span>Skin Care | Stocks: {{ $cart['stocks'] }}</span>
                    @endif
                  </div>
                </div>
              </td>
              <td class="text-center">
                <span class="color-nude">P {{ number_format($cart['price'], 2) }}</span>
              </td>
              <td>
                <div class="d-flex justify-content-center">
                  <div class="d-flex justify-content-center">
                    @if ($cart['quantity'] > 0)
                    <a href="{{ url('cart/' . $cart['id']) }}?minus=1">
                      <button type="button" id="sub" class="p-2 border-0 bg-white">-</button>
                    </a>
                    @endif
                    &nbsp; <div class="pt-2">{{ $cart['quantity'] }}</div> &nbsp;
                    @if ($cart['shop'] == 'trends')
                      @if ($cart['quantity'])
                        <a href="{{ url('cart/' . $cart['id']) }}">
                          <button type="button" id="plus" class=" p-2 border-0 bg-white">+</button>
                        </a>
                      @endif
                    @endif

                    @if ($cart['shop'] == 'skins')
                      @if ($cart['quantity'] < $cart['stocks'])
                        <a href="{{ url('cart/' . $cart['id']) }}">
                          <button type="button" id="plus" class=" p-2 border-0 bg-white">+</button>
                        </a>
                      @endif
                    @endif
                  </div>
                </div>
              </td>
              <td class="text-center">
                <span class="color-nude">P {{ number_format($cart['quantity'] * $cart['price'], 2) }}</span>
              </td>
              <td class="text-center pt-3">
                <a href="{{ url('cart/' . $cart['id']) }}?clear=1">
                  <i class="fa-solid fa-trash-can text-black"></i>
                </a> 
              </td>
            </tr>
            @endforeach
            @endif
          </tbody>
        </table>

        @if (!session('cart'))
        <div class="text-center">
          <span class="fs-4 fw-bold">Your Cart is Empty!</span>
        </div>

        @endif
      </div>

      <div class="d-lg-none d-block d-sm-block">
        <div>
          <span class="fs-6 fw-bold">PRODUCT DETAILS</span>
        </div>

        @if (session('cart'))
        @foreach (session('cart') as $cart)
        <div class="row mt-3">
          <div class="col-12 col-sm-12 col-md-12 col-lg-3">
            <div class="row gx-0">
              <div class="col-6 col-sm-6 col-md-6 col-lg-4 d-flex justify-content-center">
                @if ($cart['shop'] == 'trends')
                <img src="{{ asset('uploads/trends/' . $cart['image'])}}" height="100" width="100" class="img-fluid" alt="">
                @elseif ($cart['shop'] == 'skins')
                <img src="{{ asset('uploads/skins/' . $cart['image'])}}" width="90" class="img-fluid" alt="">
                @endif
              </div>
              <div class="col-6 col-sm-6 col-md-6 col-lg-8">
                <div class="mb-2">
                  @if ($cart['shop'] == 'skins')
                    <a href="{{ url('product-view-skin/' . $cart['name']) }}" class="text-decoration-none">
                      <span class="fw-bold text-uppercase"> {{ $cart['name'] }}</span><br>
                    </a>
                  @else
                    <a href="{{ url('product-view-trends/' . $cart['name']) }}" class="text-decoration-none">
                      <span class="fw-bold text-uppercase"> {{ $cart['name'] }}</span><br>
                    </a>
                  @endif
                  @if ($cart['shop'] == 'trends')
                  <span>Color: {{ $cart['color'] }} | </span><br>
                  <span>Size: {{ $cart['size'] }} | Stocks: {{ $cart['stocks'] }}</span>
                  @elseif ($cart['shop'] == 'skins')
                  <span>Skin Care | {{ $cart['stocks'] }}</span>
                  @endif
                </div>
                <div class="d-flex justify-content-center">
                  @if ($cart['quantity'] > 0)
                  <a href="{{ url('cart/' . $cart['id']) }}?minus=1">
                    <button type="button" id="sub" class="p-2 border-0 bg-white">-</button>
                  </a>
                  @endif
                  &nbsp; <div class="pt-2">{{ $cart['quantity'] }}</div> &nbsp;

                  @if ($cart['shop'] == 'trends')
                    @if ($cart['quantity'])
                      <a href="{{ url('cart/' . $cart['id']) }}">
                        <button type="button" id="plus" class=" p-2 border-0 bg-white">+</button>
                      </a>
                    @endif
                  @else
                    @if ($cart['quantity'] < $cart['stocks'])
                      <a href="{{ url('cart/' . $cart['id']) }}">
                        <button type="button" id="plus" class=" p-2 border-0 bg-white">+</button>
                      </a>
                    @endif
                  @endif

                </div>
              </div>
            </div>
      
            <div class="row">
              <div class="col-4 col-sm-4 col-md-4 col-lg-4">
                <div class="text-center">
                  <span class="fs-6 fw-bold">UNIT PRICE</span>
                </div>
                <div class="text-center">
                  <span class="color-nude">P {{ number_format($cart['price'], 2) }}</span>
                </div>
              </div>
              <div class="col-4 col-sm-4 col-md-4 col-lg-4">
                <div class="text-center">
                  <span class="fs-6 fw-bold">AMOUNT</span>
                </div>
                <div class="text-center">
                  <span class="color-nude">P {{ number_format($cart['quantity'] * $cart['price'], 2) }}</span>
                </div>
              </div>
              <div class="col-4 col-sm-4 col-md-4 col-lg-4 d-flex align-items-center justify-content-center">
                <div>
                  <a href="{{ url('cart/' . $cart['id']) }}?clear=1">
                    <i class="fa-solid fa-trash-can text-black"></i>
                  </a> 
                </div>
              </div>
            </div>
            <hr>
          </div>
        </div>
        @endforeach
        @endif

        @if (!session('cart'))
        <div class="text-center">
          <span class="fs-4 fw-bold">Your Cart is Empty!</span>
        </div>
        @endif
      </div>

      <div>
        <div class="row">
          <div class="col-12 col-md-4 col-xl-4">
            <label class="form-label">Discount Code:</label>
            <input type="text" name="promo_code" class="form-control rounded-0" value="{{ old('promo_code') }}">
            @error('promo_code')
            <span class="text-danger">{{ $message }}</span>
            @enderror
          </div>
        </div>
      </div>
    </div>

    <div class="col-12 col-sm-12 col-md-12 col-lg-3">
      <div class="border border-bottom-0 p-4">
        <span class="fs-5 fw-bold">TOTAL</span>
      </div>
      <div class="border p-4">

        <div class="mb-2">
          <span>Service Type</span>
        </div>
        <div class="form-check mb-5">
          <input class="form-check-input" type="radio" name="service_type" value="Delivery" id="flexRadioDefault1" required>
          <label class="form-check-label" for="flexRadioDefault1">
            Delivery
          </label>
        </div>

        <hr>

        {{-- <div class="vstack gap-2 mb-5">
          <div class="row">
            <div class="col-6 col-sm-6 col-md-6 col-lg-6">
              <span>Subtotal:</span>
            </div>
            <div class="col-6 col-sm-6 col-md-6 col-lg-6 text-end">
              <span>P {{ number_format($cart_total, 2) }}</span>
            </div>
          </div>
          <div class="row">
            <div class="col-6 col-sm-6 col-md-6 col-lg-6">
              <span>Discount:</span>
            </div>
            <div class="col-6 col-sm-6 col-md-6 col-lg-6 text-end">
              <span>-$20.00</span>
            </div>
          </div>
          <div class="row">
            <div class="col-6 col-sm-6 col-md-6 col-lg-6">
              <span>Shipping:</span>
            </div>
            <div class="col-6 col-sm-6 col-md-6 col-lg-6 text-end">
              <span>$10.00</span>
            </div>
          </div>
        </div>

        <hr> --}}

        <div class="vstack gap-2 mb-5">
          <div class="row">
            <div class="col-6 col-sm-6 col-md-6 col-lg-6">
              <span class="fw-bold">Sub Total:</span>
            </div>
            <div class="col-6 col-sm-6 col-md-6 col-lg-6 text-end">
              <span class="fw-bold">P {{ number_format($cart_total, 2) }}</span>
            </div>
          </div>
        </div>

        <div class="d-flex justify-content-center">
          <a href="{{ url('checkout') }}">
            <button class="btn btn-primary shadow-none bg-transparent w-100 rounded-circle text-black py-3 px-4 align-bottom button-alt type2-alt">
              <span class="btn-text-alt">Proceed to Checkout <i class="fa-solid fa-arrow-right-long"></i></span>
            </button>
          </a>
        </div>

      </div>
    </div>
  </div>

  </form>

</div>
@endsection

@section('css')
<style>
  label{
    font-family: 'Palanquin', sans-serif;
  }
</style>
@endsection