@extends('frontend.layouts.app')

@section('title')
@endsection

@section('seo')
    <title>Contact Us | eg APPAREL</title>
    <meta property="og:locale" content="en_US" />
    <meta property="og:url" content="" />
    <meta property="og:type" content="website" />
    <meta property="og:title" content="Contact Us | eg APPAREL" />
    <meta property="og:description" content="" />
    <meta property="og:site_name" content="Contact Us | eg APPAREL" />
    <meta property="og:image" content="{{ asset('resources/web_thumb.jpg') }}" />
    <meta property="og:thumbnail" content="{{ asset('resources/web_thumb.jpg') }}" />
@endsection

@section('content')
    {{-- BANNER --}}
    <section>
        <div class="position-relative">
            <img src="{{ asset('resources/_Banners/Banner2.jpg') }}" class="img-fluid" alt="">
            <div class="container">
                <div class="position-absolute translate-middle top-50 section-banner">
                    <h1 class="fw-bold banner-h1">Contact Us</h1>
                    <h2 class="fs-4">Home / Contact Us</h2>
                </div>
            </div>
        </div>
    </section>

    <section>
        <div class="overflow-hidden px-0 pt-5">
            <ul class="nav nav-tabs justify-content-center border-0 mb-5" id="myTab" role="tablist">
                <li class="nav-item" role="presentation">
                    <button class="contact-link px-4 active" id="home-tab" data-bs-toggle="tab"
                        data-bs-target="#home-tab-pane" type="button" role="tab" aria-controls="home-tab-pane"
                        aria-selected="true">
                        <h1 class="fs-2 text-decoration-underline">Bocaue</h1>
                    </button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="contact-link px-4" id="profile-tab" data-bs-toggle="tab"
                        data-bs-target="#profile-tab-pane" type="button" role="tab" aria-controls="profile-tab-pane"
                        aria-selected="false">
                        <h1 class="fs-2 text-decoration-underline">Guiguinto</h1>
                    </button>
                </li>
            </ul>
            <div class="tab-content" id="myTabContent">
                <div class="tab-pane fade show active mb-5" id="home-tab-pane" role="tabpanel" aria-labelledby="home-tab"
                    tabindex="0">

                    <div class="container">
                        <div class="d-flex justify-content-center mb-5">
                            <div class="row w-100 g-5">
                                <div class="col-12 col-sm-12 col-md-12 col-lg-4 text-center">
                                    <h1 class="fs-3">+1 800 603 6035</h1>
                                    <span>Phone number</span>
                                </div>
                                <div class="col-12 col-sm-12 col-md-12 col-lg-4 text-center">
                                    <h1 class="fs-3">We Are Here</h1>
                                    <div class="mb-3">
                                        <span>189 JP Rizal St, Bocaue, Bulacan</span>
                                    </div>
                                    <a href="https://www.google.com/search?rlz=1C1CHBF_enPH1012PH1013&tbm=lcl&sxsrf=APwXEdcRIKt_GO4GQ6LUvYF79Rw3EhVlrA%3A1686796332856&q=EG%20Trends%20Apparel&rflfq=1&num=20&stick=H4sIAAAAAAAAAB2Qu00DQRiE5QBECocILroS_vcjJECkBDRgwSEHFrbOHVEBdVEFs452NZr9Zmbvbucpmbnam6nVwirD58chBW7RJsGUYizzJFlZptKZykFikvPEDocIs4dJW3nCCUeXh1BFKKVpG6BOlWRSBCCBXs4jStxaKURgY_ImhUrmHdCKSrSru0ctTxiZtFU1JNmroUZJukFhVUc0uQxCaWlKeJelVchVLcIUciuVjEYfHgRSGYOoGV3QUkrnB8Z-58ZRFaBXjSxOtCLAcXUE5LWBwwALdZATInVkcWqopWIy3mCn2jxp4EtQVMFsZdbU393ub_f0tp7Ox3XZHy-n5bLut4_D8nXafm7uX16X9239_rwsz-fzfluP_yPT-R-3AQAA&ved=2ahUKEwiftemBnsT_AhUZbWwGHRBUBUEQjHJ6BAhkEAU&rldimm=7111895910934648765#rlfi=hd:;si:7111895910934648765,l,ChFFRyBUcmVuZHMgQXBwYXJlbFoTIhFlZyB0cmVuZHMgYXBwYXJlbJIBDmNsb3RoaW5nX3N0b3JlqgE6EAEyHxABIhvauKtVjN5yAOCKIx7cyoAXocTDTuHSH-8YkYAyFRACIhFlZyB0cmVuZHMgYXBwYXJlbA;mv:[[14.832927499999998,121.01223689999999],[14.779999599999998,120.8536616]]"
                                        class="color-nude text-decoration-none">GET DIRECTION</a>
                                </div>
                                <div class="col-12 col-sm-12 col-md-12 col-lg-4 text-center">
                                    <h1 class="fs-3">egtrendsapparel@gmail.com</h1>
                                    <span>Email address</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div>
                        <div class="mapouter">
                            <div class="gmap_canvas"><iframe class="gmap_iframe" width="100%" frameborder="0"
                                    scrolling="no" marginheight="0" marginwidth="0"
                                    src="https://maps.google.com/maps?width=802&amp;height=480&amp;hl=en&amp;q=EG Trends Apparel - Bocaue  189 JP Rizal St, Bocaue, Bulacan&amp;t=&amp;z=14&amp;ie=UTF8&amp;iwloc=B&amp;output=embed"></iframe><a
                                    href="https://embed-googlemap.com">embed-googlemap.com</a></div>
                            <style>
                                .mapouter {
                                    position: relative;
                                    text-align: right;
                                    width: 100%;
                                    height: 480px;
                                }

                                .gmap_canvas {
                                    overflow: hidden;
                                    background: none !important;
                                    width: 100%;
                                    height: 480px;
                                }

                                .gmap_iframe {
                                    height: 480px !important;
                                }
                            </style>
                        </div>
                    </div>
                </div>

                <div class="tab-pane fade mb-5" id="profile-tab-pane" role="tabpanel" aria-labelledby="profile-tab"
                    tabindex="0">

                    <div class="container">
                        <div class="d-flex justify-content-center mb-5">
                            <div class="row w-100 g-5">
                                <div class="col-12 col-sm-12 col-md-12 col-lg-4 text-center">
                                    <h1 class="fs-3">+1 800 603 6035</h1>
                                    <span>Phone number</span>
                                </div>
                                <div class="col-12 col-sm-12 col-md-12 col-lg-4 text-center">
                                    <h1 class="fs-3">We Are Here</h1>
                                    <div class="mb-3">
                                        <span>RVHH+37R, Guiguinto, Bulacan</span>
                                    </div>
                                    <a href="https://www.google.com/search?rlz=1C1CHBF_enPH1012PH1013&tbm=lcl&sxsrf=APwXEdcRIKt_GO4GQ6LUvYF79Rw3EhVlrA%3A1686796332856&q=EG%20Trends%20Apparel&rflfq=1&num=20&stick=H4sIAAAAAAAAAB2Qu00DQRiE5QBECocILroS_vcjJECkBDRgwSEHFrbOHVEBdVEFs452NZr9Zmbvbucpmbnam6nVwirD58chBW7RJsGUYizzJFlZptKZykFikvPEDocIs4dJW3nCCUeXh1BFKKVpG6BOlWRSBCCBXs4jStxaKURgY_ImhUrmHdCKSrSru0ctTxiZtFU1JNmroUZJukFhVUc0uQxCaWlKeJelVchVLcIUciuVjEYfHgRSGYOoGV3QUkrnB8Z-58ZRFaBXjSxOtCLAcXUE5LWBwwALdZATInVkcWqopWIy3mCn2jxp4EtQVMFsZdbU393ub_f0tp7Ox3XZHy-n5bLut4_D8nXafm7uX16X9239_rwsz-fzfluP_yPT-R-3AQAA&ved=2ahUKEwiftemBnsT_AhUZbWwGHRBUBUEQjHJ6BAhkEAU&rldimm=7111895910934648765#rlfi=hd:;si:9779856208663074394,l,ChFFRyBUcmVuZHMgQXBwYXJlbFoTIhFlZyB0cmVuZHMgYXBwYXJlbJIBDmNsb3RoaW5nX3N0b3JlqgE6EAEyHxABIhvauKtVjN5yAOCKIx7cyoAXocTDTuHSH-8YkYAyFRACIhFlZyB0cmVuZHMgYXBwYXJlbA;mv:[[14.832927499999998,121.01223689999999],[14.779999599999998,120.8536616]]"
                                        class="color-nude text-decoration-none">GET DIRECTION</a>
                                </div>
                                <div class="col-12 col-sm-12 col-md-12 col-lg-4 text-center">
                                    <h1 class="fs-3">egtrendsapparel@gmail.com</h1>
                                    <span>Email address</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="container-fluid">
                        <div class="mapouter">
                            <div class="gmap_canvas"><iframe class="gmap_iframe" width="100%" frameborder="0"
                                    scrolling="no" marginheight="0" marginwidth="0"
                                    src="https://maps.google.com/maps?width=802&amp;height=480&amp;hl=en&amp;q=EG Trends Apparel Guiguinto&amp;t=&amp;z=14&amp;ie=UTF8&amp;iwloc=B&amp;output=embed"></iframe><a
                                    href="https://embed-googlemap.com">embed-googlemap.com</a></div>
                            <style>
                                .mapouter {
                                    position: relative;
                                    text-align: right;
                                    width: 100%;
                                    height: 480px;
                                }

                                .gmap_canvas {
                                    overflow: hidden;
                                    background: none !important;
                                    width: 100%;
                                    height: 480px;
                                }

                                .gmap_iframe {
                                    height: 480px !important;
                                }
                            </style>
                        </div>
                    </div>
                </div>

            </div>
        </div>
        </div>
    </section>

    <section>
        <div class="container">
            <div class="row d-flex justify-content-center w-100">
                <div class="col-12 col-sm-12 col-md-12 col-lg-8 d-flex justify-content-center">
                    <div class="w-100">
                        <div class="text-center mb-5">
                            <h1>We'd Love to Hear From You</h1>
                            <span>Feel free to send us any questions you may have. We are happy to answer them.</span>
                        </div>

                        <form id="myForm" action="{{ url('contact') }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            <div class="mb-3">
                                <label for="name" class="form-label">Your Name*</label>
                                <input type="text" class="form-control rounded-0 form-black" id="name"
                                    name="name">

                                @error('name')
                                    <span class="text-danger">
                                        {{ $message }}
                                    </span>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="name" class="form-label">Your Email*</label>
                                <input type="text" class="form-control rounded-0 form-black" id="email"
                                    name="email">

                                @error('email')
                                    <span class="text-danger">
                                        {{ $message }}
                                    </span>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="name" class="form-label">Phone</label>
                                <input type="text" class="form-control rounded-0 form-black" id="phone"
                                    name="phone">

                                @error('phone')
                                    <span class="text-danger">
                                        {{ $message }}
                                    </span>
                                @enderror
                            </div>

                            <div class="mb-5">
                                <label for="name" class="form-label">Message</label>
                                <textarea type="text" rows="5" class="form-control rounded-0 form-black" id="message" name="message"></textarea>

                                @error('message')
                                    <span class="text-danger">
                                        {{ $message }}
                                    </span>
                                @enderror
                            </div>

                            <div class="center">
                                <button
                                    class="btn btn-primary bg-transparent rounded-circle text-black py-3 px-2 align-bottom button-alt type1-alt">
                                    <span class="btn-text">Send Message</span>
                                </button>
                            </div>
                        </form>

                        <div class="modal fade" id="successModal" tabindex="-1" aria-labelledby="successModalLabel"
                            aria-hidden="true">
                            <div class="modal-dialog modal-dialog-centered">
                                <div class="modal-content">
                                    <div class="modal-header d-flex justify-content-end border-bottom-0">
                                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                                            aria-label="Close"></button>
                                    </div>
                                    <div class="text-center">
                                        <i
                                            class="fas fa-check-circle fa-3x animate__animated animate__bounceIn text-success"></i>
                                        <h5 class="mt-3 animate__animated animate__fadeInUp">Your message has been sent
                                            successfully.</h5>
                                    </div>
                                    <div class="modal-footer border-top-0">
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection

@section('js')
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"
        integrity="sha512-894YE6QWD5I59HgZOGReFYm4dnWc1Qt5NtvYSaNcOP+u1T9qYdvdihz0PPSiiqn/+/3e7Jo4EaG7TubfWGUrMQ=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script>
        $(document).ready(function() {
            $('#myForm').submit(function(e) {
                e.preventDefault();
                $.ajax({
                    url: $(this).attr('action'),
                    type: $(this).attr('method'),
                    data: new FormData(this),
                    processData: false,
                    contentType: false,
                    success: function(response) {
                        $('#successModal').modal('show');
                        setTimeout(function() {
                            $('#successModal').modal('hide');
                            $('.modal-backdrop').remove();
                            $('.animate__animated').removeClass(
                                'animate__animated animate__zoomIn');
                        }, 3000);
                    }
                });
            });
        });
    </script>
@endsection
