@extends('frontend.layouts.app')

@section('title')
@endsection

@section('seo')
    <title>Home | eg APPAREL</title>
    <meta property="og:locale" content="en_US" />
    <meta property="og:url" content="" />
    <meta property="og:type" content="website" />
    <meta property="og:title" content="Home | eg APPAREL" />
    <meta property="og:description" content="" />
    <meta property="og:site_name" content="Home | eg APPAREL" />
    <meta property="og:image" content="{{ asset('resources/web_thumb.jpg') }}" />
    <meta property="og:thumbnail" content="{{ asset('resources/web_thumb.jpg') }}" />
@endsection

@section('content')
    <section class="overflow-hidden">
        <div class="container-fluid px-0">
            <div id="carouselExampleIndicators" class="carousel slide" data-bs-ride="true">
                <div class="carousel-indicators">
                    @foreach ($banners as $key => $items)
                        <button type="button" data-bs-target="#carouselExampleIndicators"
                            data-bs-slide-to="{{ $key }}" {{ $key == 0 ? 'class=active' : '' }}
                            aria-label="Slide {{ $key + 1 }}"></button>
                    @endforeach
                </div>

                <div class="carousel-inner">
                    @foreach ($banners as $key => $items)
                        <div class="carousel-item {{ $key == 0 ? 'active' : '' }}">
                            <img src="{{ asset('banners/' . $items->image) }}" class="w-100 h-auto" alt="...">
                        </div>
                    @endforeach
                </div>

                <button class="carousel-control-prev opacity-0" type="button" data-bs-target="#carouselExampleIndicators"
                    data-bs-slide="prev">
                    <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                    <span class="visually-hidden">Previous</span>
                </button>
                <button class="carousel-control-next opacity-0" type="button" data-bs-target="#carouselExampleIndicators"
                    data-bs-slide="next">
                    <span class="carousel-control-next-icon" aria-hidden="true"></span>
                    <span class="visually-hidden">Next</span>
                </button>
            </div>
        </div>
    </section>

    {{-- OUR PRODUCTS --}}
    <section class="overflow-hidden">
        <div class="container bg-white py-5 my-5">
            <div class="d-flex justify-content-center">
                <div class="d-lg-block d-none d-sm-none">
                    <div class="row gy-5">
                        <div class="col-6 col-sm-12 col-md-12 col-lg-6">
                            <div class="position-relative">
                                <img src="{{ asset('resources/trends-bg.jpg') }}"
                                    class="img-trends position-relative parent-relative rounded-5" alt="">
                                <div class="position-absolute text-white label-left p-5 w-100 d">
                                    {{-- <h2 class="fw-bold text-start">eg Trends Apparel</h2> --}}
                                    <div class="mt-5 pt-5">
                                        <div class="mt-5 pt-5">
                                            <div class="mt-5 pt-5">
                                                <div class="d-flex justify-content-center">
                                                    <a href="{{ url('shop-trends') }}">
                                                        <button
                                                            class="btn btn-primary shadow-none btn-margin rounded-circle p-3 align-bottom button-dark">
                                                            <span class="btn-txt">See Collection</span>
                                                        </button>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div
                                    class="position-absolute translate-middle text-white border rounded-5 bg-transparent border-left">
                                </div>

                            </div>
                        </div>
                        <div class="col-6 col-sm-12 col-md-12 col-lg-6">
                            <div class="text-center p-3 mb-5">
                                <h1 class="section-label">Our Products</h1>
                            </div>

                            <div class="position-relative">
                                <img src="{{ asset('resources/_web resources/eg-2.png') }}"
                                    class="img-fluid position-relative parent-relative" alt="">
                                <div class="position-absolute text-white label-left p-5 w-100">
                                    <h2 class="fw-bold text-start">eg Skin Essentials</h2>
                                    <div class="mt-5 pt-5">
                                        <div class="mt-5 pt-5">
                                            <div class="mt-5 pt-5">
                                                <div class="d-flex justify-content-center">
                                                    <a href="{{ url('shop-skin') }}">
                                                        <button
                                                            class="btn btn-primary shadow-none btn-margin bg-transparent rounded-circle text-white p-3 align-bottom button type1">
                                                            <span class="btn-txt">See Collection</span>
                                                        </button>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div
                                    class="position-absolute translate-middle text-white border rounded-5 bg-transparent border-right">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="d-lg-none d-block d-sm-block">
                    <div class="row gy-5">
                        <div class="col-sm-12 col-md-12 d-flex justify-content-center">
                            <div class="position-relative">
                                <img src="{{ asset('resources/trends-bg.jpg') }}"
                                    class="img-trends position-relative parent-relative rounded-4" alt="">
                                <div class="position-absolute text-white translate-middle w-100 mob-apparel">
                                    <h2 class="fw-bold text-start">eg Trends Apparel</h2>
                                </div>
                                <div class="position-absolute translate-middle start-50 bottom-0" style="z-index: 2">
                                    <div class="d-flex justify-content-center">
                                        <a href="{{ url('shop-trends') }}">
                                            <button
                                                class="btn btn-primary shadow-none btn-margin rounded-circle p-3 align-bottom button-dark">
                                                <span class="btn-txt">See Collection</span>
                                            </button>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-12 d-flex justify-content-center">
                            <div class="position-relative">
                                <img src="{{ asset('resources/_web resources/eg-2.png') }}" class="img-fluid"
                                    alt="">
                                <div class="position-absolute text-white translate-middle w-100 mob-apparel">
                                    <h2 class="fw-bold text-start">eg Skin Essentials</h2>
                                </div>
                                <div class="position-absolute translate-middle start-50 bottom-0">
                                    <div class="d-flex justify-content-center">
                                        <a href="{{ url('shop-skin') }}">
                                            <button
                                                class="btn btn-primary bg-transparent mt-5 rounded-circle text-white p-3 align-bottom button type1">
                                                <span class="btn-txt">See Collection</span>
                                            </button>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    {{-- TRENDS --}}
    <section class="overflow-hidden">
        <div class="bg-alt py-5 my-5 container-fluid">
            <div class="container">
                <div class="d-flex justify-content-between align-items-center mb-5">
                    <h1 class="section-label">Our Trends Apparel</h1>
                    <a href="{{ url('shop-trends') }}">
                        <button
                            class="btn btn-primary shadow-none bg-transparent rounded-circle text-black p-3 align-bottom button-alt type2-alt">
                            <span class="btn-text-alt">View All Products</span>
                        </button>
                    </a>
                </div>

                <hr class="mb-5">

                {{-- BIG SCREEN --}}
                <div class="d-lg-block d-none d-sm-none">
                    <div id="carouselExampleControls1" class="carousel slide" data-bs-ride="true">
                        <div class="trends carousel-indicators">
                            @foreach ($trends->chunk(4) as $key => $chunked_trends)
                                <button type="button" data-bs-target="#carouselExampleIndicators1"
                                    data-bs-slide-to="{{ $key }}" {{ $loop->first ? 'class=active' : '' }}
                                    aria-label="Slide {{ $key + 1 }}"></button>
                            @endforeach
                        </div>

                        <div class="carousel-inner">
                            @foreach ($trends->chunk(4) as $chunked_trends)
                                <div class="carousel-item {{ $loop->first ? 'active' : '' }}">
                                    <div class="row">
                                        @foreach ($chunked_trends as $items)
                                            <div class="col-12 col-xl-3">
                                                <div class="image-container overflow-hidden position-relative">
                                                    <img src="{{ asset('uploads/trends/' . $items->thumbnail) }}"
                                                        class="d-block w-100 mb-5 img-product-home rounded-5 img-product-home"
                                                        alt="...">
                                                    <div
                                                        class="home-overlay position-absolute translate-middle w-100 top-50 start-50">
                                                        <a href="{{ url('product-view-trends/' . $items->name) }}">
                                                            <div
                                                                class="d-flex justify-content-center align-items-center h-100">
                                                                <div class="rounded-circle p-2 bg-white">
                                                                    <i
                                                                        class="fa-solid fa-cart-shopping text-black fs-5"></i>
                                                                </div>
                                                            </div>
                                                        </a>
                                                    </div>
                                                </div>
                                                <div class="text-center">
                                                    <p class="fw-bold fs-4">{{ $items->name }}</p>
                                                    <p class="fw-bold">P {{ $items->price, 2 }}</p>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            @endforeach
                        </div>

                        <button class="trends carousel-control-prev" type="button"
                            data-bs-target="#carouselExampleControls1" data-bs-slide="prev">
                            <i class="fa-solid fa-angle-left text-black fs-3"></i>
                            <span class="visually-hidden">Previous</span>
                        </button>
                        <button class="trends carousel-control-next" type="button"
                            data-bs-target="#carouselExampleControls1" data-bs-slide="next">
                            <i class="fa-solid fa-angle-right text-black fs-3"></i>
                            <span class="visually-hidden">Next</span>
                        </button>
                    </div>
                </div>

                {{-- SMALL SCREEN --}}
                <div class="d-lg-none d-block d-sm-block">
                    <div id="carouselExampleControls6" class="carousel slide" data-bs-ride="true">
                        <div class="trends carousel-indicators">
                            @foreach ($trends as $key => $items)
                                <button type="button" data-bs-target="#carouselExampleIndicators6"
                                    data-bs-slide-to="{{ $key }}" {{ $key == 0 ? 'class=active' : '' }}
                                    aria-label="Slide {{ $key + 1 }}"></button>
                            @endforeach
                        </div>

                        <div class="carousel-inner">
                            @foreach ($trends as $key => $items)
                                <div class="carousel-item {{ $key == 0 ? 'active' : '' }}">
                                    <div class="image-container">
                                        <img src="{{ asset('uploads/trends/' . $items->thumbnail) }}"
                                            class="d-block w-100 mb-5 img-product-home rounded-5 img-product-home"
                                            alt="...">
                                        <div class="home-overlay">
                                            <a href="{{ url('product-view-trends/' . $items->name) }}">
                                                <div class="d-flex justify-content-center align-items-center h-100">
                                                    <div class="rounded-circle p-2 bg-white">
                                                        <i class="fa-solid fa-cart-shopping text-black fs-5"></i>
                                                    </div>
                                                </div>
                                            </a>
                                        </div>
                                        <div class="text-center">
                                            <p class="fw-bold fs-4">{{ $items->name }}</p>
                                            <p class="fw-bold">P {{ $items->price, 2 }}</p>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>

                        <button class="trends carousel-control-prev opacity-0" type="button"
                            data-bs-target="#carouselExampleControls6" data-bs-slide="prev">
                            <i class="fa-solid fa-angle-left text-black fs-3"></i>
                            <span class="visually-hidden">Previous</span>
                        </button>
                        <button class="trends carousel-control-next opacity-0" type="button"
                            data-bs-target="#carouselExampleControls6" data-bs-slide="next">
                            <i class="fa-solid fa-angle-right text-black fs-3"></i>
                            <span class="visually-hidden">Next</span>
                        </button>
                    </div>
                </div>
            </div>

            <div class="container mt-5">
                <div class="d-flex justify-content-between align-items-center mb-5">
                    <h1 class="section-label">Our Skin Essentials</h1>
                    <a href="{{ url('shop-skin') }}">
                        <button
                            class="btn btn-primary shadow-none bg-transparent rounded-circle text-black p-3 align-bottom button-alt type2-alt">
                            <span class="btn-text-alt">View All Products</span>
                        </button>
                    </a>
                </div>

                <hr class="mb-5">

                {{-- BIG SCREEN --}}
                <div class="d-lg-block d-none d-sm-none">
                    <div id="carouselExampleControls2" class="carousel slide" data-bs-ride="true">
                        <div class="trends carousel-indicators">
                            @foreach ($skins->chunk(4) as $key => $chunked_skins)
                                <button type="button" data-bs-target="#carouselExampleIndicators2"
                                    data-bs-slide-to="{{ $key }}" {{ $loop->first ? 'class=active' : '' }}
                                    aria-label="Slide {{ $key + 1 }}"></button>
                            @endforeach
                        </div>

                        <div class="carousel-inner">
                            @foreach ($skins->chunk(4) as $chunked_skins)
                                <div class="carousel-item {{ $loop->first ? 'active' : '' }}">
                                    <div class="row">
                                        @foreach ($chunked_skins as $items)
                                            <div class="col-12 col-xl-3">
                                                <div class="image-container">
                                                    <img src="{{ asset('uploads/skins/' . $items->thumbnail) }}"
                                                        class="d-block w-100 mb-5 img-product-home rounded-5 img-product-home"
                                                        alt="...">
                                                    <div class="home-overlay">
                                                        <a href="{{ url('product-view-skin/' . $items->name) }}">
                                                            <div
                                                                class="d-flex justify-content-center align-items-center h-100">
                                                                <div class="rounded-circle p-2 bg-white">
                                                                    <i
                                                                        class="fa-solid fa-cart-shopping text-black fs-5"></i>
                                                                </div>
                                                            </div>
                                                        </a>
                                                    </div>
                                                    <div class="text-center">
                                                        <p class="fw-bold fs-4">{{ $items->name }}</p>
                                                        <p class="fw-bold">P {{ $items->price, 2 }}</p>
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            @endforeach
                        </div>

                        <button class="trends carousel-control-prev" type="button"
                            data-bs-target="#carouselExampleControls2" data-bs-slide="prev">
                            <i class="fa-solid fa-angle-left text-black fs-3"></i>
                            <span class="visually-hidden">Previous</span>
                        </button>
                        <button class="trends carousel-control-next" type="button"
                            data-bs-target="#carouselExampleControls2" data-bs-slide="next">
                            <i class="fa-solid fa-angle-right text-black fs-3"></i>
                            <span class="visually-hidden">Next</span>
                        </button>
                    </div>
                </div>

                <div class="d-lg-none d-block d-sm-block">
                    <div id="carouselExampleControls7" class="carousel slide" data-bs-ride="true">
                        <div class="trends carousel-indicators">
                            @foreach ($skins as $key => $items)
                                <button type="button" data-bs-target="#carouselExampleIndicators7"
                                    data-bs-slide-to="{{ $key }}" {{ $key == 0 ? 'class=active' : '' }}
                                    aria-label="Slide {{ $key + 1 }}"></button>
                            @endforeach
                        </div>

                        <div class="carousel-inner">
                            @foreach ($skins as $key => $items)
                                <div class="carousel-item {{ $key == 0 ? 'active' : '' }}">
                                    <div class="image-container">
                                        <img src="{{ asset('uploads/skins/' . $items->thumbnail) }}"
                                            class="d-block w-100 mb-5 img-product-home rounded-5 img-product-home"
                                            alt="...">
                                        <div class="home-overlay">
                                            <a href="{{ url('product-view-skin/' . $items->name) }}">
                                                <div class="d-flex justify-content-center align-items-center h-100">
                                                    <div class="rounded-circle p-2 bg-white">
                                                        <i class="fa-solid fa-cart-shopping text-black fs-5"></i>
                                                    </div>
                                                </div>
                                            </a>
                                        </div>
                                        <div class="text-center">
                                            <p class="fw-bold fs-4">{{ $items->name }}</p>
                                            <p class="fw-bold">P {{ $items->price, 2 }}</p>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>

                        <button class="trends carousel-control-prev opacity-0" type="button"
                            data-bs-target="#carouselExampleControls7" data-bs-slide="prev">
                            <i class="fa-solid fa-angle-left text-black fs-3"></i>
                            <span class="visually-hidden">Previous</span>
                        </button>
                        <button class="trends carousel-control-next opacity-0" type="button"
                            data-bs-target="#carouselExampleControls7" data-bs-slide="next">
                            <i class="fa-solid fa-angle-right text-black fs-3"></i>
                            <span class="visually-hidden">Next</span>
                        </button>
                    </div>
                </div>

            </div>
        </div>
    </section>

    {{-- OUR STORY --}}
    <section class="overflow-hidden">
        <div class="container mb-5 py-5 my-5">
            <div class="d-flex justify-content-center">
                <div class="row d-flex justify-content-center">
                    <div class="col-12">
                        <div class="row g-5">
                            <div class="col-md">
                                <img src="{{ asset('resources/_web resources/about-img.png') }}" class="img-fluid"
                                    alt="">
                            </div>
                            <div class="col-md d-flex align-items-center">
                                <div>
                                    <h1 class="mb-5 section-label">Our Story</h1>
                                    <p class="justify mb-5">
                                        Our owner and founder, Ms. Edelyn Gonzalvo, also known
                                        as Ms. eg, draws her inspiration from her parents, who
                                        instilled in her the value of creativity, hard work, and
                                        determination. With her passion for fashion and her
                                        innovative ideas, Ms. eg began selling her unique
                                        clothing designs online during the pandemic and quickly
                                        gained popularity on TikTok.
                                    </p>

                                    <div class="center mt-3">
                                        <a href="{{ url('about-us') }}">
                                            <button
                                                class="btn btn-primary shadow-none bg-transparent rounded-circle text-black p-3 align-bottom button-alt type1-alt">
                                                <span class="btn-text">Learn More</span>
                                            </button>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    {{-- BLOGS --}}
    <section class="overflow-hidden">
        <div class="bg-alt container-fluid my-5 py-5">
            <div class="container">

                <div class="d-flex justify-content-center">
                    <div class="row gy-5">

                        @if ($big_blog)
                            <div class="col-md col-blog px-5">
                                <img src="{{ asset('uploads/blogs/' . $big_blog->thumbnail) }}"
                                    class="img-fluid mb-5 big-img-home rounded-4" alt="">
                                <h4 class="fw-bold mb-5">{{ $big_blog->title }}</h4>
                                <p class="mb-5 justify">
                                    {!! Str::limit($big_blog->description, 100, '...') !!}
                                </p>
                                <a href="{{ url('blog-single/' . $big_blog->title) }}" class="text-black"><span
                                        class="fw-bold">Read More</span></a>
                            </div>
                        @endif

                        <div class="col-md col-blog px-5 d-flex align-items-center">
                            <div class="mt-3">
                                <h1 class="section-label mb-5 ">Latest Blogs</h1>

                                @foreach ($blogs as $item)
                                    <div class="row gy-5 mb-5">
                                        <div class="col-md">
                                            <img src="{{ asset('uploads/blogs/' . $item->thumbnail) }}"
                                                class="img-fluid small-img-home rounded-4" alt="">
                                        </div>
                                        <div class="col-md d-flex align-items-center">
                                            <div>
                                                <h4 class="fw-bold mb-5">{{ $item->title }}</h4>
                                                <p class="mb-5">
                                                    {!! Str::limit($item->description, 100, '...') !!}
                                                </p>
                                                <a href="{{ url('blog-single/' . $item->title) }}"
                                                    class="text-black"><span class="fw-bold">Read More</span></a>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach

                            </div>
                        </div>

                    </div>
                </div>

            </div>
        </div>
    </section>
@endsection

@section('css')
    <style>
        @media only screen and (max-width: 600px) {
            .mb-5 {
                margin-bottom: 1rem !important
            }

            .col-blog {
                padding-left: 1rem !important;
                padding-right: 1rem !important;
            }
        }
    </style>
@endsection
