@extends('frontend.layouts.app')

@section('seo')
<title>Shop Product | eg APPAREL</title>
<meta property="og:locale"          content="en_US" />
<meta property="og:url"             content="" />
<meta property="og:type"            content="website" />
<meta property="og:title"           content="Shop Product | eg APPAREL" />
<meta property="og:description"     content="" />
<meta property="og:site_name"       content="Shop Product | eg APPAREL" />
<meta property="og:image"           content="{{ asset('resources/web_thumb.jpg') }}" />
<meta property="og:thumbnail"       content="{{ asset('resources/web_thumb.jpg') }}" />
@endsection

@section('content')
<div class="container py-5">

  <section>
    <div class="row mb-5 gy-5">
      <div class="col-sm-12 col-md-12 col-lg-6">
        <div class="row gy-5">
          <div class="col-sm-12 col-md-12 col-lg-4 order-1 order-lg-0">
            <div class="nav nav-tabs border-bottom-0" id="myTab" role="tablist">
              <div class="row g-4">
                @php
                  $images = json_decode($skins->multiple_images) ?? [];
                @endphp
        
                @foreach ($images as $key => $multiple_images)
                  <div class="col-4 col-sm-4 col-md-4 col-lg-12 text-center">
                    <a class="img-link text-end {{ $key === 0 ? ' active' : '' }}" data-bs-toggle="tab" href="#img{{ $key + 1 }}" role="tab" aria-controls="nav-home" aria-selected="{{ $key === 0 ? 'true' : 'false' }}">
                      <img src="{{ asset('uploads/' . $multiple_images)}}" class="img-small rounded-0 rounded-3" alt="">
                    </a>
                  </div>
                @endforeach
        
              </div>
            </div>
          </div>
        
          <div class="col-sm-12 col-md-12 col-lg-6 order-0 order-lg-1">
            <div class="tab-content" id="myTabContent">

              @foreach ($images as $key => $multiple_images)
                <div class="tab-pane fade {{ $key === 0 ? ' show active' : '' }}" id="img{{ $key + 1 }}" role="tabpanel" tabindex="0">
                  <img src="{{ asset('uploads/' . $multiple_images) }}" class="img-big rounded-3" alt="">
                </div>
              @endforeach
            </div>
          </div>
        </div>
      </div>
      
      <div class="col-sm-12 col-md-12 col-lg-6">
        <div class="vstack gap-4">
          <h1>{{ $skins->name }}</h1>
          <h2 class="color-nude fw-bold">P {{ number_format($skins->price, 2) }}</h2>
          <span>Skin Care</span>
  
          <form action="{{ url('cart/' . $skins->id) }}">
          <input type="hidden" name="shop" value="skins">
          <div>
            <span class="fw-bold">Qty</span>
            <div class="row">
              <div class="col-sm-100 col-lg-8">
                <div class="row g-3 mt-2">
                  {{-- <div class="col-6 col-sm-6 col-md-6 col-lg-4 d-flex align-items-center">
                    <div class="hstack gap-0">
                      <button type="button" id="minus" class="p-3 border-0 rounded-start bg-light">-</button>
                      <input class="count p-3 text-center w-100 border-0 bg-light" type="text" id="input" name="quantity" min="1" value="1" max="100" />
                      <button type="button" id="plus" class="p-3 border-0 rounded-end bg-light">+</button>
                    </div>
                  </div> --}}
                  <div class="col-6 col-sm-6 col-md-6 col-lg-8">
                    <button {{ $skins->stocks <= $quantity ? 'disabled' : '' }}
                      class="btn btn-cart text-white p-3">Add to Cart <i class="fa-solid fa-cart-shopping"></i>
                    </button><br>
                    @if ($skins->stocks == 0 || $skins->stocks <= $quantity)
                      <span class="text-danger">Out of Stocks</span>
                    @endif
                  </div>
                </div>
              </div>
            </div>
          </div>
          </form>

        </div>
      </div>
    </div>
  </section>

  <section>
    <div class="nav nav-tabs d-block border-bottom-0 mb-5" id="myTab" role="tablist">
      <div class="row">
        <div class="col-sm-12 col-md-12 col-lg-4 d-flex align-items-center justify-content-center">
          <div class="border w-100"></div>
        </div>
        <div class="col-sm-12 col-md-12 col-lg-4">
          <div class="row">
            <div class="col-12 d-flex align-items-center">
              <div class="d-flex justify-content-center w-100">
                <div class="nav-item" role="presentation">
                  <a class="info-link fs-5 fw-bold active" id="home-tab" data-bs-toggle="tab" data-bs-target="#description" type="button" role="tab" aria-controls="home-tab-pane" aria-selected="true">Ingredients</a>
                </div>
              </div>
            </div>
            {{-- <div class="col-sm-12 col-md-6 col-lg-6 d-flex align-items-center">
              <div class="d-flex justify-content-center w-100">
                <div class="nav-item" role="presentation">
                  <a class="info-link fs-5 fw-bold" id="contact-tab" data-bs-toggle="tab" data-bs-target="#reviews" type="button" role="tab" aria-controls="contact-tab-pane" aria-selected="false">Reviews (1)</a>
                </div>
              </div>
            </div> --}}
          </div>
        </div>
        <div class="col-sm-12 col-md-12 col-lg-4 d-flex align-items-center justify-content-center">
          <div class="border w-100"></div>
        </div>
      </div>
    </div>
    <div class="tab-content mb-5" id="myTabContent">
      <div class="tab-pane fade show active" id="description" role="tabpanel" aria-labelledby="home-tab" tabindex="0">
        <h3 class="fw-bold">Products Information</h3>
        <p class="justify mb-5">
          {!! $skins->description !!}
        </p>

        <h3 class="fw-bold">Material used</h3>
        <p class="justify">
          {!! $skins->ingredients !!}
        </p>

      </div>
      <div class="tab-pane fade" id="information" role="tabpanel" aria-labelledby="profile-tab" tabindex="0">...</div>
      <div class="tab-pane fade" id="reviews" role="tabpanel" aria-labelledby="contact-tab" tabindex="0">...</div>
    </div>
  </section>

</div>

<section>
  <div class="container-fluid bg-alt">
    <div class="container py-5">
      <div class="d-flex justify-content-center">
        <div class="row g-5 w-100">
          <div class="col-sm-12 col-md-12 col-lg-3 d-flex justify-content-center align-items-center">
            <div class="hstack gap-3">
              <i class="fa-solid fa-hand-holding-dollar fs-4"></i>
              <div>
                <span class="fs-5 fw-bold">Free Delivery</span><br>
                <span>For all order over 99$</span>
              </div>
            </div>
          </div>
          <div class="col-sm-12 col-md-12 col-lg-3 d-flex justify-content-center align-items-center">
            <div class="hstack gap-3">
              <i class="fa-solid fa-coins fs-4"></i>
              <div>
                <span class="fs-5 fw-bold">30 Days Return</span><br>
                <span>If goods have Problems</span>
              </div>
            </div>
          </div>
          <div class="col-sm-12 col-md-12 col-lg-3 d-flex justify-content-center align-items-center">
            <div class="hstack gap-3">
              <i class="fa-regular fa-credit-card fs-4"></i>
              <div>
                <span class="fs-5 fw-bold">Secure Payment</span><br>
                <span>100% secure payment</span>
              </div>
            </div>
          </div>
          <div class="col-sm-12 col-md-12 col-lg-3 d-flex justify-content-center align-items-center">
            <div class="hstack gap-3">
              <i class="fa-solid fa-headset fs-4"></i>
              <div>
                <span class="fs-5 fw-bold">24/7 Support</span><br>
                <span>Dedicated support</span>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  </section>
@endsection

@section('js')
<script>
  const minusButton = document.getElementById('minus');
  const plusButton = document.getElementById('plus');
  const inputField = document.getElementById('input');
  const maxQuantity = parseInt(inputField.getAttribute('max'));
  const minQuantity = parseInt(inputField.getAttribute('min'));

  minusButton.addEventListener('click', event => {
      event.preventDefault();
      const currentValue = Number(inputField.value) || minQuantity;
      if (currentValue > minQuantity) {
          inputField.value = currentValue - 1;
      }
      toggleButtonStates();
  });

  plusButton.addEventListener('click', event => {
      event.preventDefault();
      const currentValue = Number(inputField.value) || minQuantity;
      if (currentValue < maxQuantity) {
          inputField.value = currentValue + 1;
      }
      toggleButtonStates();
  });

  inputField.addEventListener('input', () => {
      let quantity = parseInt(inputField.value) || minQuantity;
      quantity = Math.max(minQuantity, Math.min(maxQuantity, quantity));
      inputField.value = quantity.toString();
      toggleButtonStates();
  });

  toggleButtonStates();

  function toggleButtonStates() {
      const currentValue = Number(inputField.value) || minQuantity;
      minusButton.disabled = currentValue <= minQuantity;
      plusButton.disabled = currentValue >= maxQuantity;
  }
</script>
@endsection