@extends('frontend.layouts.app')

@section('seo')
<title>Shop Product | eg APPAREL</title>
<meta property="og:locale"          content="en_US" />
<meta property="og:url"             content="" />
<meta property="og:type"            content="website" />
<meta property="og:title"           content="Shop Product | eg APPAREL" />
<meta property="og:description"     content="" />
<meta property="og:site_name"       content="Shop Product | eg APPAREL" />
<meta property="og:image"           content="{{ asset('resources/web_thumb.jpg') }}" />
<meta property="og:thumbnail"       content="{{ asset('resources/web_thumb.jpg') }}" />
@endsection

@section('content')
<div class="container py-5">

  <section>
    <div class="row mb-5 gy-5">
      <div class="col-sm-12 col-md-12 col-lg-6">
        <div class="tab-content" id="myTabContent">
          @foreach ($trends->colors as $key => $item)
          @php
          $color_images = json_decode($item->color_images) ?? [];
          @endphp
          <div class="tab-pane fade {{ $key === 0 ? 'show active' : '' }}" id="color-content-{{ $item->id }}" role="tabpanel" aria-labelledby="color-tab-{{ $item->id }}" tabindex="0">
            <div class="row gy-5">
              <div class="col-sm-12 col-md-12 col-lg-4 order-1 order-lg-0">
                  <div class="nav nav-tabs border-bottom-0" id="myTab{{ $key }}" role="tablist">
                      <div class="row g-4">
                          @foreach ($color_images as $imageKey => $color_image)
                          <div class="col-4 col-md-12 col-xl-12 text-center">
                              <a class="nav-item product-link p-0 text-center {{ $imageKey === 0 ? ' active' : '' }}" id="nav-img{{ $imageKey + 1 }}-tab-{{ $item->id }}" data-bs-toggle="tab" href="#img-tab-{{ $item->id }}-{{ $imageKey }}" role="tab" aria-controls="nav-home" aria-selected="{{ $imageKey === 0 ? 'true' : 'false' }}">
                                  <img src="{{ asset('uploads/' . $color_image) }}" class="img-nav-shop rounded-3" alt="">
                              </a>
                          </div>
                          @endforeach
                      </div>
                  </div>
              </div>
              <div class="col-sm-12 col-md-12 col-lg-6 order-0 order-lg-1">
                  <div class="tab-content" id="myTabContent{{ $key }}">
                      @foreach ($color_images as $imageKey => $color_image)
                      <div class="tab-pane fade {{ $imageKey === 0 ? ' show active' : '' }}" id="img-tab-{{ $item->id }}-{{ $imageKey }}" role="tabpanel" tabindex="0">
                          <center>
                              <img src="{{ asset('uploads/' . $color_image) }}" class="img-fluid rounded-3" alt="">
                          </center>
                      </div>
                      @endforeach
                  </div>
              </div>
          </div>
          
          </div>
          @endforeach
        </div>
    </div>
    
    
      <div class="col-sm-12 col-md-12 col-lg-6">
        <div class="vstack gap-4">
          <h1 class="text-uppercase">{{ $trends->name }}</h1>
          <h2 class="color-trends fw-bold">P {{ number_format($trends->price, 2) }}</h2>
          <div>
            <span>{{ $trends->category }}</span>
            @if ($trends->type != null)
              <span> | {{ $trends->type }}</span>
            @endif
            @if ($trends->sub_type != null)
            <span> | {{ $trends->sub_type }}</span>
            @endif
          </div>
  
          <form action="{{ url('cart/' . $trends->id) }}">

            <input type="hidden" name="shop" value="trends">

          <div>
            <span class="fw-bold">Colors</span>
            <div class="nav nav-tabs border-0" id="myTab" role="tablist">
              <div class="row w-100">
                  <div class="col-12 col-md-8 col-xl-8">
                      <div class="row g-3 w-100">
                          @foreach ($trends->colors as $key => $item)
                          <div class="col-6 col-sm-4 col-md-3 col-xl-3 text-center">
                              <input type="radio" id="color-{{ $item->id }}" name="color" class="d-none color-link {{ $key === 0 ? 'active' : '' }}" value="{{ $item->color }}" required data-bs-toggle="tab" data-bs-target="#color-content-{{ $item->id }}" type="button" role="tab" aria-controls="color-{{ $item->id }}" aria-selected="{{ $key === 0 ? 'true' : 'false' }}">
                              <label class="color-link p-1 bg-white rounded-3 text-black w-100" for="color-{{ $item->id }}">{{ $item->color }}</label>
                          </div>
                          @endforeach
                      </div>
                  </div>
              </div>
            </div>
          
          </div>
  
          <div>

            @foreach ($colors as $color)
            <div class="mt-2 color-sizes" id="color-sizes-{{ $color->id }}" style="display: none;">
                <label class="fw-bold">{{ $color->color }} Sizes:</label>
                <div>
                    @foreach ($color->sizes as $size)
                        <div class="form-check form-check-inline">
<input type="radio" {{ $size->stocks <= 0 ? 'disabled' : '' }} id="size-{{ $color->id }}-{{ $size->id }}" name="size" class="form-check-input size-input" value="{{ $size->size }}" required>
                            <label class="form-check-label" for="size-{{ $color->id }}-{{ $size->id }}">{{ $size->size }}</label>
                        </div>
                    @endforeach
                </div>
            </div>
        @endforeach
        
        
        

          <div>
            {{-- <span class="fw-bold">Qty</span> --}}
            <div class="row">
              <div class="col-sm-100 col-lg-8">
                <div class="row g-3 mt-2">
                  {{-- <div class="col-6 col-sm-6 col-md-6 col-lg-4 d-flex align-items-center">
                    <div class="hstack gap-0">
                      <button type="button" id="minus" class="p-3 border-0 rounded-start bg-light">-</button>
                      <input class="count p-3 text-center w-100 border-0 bg-light" type="text" id="input" name="quantity" min="1" value="1" max="100" />
                      <button type="button" id="plus" class="p-3 border-0 rounded-end bg-light">+</button>
                    </div>
                  </div> --}}
                  <div class="col-6 col-xl-8 d-flex align-items-center">
                    
                      <button class="btn btn-cart-alt text-white p-3">
                        Add to Cart <i class="fa-solid fa-cart-shopping"></i>
                      </button>

                  </div>
                </div>
              </div>
            </div>
          </div>

          </form>

        </div>
      </div>
    </div>
  </section>

  <section>
    <div class="nav nav-tabs d-block border-bottom-0 mb-5" id="myTab" role="tablist">
      <div class="row">
        <div class="col-sm-12 col-md-12 col-lg-4 d-flex align-items-center justify-content-center">
          <div class="border w-100"></div>
        </div>
        <div class="col-sm-12 col-md-12 col-lg-4">
          <div class="row">
            <div class="col-12 d-flex align-items-center">
              <div class="d-flex justify-content-center w-100">
                <div class="nav-item" role="presentation">
                  <a class="info-link fs-5 fw-bold active" id="home-tab" data-bs-toggle="tab" data-bs-target="#description" type="button" role="tab" aria-controls="home-tab-pane" aria-selected="true">Material & Pattern</a>
                </div>
              </div>
            </div>
            {{-- <div class="col-sm-12 col-md-6 col-lg-6 d-flex align-items-center">
              <div class="d-flex justify-content-center w-100">
                <div class="nav-item" role="presentation">
                  <a class="info-link fs-5 fw-bold" id="contact-tab" data-bs-toggle="tab" data-bs-target="#reviews" type="button" role="tab" aria-controls="contact-tab-pane" aria-selected="false">Reviews (1)</a>
                </div>
              </div>
            </div> --}}
          </div>
        </div>
        <div class="col-sm-12 col-md-12 col-lg-4 d-flex align-items-center justify-content-center">
          <div class="border w-100"></div>
        </div>
      </div>
    </div>
    <div class="tab-content mb-5" id="myTabContent">
      <div class="tab-pane fade show active" id="description" role="tabpanel" aria-labelledby="home-tab" tabindex="0">
        <h3 class="fw-bold">Products Information</h3>
          {!! $trends->description !!}

        <h3 class="fw-bold">Material used</h3>
          {!! $trends->materials !!}

      </div>
      <div class="tab-pane fade" id="information" role="tabpanel" aria-labelledby="profile-tab" tabindex="0">...</div>
      <div class="tab-pane fade" id="reviews" role="tabpanel" aria-labelledby="contact-tab" tabindex="0">...</div>
    </div>
  </section>

</div>

<section>
  <div class="container-fluid bg-alt">
    <div class="container py-5">
      <div class="d-flex justify-content-center">
        <div class="row g-5 w-100">
          <div class="col-sm-12 col-md-12 col-lg-3 d-flex justify-content-center align-items-center">
            <div class="hstack gap-3">
              <i class="fa-solid fa-hand-holding-dollar fs-4"></i>
              <div>
                <span class="fs-5 fw-bold">Free Delivery</span><br>
                <span>For all order over 99$</span>
              </div>
            </div>
          </div>
          <div class="col-sm-12 col-md-12 col-lg-3 d-flex justify-content-center align-items-center">
            <div class="hstack gap-3">
              <i class="fa-solid fa-coins fs-4"></i>
              <div>
                <span class="fs-5 fw-bold">30 Days Return</span><br>
                <span>If goods have Problems</span>
              </div>
            </div>
          </div>
          <div class="col-sm-12 col-md-12 col-lg-3 d-flex justify-content-center align-items-center">
            <div class="hstack gap-3">
              <i class="fa-regular fa-credit-card fs-4"></i>
              <div>
                <span class="fs-5 fw-bold">Secure Payment</span><br>
                <span>100% secure payment</span>
              </div>
            </div>
          </div>
          <div class="col-sm-12 col-md-12 col-lg-3 d-flex justify-content-center align-items-center">
            <div class="hstack gap-3">
              <i class="fa-solid fa-headset fs-4"></i>
              <div>
                <span class="fs-5 fw-bold">24/7 Support</span><br>
                <span>Dedicated support</span>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  </section>
@endsection

@section('js')
<script>
  const minusButton = document.getElementById('minus');
  const plusButton = document.getElementById('plus');
  const inputField = document.getElementById('input');
  const maxQuantity = parseInt(inputField.getAttribute('max'));
  const minQuantity = parseInt(inputField.getAttribute('min'));

  minusButton.addEventListener('click', event => {
      event.preventDefault();
      const currentValue = Number(inputField.value) || minQuantity;
      if (currentValue > minQuantity) {
          inputField.value = currentValue - 1;
      }
      toggleButtonStates();
  });

  plusButton.addEventListener('click', event => {
      event.preventDefault();
      const currentValue = Number(inputField.value) || minQuantity;
      if (currentValue < maxQuantity) {
          inputField.value = currentValue + 1;
      }
      toggleButtonStates();
  });

  inputField.addEventListener('input', () => {
      let quantity = parseInt(inputField.value) || minQuantity;
      quantity = Math.max(minQuantity, Math.min(maxQuantity, quantity));
      inputField.value = quantity.toString();
      toggleButtonStates();
  });

  toggleButtonStates();

  function toggleButtonStates() {
      const currentValue = Number(inputField.value) || minQuantity;
      minusButton.disabled = currentValue <= minQuantity;
      plusButton.disabled = currentValue >= maxQuantity;
  }
</script>
<script>
  const colorInputs = document.querySelectorAll('.color-link');
  const sizeSections = document.querySelectorAll('.color-sizes');

  colorInputs.forEach((colorInput) => {
      colorInput.addEventListener('change', () => {
          // Hide all size sections
          sizeSections.forEach((sizeSection) => {
              sizeSection.style.display = 'none';
          });

          // Get the selected color's size section and show it
          const selectedColorId = colorInput.getAttribute('data-bs-target').split('-').pop();
          const selectedSizeSection = document.getElementById(`color-sizes-${selectedColorId}`);
          
          if (selectedSizeSection) {
              selectedSizeSection.style.display = 'block';
          }
      });
  });
</script>



@endsection