@extends('frontend.layouts.app')

@section('seo')
<title>Shop | eg APPAREL</title>
<meta property="og:locale"          content="en_US" />
<meta property="og:url"             content="" />
<meta property="og:type"            content="website" />
<meta property="og:title"           content="Shop | eg APPAREL" />
<meta property="og:description"     content="" />
<meta property="og:site_name"       content="Shop | eg APPAREL" />
<meta property="og:image"           content="{{ asset('resources/web_thumb.jpg') }}" />
<meta property="og:thumbnail"       content="{{ asset('resources/web_thumb.jpg') }}" />
@endsection

@section('content')

{{-- CONTENT --}}
<section>
  <div class="container py-5">
    <div class="row g-5">

      <div class="col-12 col-sm-12 col-md-12 col-lg-3">
        <form id="filter-form" action="{{ url('filter-trends') }}" method="GET">
        <div class="mb-5">
          <h2 class="fw-bold mb-4">Search Products</h2>
          <div class="input-group">
            <span class="input-group-text rounded-0 bg-white border-end-0 bg-grey" id="basic-addon1"><i class="fa-solid fa-magnifying-glass fa-flip-horizontal"></i></span>
            <input type="text" name="query" class="form-control rounded-0 border-start-0 bg-grey p-2 shadow-none" placeholder="Search Here" aria-describedby="basic-addon1">
          </div>
        </div>

        <div class="mb-5">
          <h2 class="fw-bold mb-4">Categories</h2>
          <div class="accordion mb-5" id="accordionExample">
              <div class="row gy-3 justify-content-center">
                <div class="col-12 col-md">
                  <button type="submit" class="btn btn-outline-dark w-100">Filter <i class="fa-solid fa-filter"></i></button>
                </div>
                <div class="col-12 col-md">
                  <a href="{{ url('shop-trends') }}" class="btn w-100 btn-outline-danger mb-3">Clear Filter</a>
                </div>
              </div>
            <div class="accordion-item border-0">
              <h2 class="accordion-header" id="headingOne">
                <button class="trends-category fs-6 text-decoration-none border-0 bg-transparent p-0 collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse1" aria-expanded="true" aria-controls="collapseOne">
                  <label class="form-check-label text-black" for="flexCheckDefault1">
                    Main Category <i class="fa-solid fa-angle-right"></i>
                  </label>
                </button>
              </h2>
              <div id="collapse1" class="accordion-collapse collapse" aria-labelledby="headingOne" data-bs-parent="#accordionExample">
                <div class="accordion-body pt-2">
                  @foreach ($categories as $cat)
                  <div class="form-check">
                    <input class="form-check-input type-checkbox" name="category[]" type="checkbox" value="{{ $cat->name }}" id="category{{ $cat->id }}" data-type="{{ $cat->name }}" {{ in_array($cat->name, (array) request('category')) ? 'checked' : '' }}>
                    <label  class="form-check-label text-black" for="category{{ $cat->id }}">
                      {{ $cat->name }}
                    </label>
                  </div>
                  @endforeach
                </div>
              </div>
            </div>
            <div class="accordion-item border-0">
              <h2 class="accordion-header" id="headingOne">
                <button class="trends-category fs-6 text-decoration-none border-0 bg-transparent p-0 collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse2" aria-expanded="true" aria-controls="collapseOne">
                  <label class="form-check-label text-black" for="flexCheckDefault2">
                    Type <i class="fa-solid fa-angle-right"></i>
                  </label>
                </button>
              </h2>
              <div id="collapse2" class="accordion-collapse collapse {{ in_array('women', request('category', [])) ? 'show' : '' }}" aria-labelledby="headingOne" data-bs-parent="#accordionExample">
                <div class="accordion-body pt-2">
                  @foreach ($types as $type)
                  <div class="form-check">
                    <input class="form-check-input type-checkbox" name="type[]" type="checkbox" value="{{ $type->type }}" id="type{{ $type->id }}" data-type="{{ $type->type }}" {{ in_array($type->type, (array) request('type')) ? 'checked' : '' }}>
                    <label  class="form-check-label text-black" for="type{{ $type->id }}">
                      {{ $type->type }}
                    </label>
                  </div>
                  @endforeach
                </div>
              </div>
            </div>
            <div class="accordion-item border-0">
              <h2 class="accordion-header" id="headingOne">
                <button class="trends-category fs-6 text-decoration-none border-0 bg-transparent p-0 collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse3" aria-expanded="true" aria-controls="collapseOne">
                  <label class="form-check-label text-black" for="flexCheckDefault2">
                    Sub Types <i class="fa-solid fa-angle-right"></i>
                  </label>
                </button>
              </h2>
              <div id="collapse3" class="accordion-collapse collapse {{ in_array('women', request('category', [])) ? 'show' : '' }}" aria-labelledby="headingOne" data-bs-parent="#accordionExample">
                <div class="accordion-body pt-2">
                  @foreach ($sub as $subs)
                  <div class="form-check">
                    <input class="form-check-input type-checkbox" name="sub_type[]" type="checkbox" value="{{ $subs->sub_type }}" id="sub{{ $subs->id }}" data-type="{{ $subs->sub_type }}" {{ in_array($subs->sub_type, (array) request('sub_type')) ? 'checked' : '' }}>
                    <label  class="form-check-label text-black" for="sub{{ $subs->id }}">
                      {{ $subs->sub_type }}
                    </label>
                  </div>
                  @endforeach
                </div>
              </div>
            </div>
          </div>
        </div>

        <h2 class="fw-bold mb-4">Price</h2>
        <div id="slider" class="rounded-4"></div>
        <div class="row mt-4 mb-5">
            <div class="col-6">
                <label for="minValue"></label>
                <span id="minValue" class="color-trends">{{ request('min_price', '') }}</span>
            </div>
            <div class="col-6">
                <label for="maxValue"></label>
                <span id="maxValue" class="color-trends">{{ request('max_price', '') }}</span>
            </div>
        </div>

        <input type="hidden" name="min_price" id="minPrice" value="{{ request('min_price', '') }}">
        <input type="hidden" name="max_price" id="maxPrice" value="{{ request('max_price', '') }}">
{{-- 
        <h2 class="fw-bold mb-4">Size</h2>
        <div class="row">
          <div class="col-8 col-sm-8 col-lg-12">
            <div class="row gx-0 gy-3">
                <div class="col-6 col-sm-6 col-md-3 col-lg-3">
                    <input type="checkbox" id="size-xs" name="size[]" class="btn rounded-0" value="xsmall" {{ (is_array(old('size')) && in_array('xsmall', old('size'))) || (is_array(request('size')) && in_array('xsmall', request('size'))) ? 'checked' : '' }}>
                    <label for="size-xs">XS</label>
                </div>
                <div class="col-6 col-sm-6 col-md-3 col-lg-3">
                    <input type="checkbox" id="size-s" name="size[]" class="btn rounded-0" value="small" {{ (is_array(old('size')) && in_array('small', old('size'))) || (is_array(request('size')) && in_array('small', request('size'))) ? 'checked' : '' }}>
                    <label for="size-s">S</label>
                </div>
                <div class="col-6 col-sm-6 col-md-3 col-lg-3">
                    <input type="checkbox" id="size-m" name="size[]" class="btn rounded-0" value="medium" {{ (is_array(old('size')) && in_array('medium', old('size'))) || (is_array(request('size')) && in_array('medium', request('size'))) ? 'checked' : '' }}>
                    <label for="size-m">M</label>
                </div>
                <div class="col-6 col-sm-6 col-md-3 col-lg-3">
                    <input type="checkbox" id="size-l" name="size[]" class="btn rounded-0" value="large" {{ (is_array(old('size')) && in_array('large', old('size'))) || (is_array(request('size')) && in_array('large', request('size'))) ? 'checked' : '' }}>
                    <label for="size-l">L</label>
                </div>
                <div class="col-6 col-sm-6 col-md-3 col-lg-3">
                    <input type="checkbox" id="size-xl" name="size[]" class="btn rounded-0" value="xlarge" {{ (is_array(old('size')) && in_array('xlarge', old('size'))) || (is_array(request('size')) && in_array('xlarge', request('size'))) ? 'checked' : '' }}>
                    <label for="size-xl">XL</label>
                </div>
                <div class="col-6 col-sm-6 col-md-3 col-lg-3">
                    <input type="checkbox" id="size-free" name="size[]" class="btn rounded-0" value="freesize" {{ (is_array(old('size')) && in_array('freesize', old('size'))) || (is_array(request('size')) && in_array('freesize', request('size'))) ? 'checked' : '' }}>
                    <label for="size-free">Free Size</label>
                </div>
            </div>
          </div>
        </div> --}}
        </form>
      </div>

      <div class="col-12 col-sm-12 col-md-12 col-lg-8">
        <div class="mb-5">
          <h1 class="section-label">eg Trends Apparel</h1>
          <nav aria-label="breadcrumb" class="mb-5">
            <ol class="breadcrumb">
              <li class="breadcrumb-item alt"><a href="{{ url('/') }}" class="text-black text-decoration-none fw-bold">Home</a></li>
              <li class="breadcrumb-item alt active" aria-current="page">Shop</li>
            </ol>
          </nav>
  
          <div class="row g-5">
            
            @foreach ($trends as $items)
            <div class="col-sm-12 col-md-12 col-lg-4 trend-item">
              <div class="image-container">
                <img src="{{ asset('uploads/trends/' . $items->thumbnail)}}" class="d-block w-100 mb-5 img-shop rounded-5" alt="...">
                <div class="overlay">
                  <div class="d-flex justify-content-center align-items-center">
                    <a href="{{ url('product-view-trends/' . $items->name) }}">
                      <div class="rounded-circle p-2 bg-white">
                        <i class="fa-solid fa-cart-shopping text-black fs-5"></i>
                      </div>
                    </a>
                  </div>
                </div>
                <div class="text-center">
                  <p class="fw-bold fs-4">{{ $items->name }}</p>
                  <p class="fw-bold color-trends">P {{ number_format($items->price, 2) }}</p>
                </div>
              </div>
            </div>
            @endforeach

          </div>
        </div>

        {{-- <div class="d-flex justify-content-center">
          <nav aria-label="Page navigation example">
            <ul class="pagination">
              <li class="page-item">
                <a class="page-link py-1 px-3" href="#" aria-label="Previous">
                  <i class="fa-solid fa-chevron-left"></i>
                </a>
              </li>
              <li class="page-item"><a class="page-link py-1 px-3" href="#">1</a></li>
              <li class="page-item"><a class="page-link py-1 px-3 active" href="#">2</a></li>
              <li class="page-item"><a class="page-link py-1 px-3" href="#">3</a></li>
              <li class="page-item">
                <a class="page-link py-1 px-3" href="#" aria-label="Next">
                  <i class="fa-solid fa-chevron-right"></i>
                </a>
              </li>
            </ul>
          </nav>
        </div> --}}

        <div class="d-flex justify-content-center">
          @if ($trends->hasPages())
            <ul class="pagination pagination">
  
            @if ($trends->currentPage() == 1)
                <a class="page-link py-1 px-3" href="#" aria-label="Previous">
                  <i class="fa-solid fa-chevron-left"></i>
                </a>
            @else
                <li class="page-item"><a class="page-link py-1 px-3" href="{{ $trends->previousPageUrl() }}" rel="prev"><i class="fa-solid fa-chevron-left"></i></a></li>
            @endif
            
        
        
                @if($trends->currentPage() > 3)
                    <li class="page-item hidden-xs"><a class="page-link py-1 px-3" href="{{ $trends->url(1) }}">1</a></li>
                @endif
                @if($trends->currentPage() > 4)
                    <li><span>...</span></li>
                @endif
                @foreach(range(1, $trends->lastPage()) as $i)
                    @if($i >= $trends->currentPage() - 2 && $i <= $trends->currentPage() + 2)
                        @if ($i == $trends->currentPage())
                            <li class="page-item"><span class="page-link py-1 px-3 active">{{ $i }}</span></li>
                        @else
                            <li><a class="page-link py-1 px-3" href="{{ $trends->url($i) }}">{{ $i }}</a></li>
                        @endif
                    @endif
                @endforeach
                @if($trends->currentPage() < $trends->lastPage() - 3)
                    <li class="page-link py-1 px-3"><span>...</span></li>
                @endif
                @if($trends->currentPage() < $trends->lastPage() - 2)
                    <li class="page-item hidden-xs"><a class="page-link py-1 px-3" href="{{ $trends->url($trends->lastPage()) }}">{{ $trends->lastPage() }}</a></li>
                @endif
        
  
                @if ($trends->hasMorePages())
                <li class="page-item"><a class="page-link py-1 px-3" href="{{ $trends->previousPageUrl() }}" rel="prev"><i class="fa-solid fa-chevron-right"></i></a></li>
                @else
                <a class="page-link py-1 px-3" href="#" aria-label="Next">
                  <i class="fa-solid fa-chevron-right"></i>
                </a>
                @endif
            </ul>
          @endif
        </div>

      </div>
    </div>
  </div>
</section>

{{-- INFO --}}
<section>
<div class="container-fluid bg-alt">
  <div class="container py-5">
    <div class="d-flex justify-content-center">
      <div class="row g-5 w-100">
        <div class="col-sm-12 col-md-12 col-lg-3 d-flex justify-content-center align-items-center">
          <div class="hstack gap-3">
            <i class="fa-solid fa-hand-holding-dollar fs-4"></i>
            <div>
              <span class="fs-5 fw-bold">Free Delivery</span><br>
              <span>For all order over 99$</span>
            </div>
          </div>
        </div>
        <div class="col-sm-12 col-md-12 col-lg-3 d-flex justify-content-center align-items-center">
          <div class="hstack gap-3">
            <i class="fa-solid fa-coins fs-4"></i>
            <div>
              <span class="fs-5 fw-bold">30 Days Return</span><br>
              <span>If goods have Problems</span>
            </div>
          </div>
        </div>
        <div class="col-sm-12 col-md-12 col-lg-3 d-flex justify-content-center align-items-center">
          <div class="hstack gap-3">
            <i class="fa-regular fa-credit-card fs-4"></i>
            <div>
              <span class="fs-5 fw-bold">Secure Payment</span><br>
              <span>100% secure payment</span>
            </div>
          </div>
        </div>
        <div class="col-sm-12 col-md-12 col-lg-3 d-flex justify-content-center align-items-center">
          <div class="hstack gap-3">
            <i class="fa-solid fa-headset fs-4"></i>
            <div>
              <span class="fs-5 fw-bold">24/7 Support</span><br>
              <span>Dedicated support</span>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
</section>
@endsection

@section('css')
<style>
  .noUi-connect{
  background-color: #fc4c1b !important;
}
</style>
@endsection

@section('js')
{{-- <script>
  document.addEventListener("DOMContentLoaded", function () {
      const checkboxes = document.querySelectorAll(".form-check-input");
      checkboxes.forEach(checkbox => {
          checkbox.addEventListener("change", function () {
              document.getElementById("filter-form").submit();
          });
      });
  });
</script> --}}
<script>
  // Get the accordion button element
var accordionButton = document.querySelector('.accordion-header button');

// Get the checkbox element
var checkbox = document.querySelector('.category-checkbox');

// Add a click event listener to the accordion button
accordionButton.addEventListener('click', function() {
  // Check if the accordion button is expanded or collapsed
  var isExpanded = accordionButton.getAttribute('aria-expanded') === 'true';
  
  // Toggle the checkbox based on the accordion button state
  checkbox.checked = isExpanded;
});
</script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/noUiSlider/14.6.1/nouislider.min.js"></script>
<script>
  var slider = document.getElementById('slider');
  var minValue = document.getElementById('minValue');
  var maxValue = document.getElementById('maxValue');
  var minPrice = document.getElementById('minPrice');
  var maxPrice = document.getElementById('maxPrice');

  noUiSlider.create(slider, {
    start: [{{ request('min_price', '100') }}, {{ request('max_price', '5000') }}], // Initial values for the handles
    connect: true,
    range: {
      'min': 0,
      'max': 10000
    },
    format: {
      to: function (value) {
        return parseInt(value);
      },
      from: function (value) {
        return value.toString();
      }
    }
  });

  slider.noUiSlider.on('update', function (values, handle) {
    if (handle === 0) {
      minValue.innerText = values[handle];
      minPrice.value = values[handle];
    }
    if (handle === 1) {
      maxValue.innerText = values[handle];
      maxPrice.value = values[handle];
    }
  });
</script>
@endsection