<?php

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Frontend\CartController;
use App\Http\Controllers\Frontend\PageController;
use App\Http\Controllers\Backend as BackendController;
use App\Http\Controllers\Frontend as FrontendController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', [PageController::class, 'home']);
Route::get('/about-us', [PageController::class, 'aboutUs']);
Route::get('/shop-skin', [PageController::class, 'shopSkin']);
Route::get('/shop-trends', [PageController::class, 'shopTrends']);
Route::get('/shop-skin-single', [PageController::class, 'shopSkinSingle']);
Route::get('/shop-trends-single', [PageController::class, 'shopTrendsSingle']);
Route::get('/blogs', [PageController::class, 'blogs']);
Route::get('/brands', [PageController::class, 'brands']);
Route::get('/careers', [PageController::class, 'careers']);
Route::get('/career-single', [PageController::class, 'careerSingle']);
Route::get('/contact-us', [PageController::class, 'contactUs']);
Route::get('/my-cart', [PageController::class, 'myCart']);
Route::get('/checkout', [PageController::class, 'checkout']);
Route::get('/payment-success', [PageController::class, 'paySuccess']);
Route::get('/payment-error', [PageController::class, 'payError']);


// SEARCH PRODUCTS
Route::get('/search-trends', [PageController::class, 'searchTrend']);
Route::get('/search-skins', [PageController::class, 'searchSkin']);

// PAYMENT
Route::get('payment', [CartController::class, 'payment'])->name('payment');
Route::post('payment', [CartController::class, 'payment'])->name('payment');

// CART
Route::resource('cart', CartController::class);

// PRODUCT VIEW
Route::resource('product-view-trends', FrontendController\ProductViewTrendController::class);
Route::resource('product-view-skin', FrontendController\ProductViewSkinController::class);

//SINGLE PAGE
Route::resource('/blog-single', FrontendController\BlogController::class);
Route::resource('/career-single', FrontendController\CareerController::class);

// CONTACT FORM
Route::post('contact', [PageController::class, 'contact'])->name('contact');

// FILTER TRENDS 
Route::get('filter-trends', [PageController::class, 'trendFilter'])->name('trendFilter');
Route::get('filter-skins', [PageController::class, 'skinFilter'])->name('skinFilter');

Route::get('/success', [App\Http\Controllers\ResponseController::class, 'success'])->name('success');
Route::get('/error', [App\Http\Controllers\ResponseController::class, 'error'])->name('error');

// DEFAULT AUTH ROUTES
Auth::routes();

// AUTH USER ACCESS
Route::middleware(['auth', 'user-access:user'])->group(function () {
});

// AUTH CMS ACCESS
Route::get('/admin/login', [ BackendController\AuthController::class, 'login' ])->name('admin.login');
Route::post('/admin/login', [ BackendController\AuthController::class, 'signIn' ])->name('admin.signin');
Route::prefix('admin')->middleware(['auth', 'user-access:cms'])->group(function () {
    Route::post('/logout', [ BackendController\AuthController::class, 'logout' ])->name('admin.logout');

    Route::get('dashboard', [ BackendController\DashboardController::class, 'index' ]);

    Route::resource('orders', BackendController\OrderController::class);
    Route::resource('categories', BackendController\CategoryController::class);
    Route::resource('types', BackendController\TypeController::class);
    Route::resource('sub-types', BackendController\SubTypeController::class);
    Route::resource('brands', BackendController\BrandController::class);
    Route::resource('inquiries', BackendController\InquiryController::class);
    Route::resource('vouchers', BackendController\VoucherController::class);
    Route::resource('careers', BackendController\CareerController::class);
    Route::resource('blogs', BackendController\BlogController::class);
    Route::resource('banners', BackendController\BannerController::class);
    Route::resource('skins', BackendController\ProductSkinController::class);
    Route::resource('trends', BackendController\ProductTrendController::class);
    Route::resource('add-colors', BackendController\AddColorController::class);
    Route::resource('add-sizes', BackendController\AddSizeController::class);
    Route::resource('voucher-skins', BackendController\VoucherSkinController::class);
    Route::resource('voucher-trends', BackendController\VoucherTrendController::class);
    Route::get('add-colors/{id}/create', [BackendController\AddColorController::class, 'create'])->name('add-colors.create');
});