

<?php $__env->startSection('content'); ?>

<div class="p-3">
    <div class="card">
        <div class="card-header fw-bold">
          <span class="fw-bold">Inquiries</span>&emsp;
        </div>
        <div class="card-body">
            <table class="table table-striped" style="width:100%">
                <thead>
                  <tr>
                    <th style="width: 10%">ID</th>
                    <th style="width: 10%">Reference #</th>
                    <th>Customer Info</th>
                    <th>Items</th>
                    <th>Total Amount</th>
                    <th>Order Status</th>
                    <th>Date & Time to Pick up / Deliver</th>
                    <th>Action</th>
                  </tr>
                </thead>
                
                <tbody>
                  <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <tr>
                      <td><?php echo e($order->id); ?></td>
                      <td><?php echo e($order->reference); ?></td>
                      <td>
                        <?php echo e($order->first_name); ?> <?php echo e($order->last_name); ?> <br>
                        <?php echo e($order->phone); ?> <br>
                      </td>
                      <td>
                        
                        <?php
                        $items = json_decode($order->item);
                        $quantities = json_decode($order->quantity);
                        $colors = json_decode($order->color);
                        $sizes = json_decode($order->size);
                      ?>
                      
                      <?php if(empty($colors) && empty($sizes)): ?>
                        <?php if($items && $quantities): ?>
                          <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php echo e($quantities[$index]); ?> x <?php echo e($item); ?> (Skincare)<br>
                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                      <?php else: ?>
                        <?php if($items && $quantities && $colors && $sizes): ?>
                          <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                              $color = isset($colors[$index]) ? $colors[$index] : null;
                              $size = isset($sizes[$index]) ? $sizes[$index] : null;
                            ?>
                      
                            <?php if(empty($color) && empty($size)): ?>
                              <?php echo e($quantities[$index]); ?> x <?php echo e($item); ?> (Skincare)<br>
                            <?php else: ?>
                              <?php echo e($quantities[$index]); ?> x <?php echo e($item); ?> (Color: <?php echo e($color); ?>, Size: <?php echo e($size); ?>)<br>
                            <?php endif; ?>
                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                      <?php endif; ?>
                      
                      
                      </td>
                      <td>P <?php echo e(number_format($order->total, 2)); ?></td>
                      <td><?php echo e($order->order_status); ?></td>
                      <td>
                        <?php echo e(date('F d, Y', strtotime($order->assigned_date))); ?> at <?php echo e(date('h:i A', strtotime($order->assigned_time))); ?>

                      </td>
                      <td>
                        <div>
                          <button type="button" class="btn btn-success btn-block mb-1" data-toggle="modal" data-target="#exampleModal<?php echo e($order->id); ?>"> View </button>
                          <?php if($order->payment_status == 'Unpaid'): ?>
                          <form action="<?php echo e(url('admin/orders/' . $order->id)); ?>" method="POST" class="d-inline">
                              <input type="hidden" value="Paid" name="payment_status" />
                              <?php echo csrf_field(); ?> <?php echo method_field('PUT'); ?>
                              <button type="submit" class="btn btn-primary btn-block mb-1">
                                  Paid
                              </button>
                          </form>
                          <?php endif; ?>
                          <a href="<?php echo e(url('admin/orders/' . $order->id)); ?>/edit">
                              <button type="button" class="btn btn-outline-primary btn-block mb-1"> Edit </button>
                          </a>
                          <form action="<?php echo e(url('admin/orders/' . $order->id )); ?>" method="POST"> <?php echo csrf_field(); ?> <?php echo method_field('delete'); ?>
                            <button class="btn btn-danger btn-block" type="submit">Delete</button>
                          </form>

                          <div class="modal fade" id="exampleModal<?php echo e($order->id); ?>" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                            <div class="modal-dialog" role="document">
                              <div class="modal-content">
            
                                <div class="modal-body">
                                  <div  class="modal-title" id="exampleModalLabel">
            
                                    <div class="mb-2">
                                        <span class="font-weight-bold">Order No</span><br>
                                        <span>#<?php echo e($order->reference); ?></span><br>
                                    </div>
        
                                    <div class="mb-2">
                                        <span class="font-weight-bold">Customer Info</span><br>
                                        <span>Customer Name:&nbsp; <?php echo e($order->first_name); ?> <?php echo e($order->last_name); ?></span><br>
                                        <span>Address:&nbsp; <?php echo e($order->address); ?></span><br>
                                        <span>Email:&nbsp; <?php echo e($order->email); ?></span><br>
                                        <span>Contact No:&nbsp; <?php echo e($order->phone); ?></span>
                                    </div>
        
                                    <div class="mb-2">
                                        <span class="font-weight-bold">Customer Order Info</span><br>
                                        <?php
                                        $items = json_decode($order->item);
                                        $quantities = json_decode($order->quantity);
                                        ?>
                                        <?php if($items && $quantities): ?>
                                          <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php echo e($quantities[$index]); ?> x <?php echo e($item); ?><br>
                                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                        <span>Date of Order:&nbsp; <?php echo e(date('F d, Y', strtotime($order->created_at))); ?></span><br>
                                        <span>Payment Method:&nbsp; <span class="text-uppercase"><b><?php echo e($order->payment_method); ?></b></span></span><br>
                                        <span>Payment Status:&nbsp; <?php echo e($order->payment_status); ?></span><br>
                                        <span>Service Type: &nbsp; <?php echo e($order->service_type); ?></span><br>
                                        <span><?php echo e($order->service_type); ?> Date: &nbsp; <?php echo e(date('F d, Y', strtotime($order->assigned_date))); ?></span><br>
                                        <span><?php echo e($order->service_type); ?> Time: &nbsp; <?php echo e(date('h:i A', strtotime($order->assigned_time))); ?></span><br>
                                        <span>Customer Note: &nbsp; <?php echo e($order->notes); ?></span>
                                    </div>
            
                                  </div>
                                </div>
            
                                <div class="modal-footer">
                                  <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                </div>
            
                              </div>
                            </div>
                          </div>
                        </div>
                      </td>
                  </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
              </table>
        </div>
    </div>
</div>


<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.js"></script>
<script>
  $(document).ready(function () {
    $('.table').DataTable({
      "order": [[0, "desc"]]
    });
  });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\czed\EG APPAREL\EG APPAREL\resources\views/backend/modules/orders/index.blade.php ENDPATH**/ ?>