

<?php $__env->startSection('content'); ?>

<div class="p-3">
    <div class="row">
        <div class="col-12 col-md-8">
            <div class="card mb-3">
                <div class="card-header fw-bold">
                    <div class="float-left">
                        Edit Product
                    </div>
                    <div class="float-right">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb bg-white mb-0 p-0">
                                <li class="breadcrumb-item"><a href="<?php echo e(url('admin/trends')); ?>">Trends Apparel</a></li>
                                <li class="breadcrumb-item"><a href="<?php echo e(url('admin/trends/' . $colors->product_trend_id . '/edit')); ?>">Edit Color</a></li>
                                <li class="breadcrumb-item active" aria-current="page">Edit Size</li>
                            </ol>
                        </nav>
                    </div>
                </div>
                <div class="card-body">
                    <form action="<?php echo e(url('admin/add-colors/' . $colors->id)); ?>" method="POST" enctype="multipart/form-data"><?php echo csrf_field(); ?> <?php echo method_field('put'); ?>
                        <div class="row">
        
                            <div class="col-12 mb-3">
                                <label for="">Color Name</label>
                                <input type="text" class="form-control" required name="color" value="<?php echo e($colors->color); ?>" />
                                <?php $__errorArgs = ['color'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="text-danger">
                                        <?php echo e($message); ?>

                                    </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-12 mb-3">
                                <label for="">Product Color Images</label>
                                <input type="file" class="form-control" name="color_images[]" multiple/>
        
                                <?php $__errorArgs = ['color_images'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="text-danger">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
        
                            <div class="col-12 text-right">
                                <button type="submit" class="btn btn-success">Add Color</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            <div class="card">
                <div class="card-header">
                    Current Product Images
                </div>
                <div class="card-body">
                    <?php
                    $images = json_decode($colors->color_images) ?? [];
                    ?>
                    <?php $__currentLoopData = $images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $color_images): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <img src="<?php echo e(asset('uploads/' . $color_images)); ?>" class="mx-1" height="80" alt="">
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
        <div class="col-12 col-md-4">
            <form method="POST" action="<?php echo e(url('admin/add-sizes?trend_color_id=' . $colors->id)); ?>" enctype="multipart/form-data"><?php echo csrf_field(); ?>
                <div class="card mb-3">
                    <div class="card-header">
                        Add Size
                    </div>
                    <div class="card-body p-2">
                        <div class="row">
                            <div class="col-12 form-group">
                                <label>Size:</label>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="size" id="size_xs" value="Extra Small" <?php echo e(old('size') === 'Extra Small' ? 'checked' : ''); ?>>
                                    <label class="form-check-label" for="size_xs">
                                        Extra Small
                                    </label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="size" id="size_s" value="Small" <?php echo e(old('size') === 'Small' ? 'checked' : ''); ?>>
                                    <label class="form-check-label" for="size_s">
                                        Small
                                    </label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="size" id="size_m" value="Medium" <?php echo e(old('size') === 'Medium' ? 'checked' : ''); ?>>
                                    <label class="form-check-label" for="size_m">
                                        Medium
                                    </label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="size" id="size_l" value="Large" <?php echo e(old('size') === 'Large' ? 'checked' : ''); ?>>
                                    <label class="form-check-label" for="size_l">
                                        Large
                                    </label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="size" id="size_xl" value="Extra Large" <?php echo e(old('size') === 'Extra Large' ? 'checked' : ''); ?>>
                                    <label class="form-check-label" for="size_xl">
                                        Extra Large
                                    </label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="size" id="size_freesize" value="Freesize" <?php echo e(old('size') === 'Freesize' ? 'checked' : ''); ?>>
                                    <label class="form-check-label" for="size_freesize">
                                        Freesize
                                    </label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="size" id="size_plus" value="Plus Size" <?php echo e(old('size') === 'Plus Size' ? 'checked' : ''); ?>>
                                    <label class="form-check-label" for="size_plus">
                                        Plus Size
                                    </label>
                                </div>
                                <?php $__errorArgs = ['size'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <code><?php echo e($message); ?></code>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            
                            <div class="col-12 form-group">
                                <label>Stocks</label>
                                <input class="form-control" type="text" name="stocks" value="<?php echo e(old('stocks')); ?>">
                                <?php $__errorArgs = ['stocks'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <code><?php echo e($message); ?></code>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer text-right">
                        <button type="submit" class="btn btn-success">Add Size</button>
                    </div>
                </div>
                </form>

                <div class="card">
                    <div class="card-header">
                        Sizes:
                    </div>
                    <div class="card-body">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>Size</th>
                                    <th>Stocks</th>
                                    <th style="width: 10%:">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $colors->sizes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $items): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($items->size); ?></td>
                                    <td><?php echo e($items->stocks); ?></td>
                                    <td class="d-flex">
                                        <form action="<?php echo e(url('admin/add-sizes/' . $items->id)); ?>" class="mx-3" method="POST">
                                            <?php echo csrf_field(); ?> <?php echo method_field('delete'); ?>
                                            <button type="submit" class="btn btn-danger">
                                                Delete
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
        </div>
    </div>
</div>

<?php $__env->startSection('css'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.js"></script>
<script>
    $(document).ready(function() {
        $('.table').DataTable({
            order: [['0', 'asc']]
        });
    });
</script>
<?php $__env->stopSection(); ?>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rweb/public_html/egapparel/resources/views/backend/modules/add-colors/edit.blade.php ENDPATH**/ ?>