<?php

namespace App\Http\Controllers\Admin\Page;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Project;
use Validator;
use Str;

class ProjectController extends Controller
{
    public function index()
    {
        $data = Project::latest()->get();
        return view('module.projects.index', compact('data'));
    }


    public function create()
    {
        return view('module.projects.create');
    }


    public function store(Request $request)
    {
        $request->validate([
            'client_id' => 'required',
            'title' => 'required',
        ]);

        Project::create([
            'client_id' => $request->client_id,
            'title' => $request->title,
            'operating_unit' => $request->operating_unit,
            'project' => $request->project,
            'clients' => $request->clients,
            'work' => $request->work,
            'area' => $request->area,
            'division' => $request->division,
            'man_hours' => $request->man_hours,
            'content' => $request->content,
            'status' => $request->status,
        ]);

        return redirect('admin/projects')->with('success', 'Successfully added new Project');
    }


    public function show($id)
    {
        //
    }


    public function edit($id)
    {
        $data = Project::findOrFail($id);
        return view('module.projects.update', compact('data'));
    }


    public function update(Request $request, $id)
    {

        $data = Project::findOrFail($id);

        $data->update([
            'client_id' => $request->client_id,
            'title' => $request->title,
            'operating_unit' => $request->operating_unit,
            'project' => $request->project,
            'clients' => $request->clients,
            'work' => $request->work,
            'area' => $request->area,
            'division' => $request->division,
            'man_hours' => $request->man_hours,
            'content' => $request->content,
            'status' => $request->status,
            'active' => $request->active,
        ]);

        return back()->with('success', 'Successfully updated Project');
    }


    public function destroy($id)
    {
        // return $id;
        $data = Project::findOrFail($id);
        $data->delete();
        
        return back()->with('success', 'Successfully deleted Project');
    }

    public function uploadFile($path, $file){
        $path = public_path().$path;
        $filename = date_format(date_create(), 'mdyHis').Str::random(5).'.'. $file->getClientOriginalExtension();
        $file->move($path, $filename);
        return $filename;
    }
}
